/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Priority;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.resources.DefaultResourceLoader;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.ServiceLoader;
import org.jboss.weld.util.reflection.Reflections;

class AdditionalServiceLoader {
    private static final int DEFAULT_PLATFORM_PRIORITY = 4500;
    private final Deployment deployment;

    AdditionalServiceLoader(Deployment deployment) {
        this.deployment = deployment;
    }

    void loadAdditionalServices(ServiceRegistry registry) {
        for (ResourceLoader loader : this.getResourceLoaders()) {
            for (Metadata<Service> metadata : ServiceLoader.load(Service.class, loader)) {
                Service service = metadata.getValue();
                for (Class<? extends Service> serviceInterface : this.identifyServiceInterfaces(service.getClass(), new HashSet<Class<? extends Service>>())) {
                    this.put(registry, serviceInterface, service);
                }
            }
        }
    }

    private Set<Class<? extends Service>> identifyServiceInterfaces(Class<?> clazz, Set<Class<? extends Service>> serviceInterfaces) {
        if (clazz == null || Object.class.equals(clazz) || BootstrapService.class.equals(clazz)) {
            return serviceInterfaces;
        }
        for (Class<?> interfac3 : clazz.getInterfaces()) {
            if (!Service.class.equals(interfac3) && !BootstrapService.class.equals(interfac3)) continue;
            serviceInterfaces.add((Class<? extends Service>)Reflections.cast(clazz));
        }
        for (Class<?> interfac3 : clazz.getInterfaces()) {
            this.identifyServiceInterfaces(interfac3, serviceInterfaces);
        }
        this.identifyServiceInterfaces(clazz.getSuperclass(), serviceInterfaces);
        return serviceInterfaces;
    }

    private <T extends Service> void put(ServiceRegistry registry, Class<T> key, Service value) {
        T previous = registry.get(key);
        if (previous == null) {
            BootstrapLogger.LOG.debugv("Installing additional service {0} ({1})", key.getName(), value.getClass());
            registry.add(key, (Service)Reflections.cast(value));
        } else if (this.shouldOverride((Class<? extends Service>)key, (Service)previous, value)) {
            BootstrapLogger.LOG.debugv("Overriding service implementation for {0}. Previous implementation {1} is replaced with {2}", key.getName(), previous.getClass().getName(), value.getClass().getName());
            registry.add(key, (Service)Reflections.cast(value));
        }
    }

    protected boolean shouldOverride(Class<? extends Service> key, Service previous, Service next) {
        return this.getPriority(next) > this.getPriority(previous);
    }

    private int getPriority(Service service) {
        Priority priority = service.getClass().getAnnotation(Priority.class);
        if (priority != null) {
            return priority.value();
        }
        return 4500;
    }

    private Set<ResourceLoader> getResourceLoaders() {
        HashSet<ResourceLoader> resourceLoaders = new HashSet<ResourceLoader>();
        for (BeanDeploymentArchive archive : this.deployment.getBeanDeploymentArchives()) {
            ResourceLoader resourceLoader = archive.getServices().get(ResourceLoader.class);
            if (resourceLoader == null) continue;
            resourceLoaders.add(resourceLoader);
        }
        resourceLoaders.add(WeldClassLoaderResourceLoader.INSTANCE);
        resourceLoaders.add(DefaultResourceLoader.INSTANCE);
        return resourceLoaders;
    }
}

