/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.enablement;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.bootstrap.enablement.EnablementListView;
import org.jboss.weld.bootstrap.enablement.Item;
import org.jboss.weld.bootstrap.enablement.ModuleEnablement;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.logging.LogMessageCallback;
import org.jboss.weld.logging.MessageCallback;
import org.jboss.weld.logging.ValidatorLogger;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.ImmutableMap;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Reflections;

public class GlobalEnablementBuilder
extends AbstractBootstrapService {
    private final List<Item> alternatives = Collections.synchronizedList(new ArrayList());
    private final List<Item> interceptors = Collections.synchronizedList(new ArrayList());
    private final List<Item> decorators = Collections.synchronizedList(new ArrayList());
    private volatile Map<Class<?>, Integer> cachedAlternativeMap;
    private volatile boolean sorted;
    private volatile boolean dirty;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addItem(List<Item> list, Class<?> javaClass, int priority) {
        this.sorted = false;
        this.dirty = true;
        List<Item> list2 = list;
        synchronized (list2) {
            int scaling;
            int originalPriority = priority;
            if (!list.isEmpty() && (scaling = list.get(0).getNumberOfScaling()) > 0) {
                priority *= new BigInteger("10").pow(scaling).intValue();
            }
            list.add(new Item(javaClass, originalPriority, priority));
        }
    }

    public void addAlternative(Class<?> javaClass, int priority) {
        this.addItem(this.alternatives, javaClass, priority);
    }

    public void addInterceptor(Class<?> javaClass, int priority) {
        this.addItem(this.interceptors, javaClass, priority);
    }

    public void addDecorator(Class<?> javaClass, int priority) {
        this.addItem(this.decorators, javaClass, priority);
    }

    public List<Class<?>> getAlternativeList() {
        this.initialize();
        return new EnablementListView(){

            @Override
            protected List<Item> getDelegate() {
                return GlobalEnablementBuilder.this.alternatives;
            }
        };
    }

    public List<Class<?>> getInterceptorList() {
        this.initialize();
        return new EnablementListView(){

            @Override
            protected List<Item> getDelegate() {
                return GlobalEnablementBuilder.this.interceptors;
            }
        };
    }

    public List<Class<?>> getDecoratorList() {
        this.initialize();
        return new EnablementListView(){

            @Override
            protected List<Item> getDelegate() {
                return GlobalEnablementBuilder.this.decorators;
            }
        };
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private Map<Class<?>, Integer> getGlobalAlternativeMap() {
        if (this.cachedAlternativeMap == null || this.dirty) {
            HashMap map = new HashMap();
            ListIterator<Item> iterator = this.alternatives.listIterator();
            while (iterator.hasNext()) {
                Item item = iterator.next();
                map.put(item.getJavaClass(), iterator.previousIndex());
            }
            this.cachedAlternativeMap = ImmutableMap.copyOf(map);
        }
        return this.cachedAlternativeMap;
    }

    private void initialize() {
        if (!this.sorted) {
            Collections.sort(this.alternatives);
            Collections.sort(this.interceptors);
            Collections.sort(this.decorators);
            this.sorted = true;
        }
    }

    public ModuleEnablement createModuleEnablement(BeanDeployment deployment) {
        ClassLoader loader = new ClassLoader(deployment.getBeanManager().getServices().get(ResourceLoader.class));
        BeansXml beansXml = deployment.getBeanDeploymentArchive().getBeansXml();
        Set alternativeClasses = null;
        Set alternativeStereotypes = null;
        List<Class<?>> globallyEnabledInterceptors = this.getInterceptorList();
        List<Class<?>> globallyEnabledDecorators = this.getDecoratorList();
        ImmutableList.Builder<Class<?>> moduleInterceptorsBuilder = ImmutableList.builder();
        moduleInterceptorsBuilder.addAll((Iterable<Class<?>>)globallyEnabledInterceptors);
        ImmutableList.Builder<Class<?>> moduleDecoratorsBuilder = ImmutableList.builder();
        moduleDecoratorsBuilder.addAll((Iterable<Class<?>>)globallyEnabledDecorators);
        if (beansXml != null) {
            this.checkForDuplicates(beansXml.getEnabledInterceptors(), ValidatorLogger.INTERCEPTOR_SPECIFIED_TWICE);
            this.checkForDuplicates(beansXml.getEnabledDecorators(), ValidatorLogger.DECORATOR_SPECIFIED_TWICE);
            this.checkForDuplicates(beansXml.getEnabledAlternativeClasses(), ValidatorLogger.ALTERNATIVE_CLASS_SPECIFIED_MULTIPLE_TIMES);
            this.checkForDuplicates(beansXml.getEnabledAlternativeStereotypes(), ValidatorLogger.ALTERNATIVE_STEREOTYPE_SPECIFIED_MULTIPLE_TIMES);
            List<Class<?>> interceptorClasses = beansXml.getEnabledInterceptors().stream().map(loader).collect(Collectors.toList());
            moduleInterceptorsBuilder.addAll((Iterable<Class<?>>)this.filter(interceptorClasses, globallyEnabledInterceptors, ValidatorLogger.INTERCEPTOR_ENABLED_FOR_APP_AND_ARCHIVE, deployment));
            List<Class<?>> decoratorClasses = beansXml.getEnabledDecorators().stream().map(loader).collect(Collectors.toList());
            moduleDecoratorsBuilder.addAll((Iterable<Class<?>>)this.filter(decoratorClasses, globallyEnabledDecorators, ValidatorLogger.DECORATOR_ENABLED_FOR_APP_AND_ARCHIVE, deployment));
            alternativeClasses = (Set)beansXml.getEnabledAlternativeClasses().stream().map(loader).collect(ImmutableSet.collector());
            alternativeStereotypes = (Set)Reflections.cast(beansXml.getEnabledAlternativeStereotypes().stream().map(loader).collect(ImmutableSet.collector()));
        } else {
            alternativeClasses = Collections.emptySet();
            alternativeStereotypes = Collections.emptySet();
        }
        Map<Class<?>, Integer> globalAlternatives = this.getGlobalAlternativeMap();
        this.dirty = false;
        return new ModuleEnablement(moduleInterceptorsBuilder.build(), moduleDecoratorsBuilder.build(), globalAlternatives, alternativeClasses, alternativeStereotypes);
    }

    @Override
    public void cleanupAfterBoot() {
        this.alternatives.clear();
        this.interceptors.clear();
        this.decorators.clear();
    }

    public String toString() {
        return "GlobalEnablementBuilder [alternatives=" + this.alternatives + ", interceptors=" + this.interceptors + ", decorators=" + this.decorators + "]";
    }

    private <T> void checkForDuplicates(List<Metadata<T>> list, MessageCallback<DeploymentException> messageCallback) {
        HashMap<T, Metadata<T>> map = new HashMap<T, Metadata<T>>();
        for (Metadata<T> item : list) {
            Metadata<T> previousOccurrence = map.put(item.getValue(), item);
            if (previousOccurrence == null) continue;
            throw messageCallback.construct(item.getValue(), item, previousOccurrence);
        }
    }

    private <T> List<Class<?>> filter(List<Class<?>> enabledClasses, List<Class<?>> globallyEnabledClasses, LogMessageCallback logMessageCallback, BeanDeployment deployment) {
        Iterator<Class<?>> iterator = enabledClasses.iterator();
        while (iterator.hasNext()) {
            Class<?> enabledClass = iterator.next();
            if (!globallyEnabledClasses.contains(enabledClass)) continue;
            logMessageCallback.log(enabledClass, deployment.getBeanDeploymentArchive().getId());
            iterator.remove();
        }
        return enabledClasses;
    }

    private static class ClassLoader
    implements Function<Metadata<String>, Class<?>> {
        private final ResourceLoader resourceLoader;

        public ClassLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        @Override
        public Class<?> apply(Metadata<String> from) {
            try {
                return this.resourceLoader.classForName(from.getValue());
            }
            catch (ResourceLoadingException e) {
                throw BootstrapLogger.LOG.errorLoadingBeansXmlEntry(from.getValue(), from.getLocation(), e.getCause());
            }
            catch (Exception e) {
                throw BootstrapLogger.LOG.errorLoadingBeansXmlEntry(from.getValue(), from.getLocation(), e);
            }
        }
    }
}

