/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.Prioritized;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.Container;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.InstanceImpl;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.bootstrap.enablement.ModuleEnablement;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.Description;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.context.AbstractConversationContext;
import org.jboss.weld.event.ExtensionObserverMethodImpl;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.injection.producer.AbstractMemberProducer;
import org.jboss.weld.injection.producer.ProducerFieldProducer;
import org.jboss.weld.injection.producer.ProducerMethodProducer;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.Components;
import org.jboss.weld.probe.EventInfo;
import org.jboss.weld.probe.Invocation;
import org.jboss.weld.probe.Json;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.probe.ProbeLogger;
import org.jboss.weld.probe.Queries;
import org.jboss.weld.probe.Resource;
import org.jboss.weld.probe.Strings;
import org.jboss.weld.util.AnnotationApiAbstraction;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.collections.Sets;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

final class JsonObjects {
    private static final int CONTEXTUAL_INSTANCE_TO_STRING_LIMIT = 100;
    private static final int CONTEXTUAL_INSTANCE_PROPERTY_VALUE_LIMIT = 500;

    private JsonObjects() {
    }

    static String createDeploymentJson(BeanManagerImpl beanManager, Probe probe) {
        Map<BeanDeploymentArchive, BeanManagerImpl> beanDeploymentArchivesMap = Container.instance(beanManager).beanDeploymentArchives();
        Json.JsonObjectBuilder deploymentBuilder = Json.objectBuilder();
        deploymentBuilder.add("initTs", probe.getInitTs());
        deploymentBuilder.add("contextId", beanManager.getContextId());
        deploymentBuilder.add("version", Formats.getSimpleVersion());
        Json.JsonArrayBuilder bdasBuilder = Json.arrayBuilder();
        ArrayList<BeanDeploymentArchive> bdas = new ArrayList<BeanDeploymentArchive>(beanDeploymentArchivesMap.keySet());
        Collections.sort(bdas, probe.getBdaComparator());
        for (BeanDeploymentArchive bda : bdas) {
            Iterator<Class<? extends Annotation>> decorator2;
            Json.JsonObjectBuilder bdaBuilder = JsonObjects.createSimpleBdaJson(bda.getId());
            BeansXml beansXml = bda.getBeansXml();
            bdaBuilder.add("beanDiscoveryMode", beansXml != null ? beansXml.getBeanDiscoveryMode().toString() : BeanDiscoveryMode.ANNOTATED.toString());
            Json.JsonObjectBuilder enablementBuilder = Json.objectBuilder(true);
            ModuleEnablement enablement = beanDeploymentArchivesMap.get(bda).getEnabled();
            Json.JsonArrayBuilder interceptors = Json.arrayBuilder();
            for (Class clazz : Components.getSortedProbeComponetCandidates(enablement.getInterceptors())) {
                interceptors.add(JsonObjects.decorateProbeComponent(clazz, JsonObjects.createSimpleBeanJson(JsonObjects.findEnabledBean(clazz, Components.BeanKind.INTERCEPTOR, probe), probe)));
            }
            enablementBuilder.add("interceptors", interceptors);
            Json.JsonArrayBuilder decorators = Json.arrayBuilder();
            for (Iterator<Class<? extends Annotation>> decorator2 : enablement.getDecorators()) {
                decorators.add(JsonObjects.createSimpleBeanJson(JsonObjects.findEnabledBean(decorator2, Components.BeanKind.DECORATOR, probe), probe));
            }
            enablementBuilder.add("decorators", decorators);
            Json.JsonArrayBuilder jsonArrayBuilder = Json.arrayBuilder();
            for (Class clazz : Sets.union(enablement.getAlternativeClasses(), enablement.getGlobalAlternatives())) {
                jsonArrayBuilder.add(JsonObjects.createSimpleBeanJson(JsonObjects.findAlternativeBean(clazz, probe), probe));
            }
            decorator2 = enablement.getAlternativeStereotypes().iterator();
            while (decorator2.hasNext()) {
                Class<? extends Annotation> clazz = decorator2.next();
                Set<Bean<?>> beans = JsonObjects.findAlternativeStereotypeBeans(clazz, probe);
                if (beans.isEmpty()) continue;
                for (Bean<?> bean : beans) {
                    jsonArrayBuilder.add(JsonObjects.createSimpleBeanJson(bean, probe));
                }
            }
            enablementBuilder.add("alternatives", jsonArrayBuilder);
            bdaBuilder.add("enablement", enablementBuilder);
            BeanManagerImpl manager = beanDeploymentArchivesMap.get(bda);
            Json.JsonArrayBuilder jsonArrayBuilder2 = Json.arrayBuilder();
            for (BeanManagerImpl accesible : manager.getAccessibleManagers()) {
                jsonArrayBuilder2.add(Components.getId(accesible.getId()));
            }
            bdaBuilder.add("accessibleBdas", jsonArrayBuilder2);
            bdaBuilder.add("beans", Components.getNumberOfEnabledBeans(manager));
            bdasBuilder.add(bdaBuilder);
        }
        deploymentBuilder.add("bdas", bdasBuilder);
        ArrayList configurationKeys = new ArrayList();
        Collections.addAll(configurationKeys, ConfigurationKey.values());
        Collections.sort(configurationKeys, new Comparator<ConfigurationKey>(){

            @Override
            public int compare(ConfigurationKey o1, ConfigurationKey o2) {
                return o1.get().compareTo(o2.get());
            }
        });
        Json.JsonArrayBuilder configBuilder = Json.arrayBuilder();
        WeldConfiguration configuration = beanManager.getServices().get(WeldConfiguration.class);
        for (ConfigurationKey key : configurationKeys) {
            Object value;
            Object defaultValue = key.getDefaultValue();
            String desc = "";
            try {
                Field field = ConfigurationKey.class.getDeclaredField(key.toString());
                if (field != null && field.isEnumConstant()) {
                    Description description = field.getAnnotation(Description.class);
                    if (description == null) continue;
                    desc = description.value();
                }
            }
            catch (Exception field) {
                // empty catch block
            }
            if (defaultValue instanceof Boolean) {
                value = configuration.getBooleanProperty(key);
            } else if (defaultValue instanceof Long) {
                value = configuration.getLongProperty(key);
            } else if (defaultValue instanceof Integer) {
                value = configuration.getIntegerProperty(key);
            } else {
                if (!(defaultValue instanceof String)) continue;
                value = configuration.getStringProperty(key);
            }
            configBuilder.add(Json.objectBuilder().add("name", key.get()).add("defaultValue", defaultValue.toString()).add("value", value.toString()).add("description", desc));
        }
        deploymentBuilder.add("configuration", configBuilder);
        deploymentBuilder.add("contexts", JsonObjects.createContextsJson(beanManager, probe));
        return deploymentBuilder.build();
    }

    static Bean<?> findEnabledBean(Class<?> beanClass, Components.BeanKind kind, Probe probe) {
        for (Bean<?> bean : probe.getBeans()) {
            if (!kind.equals((Object)Components.BeanKind.from(bean)) || !beanClass.equals(bean.getBeanClass())) continue;
            return bean;
        }
        return null;
    }

    static Bean<?> findAlternativeBean(Class<?> beanClass, Probe probe) {
        for (Bean<?> bean : probe.getBeans()) {
            if (!bean.isAlternative() || !beanClass.equals(bean.getBeanClass())) continue;
            return bean;
        }
        return null;
    }

    static Set<Bean<?>> findAlternativeStereotypeBeans(Class<? extends Annotation> stereotype, Probe probe) {
        HashSet beans = new HashSet();
        for (Bean<?> bean : probe.getBeans()) {
            if (!bean.isAlternative() || !bean.getStereotypes().contains(stereotype)) continue;
            beans.add(bean);
        }
        return beans;
    }

    static String createBeansJson(Queries.Page<Bean<?>> page, Probe probe, BeanManagerImpl beanManager, Resource.Representation representation) {
        Json.JsonArrayBuilder beansBuilder = Json.arrayBuilder();
        if (representation == null) {
            representation = Resource.Representation.BASIC;
        }
        block4: for (Bean<?> bean : page.getData()) {
            switch (representation) {
                case SIMPLE: {
                    beansBuilder.add(JsonObjects.createSimpleBeanJsonWithDependencies(bean, probe));
                    continue block4;
                }
                case FULL: {
                    beansBuilder.add(JsonObjects.createFullBeanJson(bean, false, false, beanManager, probe));
                    continue block4;
                }
            }
            beansBuilder.add(JsonObjects.createBasicBeanJson(bean, probe));
        }
        return JsonObjects.createPageJson(page, beansBuilder);
    }

    static Json.JsonObjectBuilder createBasicBeanJson(Bean<?> bean, Probe probe) {
        Json.JsonObjectBuilder beanBuilder = JsonObjects.createSimpleBeanJson(bean, probe);
        beanBuilder.add("scope", JsonObjects.simplifiedScope(bean.getScope()));
        Json.JsonArrayBuilder typesBuilder = Json.arrayBuilder();
        for (Type type : JsonObjects.sortTypes(bean.getTypes())) {
            if (Object.class.equals((Object)type)) continue;
            typesBuilder.add(Formats.formatType(type, false));
        }
        beanBuilder.add("types", typesBuilder);
        if (bean.getQualifiers() != null && !bean.getQualifiers().isEmpty()) {
            beanBuilder.add("qualifiers", JsonObjects.createQualifiers(bean.getQualifiers(), true));
        }
        if (bean.isAlternative()) {
            beanBuilder.add("isAlternative", true);
        }
        return beanBuilder;
    }

    static String createFullBeanJson(Bean<?> bean, boolean transientDependencies, boolean transientDependents, BeanManagerImpl beanManager, Probe probe) {
        Json.JsonArrayBuilder dependents;
        Json.JsonObjectBuilder beanBuilder = JsonObjects.createBasicBeanJson(bean, probe);
        if (bean.getName() != null) {
            beanBuilder.add("name", bean.getName());
        }
        if (bean.getStereotypes() != null && !bean.getStereotypes().isEmpty()) {
            Json.JsonArrayBuilder stereotypesBuilder = Json.arrayBuilder();
            for (Class stereotype : Components.getSortedProbeComponetCandidates(bean.getStereotypes())) {
                stereotypesBuilder.add(Json.objectBuilder().add("class", stereotype.getName()).add("probeComponent", Components.isProbeComponent(stereotype)));
            }
            beanBuilder.add("stereotypes", stereotypesBuilder);
        }
        if (bean instanceof SessionBean) {
            SessionBean sessionBean = (SessionBean)bean;
            if (sessionBean.getEjbDescriptor().getEjbName() != null) {
                beanBuilder.add("ejbName", true);
            }
            beanBuilder.add("sessionBeanType", Components.getSessionBeanType(sessionBean.getEjbDescriptor()).toString());
        } else if (bean instanceof AbstractProducerBean) {
            AbstractMemberProducer producer;
            AbstractProducerBean producerBean = (AbstractProducerBean)bean;
            if (producerBean.getDeclaringBean() != null) {
                beanBuilder.add("declaringBean", JsonObjects.createSimpleBeanJson(producerBean.getDeclaringBean(), probe));
            }
            if (producerBean.getProducer() instanceof ProducerMethodProducer) {
                producer = (ProducerMethodProducer)producerBean.getProducer();
                if (producer.getDisposalMethod() != null) {
                    beanBuilder.add("disposalMethod", JsonObjects.annotatedMethodToString(producer.getDisposalMethod().getAnnotated(), bean.getBeanClass()));
                }
                beanBuilder.add("producerMethod", JsonObjects.annotatedMethodToString((AnnotatedMethod)((ProducerMethodProducer)producer).getAnnotated(), bean.getBeanClass()));
            } else if (producerBean.getProducer() instanceof ProducerFieldProducer) {
                producer = (ProducerFieldProducer)producerBean.getProducer();
                if (producer.getDisposalMethod() != null) {
                    beanBuilder.add("disposalMethod", JsonObjects.annotatedMethodToString(producer.getDisposalMethod().getAnnotated(), bean.getBeanClass()));
                }
                beanBuilder.add("producerField", JsonObjects.annotatedFieldToString(((ProducerFieldProducer)producer).getAnnotated(), bean.getBeanClass()));
            }
        }
        Json.JsonArrayBuilder dependencies = JsonObjects.createDependencies(null, bean, probe, transientDependencies);
        if (dependencies != null) {
            beanBuilder.add("dependencies", dependencies);
        }
        if ((dependents = JsonObjects.createDependents(null, bean, probe, transientDependents)) != null) {
            beanBuilder.add("dependents", dependents);
        }
        Json.JsonArrayBuilder declaredObservers = Json.arrayBuilder();
        for (ObserverMethod<?> observerMethod : probe.getObservers()) {
            ObserverMethodImpl observerMethodImpl;
            if (!(observerMethod instanceof ObserverMethodImpl) || !bean.equals((observerMethodImpl = (ObserverMethodImpl)observerMethod).getDeclaringBean())) continue;
            Json.JsonObjectBuilder observerBuilder = JsonObjects.createSimpleObserverJson(observerMethodImpl, probe);
            observerBuilder.add("reception", observerMethodImpl.getReception().toString());
            observerBuilder.add("txPhase", observerMethodImpl.getTransactionPhase().toString());
            declaredObservers.add(observerBuilder);
        }
        beanBuilder.add("declaredObservers", declaredObservers);
        beanBuilder.add("declaredProducers", JsonObjects.createDeclaredProducers(bean, probe));
        Components.BeanKind kind = Components.BeanKind.from(bean);
        if (Components.BeanKind.INTERCEPTOR.equals((Object)kind) || Components.BeanKind.DECORATOR.equals((Object)kind) || bean.isAlternative()) {
            Json.JsonObjectBuilder enablementBuilder = Json.objectBuilder();
            AnnotationApiAbstraction annotationApi = beanManager.getServices().get(AnnotationApiAbstraction.class);
            Annotation priority = bean.getBeanClass().getAnnotation(annotationApi.PRIORITY_ANNOTATION_CLASS);
            if (priority != null) {
                int priorityValue = annotationApi.getPriority(priority);
                enablementBuilder.add("priority", priorityValue);
                enablementBuilder.add("priorityRange", Components.PriorityRange.of(priorityValue).toString());
            } else {
                Json.JsonArrayBuilder bdasBuilder = Json.arrayBuilder();
                Collection<BeanManagerImpl> beanManagers = Container.instance(beanManager).beanDeploymentArchives().values();
                for (BeanManagerImpl manager : beanManagers) {
                    ModuleEnablement enablement = manager.getEnabled();
                    if (!(Components.BeanKind.INTERCEPTOR.equals((Object)kind) && enablement.isInterceptorEnabled(bean.getBeanClass()) || Components.BeanKind.DECORATOR.equals((Object)kind) && enablement.isDecoratorEnabled(bean.getBeanClass())) && !JsonObjects.isSelectedAlternative(enablement, bean)) continue;
                    bdasBuilder.add(JsonObjects.createSimpleBdaJson(manager.getId()));
                }
                enablementBuilder.add("bdas", bdasBuilder);
            }
            beanBuilder.add("enablement", enablementBuilder);
        }
        if (Components.BeanKind.INTERCEPTOR.equals((Object)kind)) {
            Interceptor interceptor = (Interceptor)bean;
            Json.JsonArrayBuilder bindings = Json.arrayBuilder(true);
            for (Annotation binding : interceptor.getInterceptorBindings()) {
                bindings.add(binding.toString());
            }
            beanBuilder.add("bindings", bindings);
        }
        if (Components.BeanKind.DECORATOR.equals((Object)kind)) {
            Decorator decorator = (Decorator)bean;
            beanBuilder.add("delegateType", Formats.formatType(decorator.getDelegateType(), false));
            beanBuilder.add("delegateQualifiers", JsonObjects.createQualifiers(decorator.getDelegateQualifiers(), false));
            Json.JsonArrayBuilder decoratedTypes = Json.arrayBuilder(true);
            for (Type type : decorator.getDecoratedTypes()) {
                decoratedTypes.add(Formats.formatType(type, false));
            }
            beanBuilder.add("decoratedTypes", decoratedTypes);
            Set<Bean<?>> decoratedBeans = JsonObjects.findDecoratedBeans(decorator, beanManager, probe);
            if (!decoratedBeans.isEmpty()) {
                Json.JsonArrayBuilder decoratedBeansBuilder = Json.arrayBuilder();
                for (Bean bean2 : decoratedBeans) {
                    decoratedBeansBuilder.add(JsonObjects.createSimpleBeanJson(bean2, probe));
                }
                beanBuilder.add("associatedTo", decoratedBeansBuilder);
            }
        }
        if (bean instanceof AbstractClassBean) {
            List<Decorator<?>> decorators;
            Set<Annotation> classInterceptorBindings;
            AbstractClassBean abstractClassBean = (AbstractClassBean)bean;
            InterceptionModel interceptionModel = abstractClassBean.getInterceptors();
            if (interceptionModel != null && !(classInterceptorBindings = interceptionModel.getClassInterceptorBindings()).isEmpty()) {
                Json.JsonArrayBuilder bindingsBuilder = Json.arrayBuilder();
                for (Annotation annotation : Components.getSortedProbeComponetAnnotationCandidates(classInterceptorBindings)) {
                    bindingsBuilder.add(Json.objectBuilder().add("value", annotation.toString()).add("probeComponent", Components.isProbeAnnotation(annotation)));
                }
                beanBuilder.add("classInterceptorBindings", bindingsBuilder);
            }
            if (!(decorators = abstractClassBean.getDecorators()).isEmpty()) {
                Json.JsonArrayBuilder decoratorsBuilder = Json.arrayBuilder();
                for (Decorator decorator : decorators) {
                    decoratorsBuilder.add(JsonObjects.createSimpleBeanJson(decorator, probe));
                }
                beanBuilder.add("decorators", decoratorsBuilder);
            }
        }
        return beanBuilder.build();
    }

    private static Set<Bean<?>> findDecoratedBeans(Decorator<?> decorator, BeanManagerImpl beanManager, Probe probe) {
        HashSet beans = new HashSet();
        for (Bean<?> bean : probe.getBeans()) {
            List<Decorator<?>> decorators = bean instanceof AbstractClassBean ? ((AbstractClassBean)bean).getDecorators() : beanManager.resolveDecorators((Set<Type>)bean.getTypes(), bean.getQualifiers());
            if (!decorators.contains(decorator)) continue;
            beans.add(bean);
        }
        return beans;
    }

    private static boolean isSelectedAlternative(ModuleEnablement enablement, Bean<?> bean) {
        if (bean.isAlternative()) {
            if (enablement.isEnabledAlternativeClass(bean.getBeanClass())) {
                return true;
            }
            for (Class stereotype : bean.getStereotypes()) {
                if (!enablement.isEnabledAlternativeStereotype(stereotype)) continue;
                return true;
            }
        }
        return false;
    }

    static Json.JsonObjectBuilder createSimpleBeanJson(Bean<?> bean, Probe probe) {
        Json.JsonObjectBuilder builder = Json.objectBuilder(true);
        builder.add("id", probe.getBeanId(bean));
        builder.add("kind", Components.BeanKind.from(bean).toString());
        builder.add("beanClass", bean.getBeanClass().getName());
        BeanManagerImpl beanManager = probe.getBeanManager(bean);
        if (beanManager != null) {
            builder.add("bdaId", Components.getId(beanManager.getId()));
        }
        return builder;
    }

    static Json.JsonObjectBuilder createSimpleBeanJsonWithDependencies(Bean<?> bean, Probe probe) {
        Json.JsonArrayBuilder dependents;
        Json.JsonObjectBuilder builder = JsonObjects.createSimpleBeanJson(bean, probe);
        builder.add("declaringBean", JsonObjects.createDeclaringBean(bean, probe));
        Json.JsonArrayBuilder dependencies = JsonObjects.createDependencies(null, bean, probe, false);
        if (dependencies != null) {
            builder.add("dependencies", dependencies);
        }
        if ((dependents = JsonObjects.createDependents(null, bean, probe, false)) != null) {
            builder.add("dependents", dependents);
        }
        return builder;
    }

    static Json.JsonObjectBuilder createDeclaringBean(Bean<?> bean, Probe probe) {
        AbstractProducerBean producerBean;
        if (bean instanceof AbstractProducerBean && (producerBean = (AbstractProducerBean)bean).getDeclaringBean() != null) {
            return JsonObjects.createSimpleBeanJson(producerBean.getDeclaringBean(), probe);
        }
        return null;
    }

    static Json.JsonArrayBuilder createDependencies(Bean<?> parent, Bean<?> bean, Probe probe, boolean isTransient) {
        BeanManagerImpl beanManager = probe.getBeanManager(bean);
        if (beanManager == null) {
            return null;
        }
        Json.JsonArrayBuilder dependenciesBuilder = Json.arrayBuilder(true);
        for (Components.Dependency dep : Components.getDependencies(bean, beanManager, probe)) {
            if (Components.isBuiltinBeanButNotExtension(dep.getBean())) {
                dependenciesBuilder.add(JsonObjects.createBuiltInDependency(dep, probe, beanManager, "dependencies"));
                continue;
            }
            if (dep.getBean().equals(parent)) {
                dependenciesBuilder.add(JsonObjects.createDependency(dep.getBean(), dep, probe));
                continue;
            }
            Json.JsonObjectBuilder dependency = JsonObjects.createDependency(dep.getBean(), dep, probe);
            dependency.add("declaringBean", JsonObjects.createDeclaringBean(dep.getBean(), probe));
            dependenciesBuilder.add(dependency);
            if (!isTransient) continue;
            dependency.add("dependencies", JsonObjects.createDependencies(bean, dep.getBean(), probe, true));
        }
        return dependenciesBuilder.isEmpty() ? null : dependenciesBuilder;
    }

    private static Json.JsonObjectBuilder createBuiltInDependency(Components.Dependency dependency, Probe probe, BeanManagerImpl beanManager, String type) {
        Bean<?> lazilyFetched;
        AbstractBuiltInBean builtInBean = (AbstractBuiltInBean)dependency.getBean();
        Json.JsonObjectBuilder builtInDependency = JsonObjects.createDependency(probe.getBean(Components.getBuiltinBeanId(builtInBean)), dependency, probe);
        if (builtInBean.getBeanClass().equals(InstanceImpl.class) && (lazilyFetched = Components.getInstanceResolvedBean(beanManager, dependency.getInjectionPoint())) != null && !Components.isBuiltinBeanButNotExtension(lazilyFetched)) {
            Json.JsonObjectBuilder lazilyFetchedDependency = JsonObjects.createDependency(lazilyFetched, null, probe);
            lazilyFetchedDependency.add("requiredType", Formats.formatType(Components.getFacadeType(dependency.getInjectionPoint()), false)).add("qualifiers", JsonObjects.createQualifiers(dependency.getInjectionPoint().getQualifiers(), false));
            lazilyFetchedDependency.add("info", "Most likely lazy fetching - Instance.get()");
            lazilyFetchedDependency.add("isPotential", true);
            builtInDependency.add(type, Json.arrayBuilder().add(lazilyFetchedDependency));
        }
        return builtInDependency;
    }

    static Json.JsonArrayBuilder createDependents(Bean<?> parent, Bean<?> bean, Probe probe, boolean isTransient) {
        Json.JsonArrayBuilder dependentsBuilder = Json.arrayBuilder(true);
        for (Components.Dependency dependent : Components.getDependents(bean, probe)) {
            if (Components.isBuiltinBeanButNotExtension(dependent.getBean())) {
                dependentsBuilder.add(JsonObjects.createDependency(probe.getBean(Components.getBuiltinBeanId((AbstractBuiltInBean)dependent.getBean())), dependent, probe));
                continue;
            }
            if (dependent.getBean().equals(parent)) {
                dependentsBuilder.add(JsonObjects.createDependency(dependent.getBean(), dependent, probe));
                continue;
            }
            Json.JsonObjectBuilder dependency = JsonObjects.createDependency(dependent.getBean(), dependent, probe);
            if (dependent.getInfo() != null) {
                dependency.add("info", dependent.getInfo());
                if (dependent.isPotential()) {
                    dependency.add("isPotential", true);
                }
            }
            dependency.add("declaringBean", JsonObjects.createDeclaringBean(dependent.getBean(), probe));
            dependentsBuilder.add(dependency);
            if (!isTransient) continue;
            dependency.add("dependents", JsonObjects.createDependents(bean, dependent.getBean(), probe, true));
        }
        return dependentsBuilder.isEmpty() ? null : dependentsBuilder;
    }

    static Json.JsonArrayBuilder createDeclaredProducers(Bean<?> bean, Probe probe) {
        Json.JsonArrayBuilder declaredProducers = Json.arrayBuilder();
        for (AbstractProducerBean<?, ?, ?> producerBean : probe.getDeclaredProducers(bean)) {
            AbstractMemberProducer producer;
            Json.JsonObjectBuilder producerBuilder = JsonObjects.createSimpleBeanJson(producerBean, probe);
            if (producerBean.getProducer() instanceof ProducerMethodProducer) {
                producer = (ProducerMethodProducer)producerBean.getProducer();
                producerBuilder.add("producerInfo", JsonObjects.annotatedMethodToString((AnnotatedMethod)((ProducerMethodProducer)producer).getAnnotated(), bean.getBeanClass()));
            } else if (producerBean.getProducer() instanceof ProducerFieldProducer) {
                producer = (ProducerFieldProducer)producerBean.getProducer();
                producerBuilder.add("producerInfo", JsonObjects.annotatedFieldToString(((ProducerFieldProducer)producer).getAnnotated(), bean.getBeanClass()));
            }
            declaredProducers.add(producerBuilder);
        }
        return declaredProducers;
    }

    static String createInvocationsJson(Queries.Page<Invocation> page, Probe probe) {
        Json.JsonArrayBuilder invocationsBuilder = Json.arrayBuilder();
        for (Invocation invocation : page.getData()) {
            invocationsBuilder.add(JsonObjects.createBasicInvocationJson(invocation, probe));
        }
        return JsonObjects.createPageJson(page, invocationsBuilder);
    }

    static Json.JsonObjectBuilder createBasicInvocationJson(Invocation invocation, Probe probe) {
        Json.JsonObjectBuilder invocationBuilder = Json.objectBuilder();
        if (invocation.getEntryPointIdx() != null) {
            invocationBuilder.add("id", invocation.getEntryPointIdx());
        }
        if (invocation.getInterceptedBean() != null) {
            invocationBuilder.add("interceptedBean", JsonObjects.createSimpleBeanJson(invocation.getInterceptedBean(), probe));
        } else {
            invocationBuilder.add("declaringClass", invocation.getDeclaringClassName());
        }
        if (invocation.getDescription() != null) {
            invocationBuilder.add("description", invocation.getDescription());
        }
        invocationBuilder.add("methodName", invocation.getMethodName());
        invocationBuilder.add("start", invocation.getStart());
        invocationBuilder.add("time", invocation.getDuration());
        return invocationBuilder;
    }

    static Json.JsonObjectBuilder createFullInvocationJson(Invocation invocation, Probe probe) {
        Json.JsonObjectBuilder invocationBuilder = JsonObjects.createBasicInvocationJson(invocation, probe);
        invocationBuilder.add("type", invocation.getType().toString());
        if (invocation.hasChildren()) {
            Json.JsonArrayBuilder childrenBuilder = Json.arrayBuilder();
            for (Invocation child : invocation.getChildren()) {
                childrenBuilder.add(JsonObjects.createFullInvocationJson(child, probe));
            }
            invocationBuilder.add("children", childrenBuilder);
        }
        return invocationBuilder;
    }

    static String createObserversJson(Queries.Page<ObserverMethod<?>> page, Probe probe) {
        Json.JsonArrayBuilder observersBuilder = Json.arrayBuilder();
        for (ObserverMethod<?> observerMethod : page.getData()) {
            observersBuilder.add(JsonObjects.createBasicObserverJson(observerMethod, probe));
        }
        return JsonObjects.createPageJson(page, observersBuilder);
    }

    static String createFullObserverJson(ObserverMethod<?> observerMethod, Probe probe) {
        Json.JsonObjectBuilder observerBuilder = JsonObjects.createBasicObserverJson(observerMethod, probe);
        if (observerMethod instanceof ObserverMethodImpl) {
            ObserverMethodImpl observerMethodImpl = (ObserverMethodImpl)observerMethod;
            observerBuilder.add("annotatedMethod", JsonObjects.annotatedMethodToString(observerMethodImpl.getMethod().getAnnotated(), observerMethodImpl.getBeanClass()));
        }
        return observerBuilder.build();
    }

    static Json.JsonObjectBuilder createBasicObserverJson(ObserverMethod<?> observerMethod, Probe probe) {
        Json.JsonObjectBuilder observerBuilder = JsonObjects.createSimpleObserverJson(observerMethod, probe);
        observerBuilder.add("reception", observerMethod.getReception().toString());
        observerBuilder.add("txPhase", observerMethod.getTransactionPhase().toString());
        if (!observerMethod.getObservedQualifiers().isEmpty()) {
            Json.JsonArrayBuilder qualifiersBuilder = Json.arrayBuilder();
            for (Annotation qualifier : observerMethod.getObservedQualifiers()) {
                qualifiersBuilder.add(qualifier.toString());
            }
            observerBuilder.add("qualifiers", qualifiersBuilder);
        }
        if (observerMethod instanceof ObserverMethodImpl) {
            ObserverMethodImpl observerMethodImpl = (ObserverMethodImpl)observerMethod;
            observerBuilder.add("declaringBean", JsonObjects.createSimpleBeanJson(observerMethodImpl.getDeclaringBean(), probe));
            if (JsonObjects.isUnrestrictedProcessAnnotatedTypeObserver(observerMethodImpl)) {
                observerBuilder.add("description", "BOOTSTRAP PERFORMANCE TIP: This observer method receives events for all annotated types! Consider restricting events using @WithAnnotations or a generic type with bounds.");
            }
        }
        if (observerMethod instanceof Prioritized) {
            int priority = ((Prioritized)Prioritized.class.cast(observerMethod)).getPriority();
            observerBuilder.add("priority", priority);
            observerBuilder.add("priorityRange", Components.PriorityRange.of(priority).toString());
        }
        return observerBuilder;
    }

    private static boolean isUnrestrictedProcessAnnotatedTypeObserver(ObserverMethodImpl<?, ?> observerMethod) {
        Type eventType;
        Type[] typeArguments;
        ExtensionObserverMethodImpl extensionObserverMethod;
        Class rawObserverType;
        return !(!(observerMethod instanceof ExtensionObserverMethodImpl) || !(rawObserverType = Reflections.getRawType((extensionObserverMethod = (ExtensionObserverMethodImpl)observerMethod).getObservedType())).equals(ProcessAnnotatedType.class) && !rawObserverType.equals(ProcessSyntheticAnnotatedType.class) || !extensionObserverMethod.getRequiredAnnotations().isEmpty() || (typeArguments = (eventType = extensionObserverMethod.getObservedType()) instanceof ParameterizedType ? ((ParameterizedType)eventType).getActualTypeArguments() : Arrays2.EMPTY_TYPE_ARRAY).length != 0 && !Reflections.isUnboundedWildcard(typeArguments[0]) && !Reflections.isUnboundedTypeVariable(typeArguments[0]));
    }

    static Json.JsonObjectBuilder createSimpleObserverJson(ObserverMethod<?> observerMethod, Probe probe) {
        Json.JsonObjectBuilder observerBuilder = Json.objectBuilder();
        observerBuilder.add("id", probe.getObserverId(observerMethod));
        observerBuilder.add("beanClass", observerMethod.getBeanClass().getName());
        observerBuilder.add("observedType", Formats.formatType(observerMethod.getObservedType(), false));
        return observerBuilder;
    }

    static String createContextualInstanceJson(Bean<?> bean, Object contextualInstance, Probe probe) {
        try {
            PropertyDescriptor[] properties;
            Json.JsonObjectBuilder builder = JsonObjects.createSimpleBeanJson(bean, probe);
            builder.add("scope", JsonObjects.simplifiedScope(bean.getScope()));
            builder.add("contextId", Components.getInspectableScopeId(bean.getScope()));
            Json.JsonArrayBuilder propertiesBuilder = Json.arrayBuilder();
            Class<?> definingClass = contextualInstance.getClass();
            if (ProxyObject.class.isAssignableFrom(definingClass)) {
                definingClass = definingClass.getSuperclass();
            }
            BeanInfo bi = Introspector.getBeanInfo(definingClass);
            for (PropertyDescriptor propertyDescriptor : properties = bi.getPropertyDescriptors()) {
                Object value;
                Method readMethod = propertyDescriptor.getReadMethod();
                if (readMethod == null) continue;
                try {
                    value = readMethod.invoke(contextualInstance, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    value = JsonObjects.toString(e);
                }
                catch (IllegalArgumentException e) {
                    value = JsonObjects.toString(e);
                }
                catch (InvocationTargetException e) {
                    value = JsonObjects.toString(e);
                }
                propertiesBuilder.add(Json.objectBuilder().add("name", propertyDescriptor.getDisplayName()).add("value", value != null ? Strings.abbreviate(value.toString(), 500) : "null"));
            }
            builder.add("properties", propertiesBuilder);
            return builder.build();
        }
        catch (IntrospectionException e) {
            ProbeLogger.LOG.introspectionProblem(bean, e);
            return null;
        }
    }

    static Json.JsonArrayBuilder createContextsJson(BeanManagerImpl beanManager, Probe probe) {
        Json.JsonArrayBuilder contexts = Json.arrayBuilder();
        for (Map.Entry<String, Class<? extends Annotation>> entry : Components.INSPECTABLE_SCOPES.entrySet()) {
            contexts.add(JsonObjects.createSimpleContextJson(entry.getKey(), entry.getValue()));
        }
        return contexts;
    }

    static Json.JsonObjectBuilder createSimpleContextJson(String id, Class<? extends Annotation> scope) {
        Json.JsonObjectBuilder builder = Json.objectBuilder(true);
        builder.add("scope", scope.getName());
        builder.add("id", id);
        return builder;
    }

    static Json.JsonObjectBuilder createContextJson(String id, Class<? extends Annotation> scope, BeanManagerImpl beanManager, Probe probe, HttpServletRequest req) {
        Map conversationsMap;
        Object conversationsAttribute;
        HttpSession session;
        Json.JsonObjectBuilder builder = JsonObjects.createSimpleContextJson(id, scope);
        builder.add("instances", JsonObjects.inspectContext(scope, beanManager, probe));
        if (req != null && ConversationScoped.class.equals(scope) && (session = req.getSession(false)) != null && (conversationsAttribute = session.getAttribute(AbstractConversationContext.CONVERSATIONS_ATTRIBUTE_NAME)) != null && conversationsAttribute instanceof Map && !(conversationsMap = (Map)conversationsAttribute).isEmpty()) {
            Json.JsonArrayBuilder cidsBuilder = Json.arrayBuilder();
            for (String cid : conversationsMap.keySet()) {
                cidsBuilder.add(cid);
            }
            builder.add("cids", cidsBuilder);
        }
        return builder;
    }

    private static Json.JsonArrayBuilder inspectContext(Class<? extends Annotation> scope, BeanManagerImpl beanManager, Probe probe) {
        Context context;
        try {
            context = beanManager.getContext(scope);
        }
        catch (ContextNotActiveException e) {
            return null;
        }
        Json.JsonArrayBuilder builder = Json.arrayBuilder();
        for (Bean<?> bean : probe.getBeans()) {
            Object contextualInstance;
            if (!bean.getScope().equals(scope) || (contextualInstance = context.get(bean)) == null) continue;
            Json.JsonObjectBuilder instanceBuilder = JsonObjects.createSimpleBeanJson(bean, probe);
            instanceBuilder.add("objectToString", contextualInstance.getClass().getName() + "@" + Integer.toHexString(contextualInstance.hashCode()));
            instanceBuilder.add("asString", Strings.abbreviate(contextualInstance.toString(), 100));
            builder.add(instanceBuilder);
        }
        return builder;
    }

    private static String toString(Throwable e) {
        return e.getClass().getName() + '[' + e.getMessage() + ']';
    }

    private static Json.JsonObjectBuilder createDependency(Bean<?> bean, Components.Dependency dependency, Probe probe) {
        Json.JsonObjectBuilder builder = JsonObjects.createSimpleBeanJson(bean, probe);
        if (bean != null && dependency != null) {
            builder.add("requiredType", Formats.formatType(dependency.getInjectionPoint().getType(), false)).add("qualifiers", JsonObjects.createQualifiers(dependency.getInjectionPoint().getQualifiers(), false));
        }
        return builder;
    }

    static List<Type> sortTypes(Set<Type> types) {
        ArrayList<Type> sorted = new ArrayList<Type>(types);
        Collections.sort(sorted, new Comparator<Type>(){

            @Override
            public int compare(Type o1, Type o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return sorted;
    }

    static Json.JsonArrayBuilder createQualifiers(Set<Annotation> qualifiers, boolean skipAny) {
        Json.JsonArrayBuilder builder = Json.arrayBuilder();
        for (Annotation qualifier : qualifiers) {
            if (Any.class.equals(qualifier.annotationType())) {
                if (skipAny) continue;
                builder.add(JsonObjects.simplifiedAnnotation(qualifier));
                continue;
            }
            if (Default.class.equals(qualifier.annotationType())) {
                builder.add(JsonObjects.simplifiedAnnotation(qualifier));
                continue;
            }
            builder.add(qualifier.toString());
        }
        return builder;
    }

    static String createPageJson(Queries.Page<?> page, Json.JsonArrayBuilder data) {
        return Json.objectBuilder().add("page", page.getIdx()).add("lastPage", page.getLastIdx()).add("total", page.getTotal()).add("data", data).build();
    }

    static String annotatedMethodToString(AnnotatedMethod<?> method, Class<?> beanClass) {
        StringBuilder builder = new StringBuilder();
        builder.append(Formats.addSpaceIfNeeded(Formats.formatAnnotations(method.getAnnotations())));
        builder.append(Formats.formatModifiers(method.getJavaMember().getModifiers()));
        builder.append(' ');
        builder.append(method.getJavaMember().getReturnType().getName());
        builder.append(' ');
        if (!beanClass.getName().equals(method.getDeclaringType().getJavaClass().getName())) {
            builder.append(method.getDeclaringType().getJavaClass().getName());
            builder.append('.');
        }
        builder.append(method.getJavaMember().getName());
        builder.append(Formats.formatAsFormalParameterList(method.getParameters()));
        return builder.toString();
    }

    static String annotatedFieldToString(AnnotatedField<?> field, Class<?> beanClass) {
        StringBuilder builder = new StringBuilder();
        builder.append(Formats.addSpaceIfNeeded(Formats.formatAnnotations(field.getAnnotations())));
        builder.append(Formats.formatModifiers(field.getJavaMember().getModifiers()));
        builder.append(' ');
        builder.append(field.getJavaMember().getType().getName());
        builder.append(' ');
        if (!beanClass.getName().equals(field.getDeclaringType().getJavaClass().getName())) {
            builder.append(field.getDeclaringType().getJavaClass().getName());
            builder.append('.');
        }
        builder.append(field.getJavaMember().getName());
        return builder.toString();
    }

    static Json.JsonObjectBuilder createEventJson(EventInfo event, Probe probe) {
        Json.JsonObjectBuilder builder = Json.objectBuilder();
        builder.add("type", Formats.formatType(event.getType(), event.isContainerEvent()));
        builder.add("qualifiers", JsonObjects.createQualifiers(event.getQualifiers(), true));
        builder.add("eventInfo", event.getEventString());
        builder.add("kind", (event.isContainerEvent() ? "container" : "application").toUpperCase());
        builder.add("ts", event.getTimestamp());
        Json.JsonArrayBuilder observersBuilder = Json.arrayBuilder();
        for (ObserverMethod<?> observer : event.getObservers()) {
            Json.JsonObjectBuilder b = JsonObjects.createSimpleObserverJson(observer, probe);
            if (observer instanceof ObserverMethodImpl) {
                ObserverMethodImpl weldObserver = (ObserverMethodImpl)observer;
                AnnotatedMethod method = weldObserver.getMethod().getAnnotated();
                b.add("method", method.getJavaMember().getName());
            }
            observersBuilder.add(b);
        }
        builder.add("observers", observersBuilder);
        return builder;
    }

    static String createEventsJson(Queries.Page<EventInfo> page, Probe probe) {
        Json.JsonArrayBuilder eventsBuilder = Json.arrayBuilder();
        for (EventInfo event : page.getData()) {
            eventsBuilder.add(JsonObjects.createEventJson(event, probe));
        }
        return JsonObjects.createPageJson(page, eventsBuilder);
    }

    static Json.JsonObjectBuilder createSimpleBdaJson(String bdaId) {
        Json.JsonObjectBuilder bdaBuilder = Json.objectBuilder(true);
        bdaBuilder.add("bdaId", bdaId);
        bdaBuilder.add("id", Components.getId(bdaId));
        return bdaBuilder;
    }

    private static String simplifiedScope(Class<? extends Annotation> scope) {
        return "@" + (Components.isBuiltinScope(scope) ? scope.getSimpleName() : scope.getName());
    }

    private static String simplifiedAnnotation(Annotation annotation) {
        return "@" + annotation.annotationType().getSimpleName();
    }

    private static Json.JsonObjectBuilder decorateProbeComponent(Class<?> clazz, Json.JsonObjectBuilder builder) {
        return Components.isProbeComponent(clazz) ? builder.add("probeComponent", true) : builder;
    }
}

