/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.builder.InjectionPointConfigurator;
import org.jboss.weld.bootstrap.events.builder.InjectionPointConfiguratorImpl;
import org.jboss.weld.util.collections.ImmutableSet;

public class InjectionPointBuilderImpl {
    private final InjectionPointConfiguratorImpl configurator;

    public InjectionPointBuilderImpl(InjectionPointConfiguratorImpl configurator) {
        this.configurator = configurator;
    }

    public InjectionPointConfigurator configure() {
        return this.configurator;
    }

    public InjectionPoint build() {
        return new ImmutableInjectionPoint(this.configurator);
    }

    static class ImmutableInjectionPoint
    implements InjectionPoint {
        private final Type requiredType;
        private final Set<Annotation> qualifiers;
        private final Bean<?> bean;
        private final boolean isDelegate;
        private final boolean isTransient;
        private final Member member;
        private final Annotated annotated;

        private ImmutableInjectionPoint(InjectionPointConfiguratorImpl configurator) {
            this.requiredType = configurator.getRequiredType();
            this.qualifiers = ImmutableSet.copyOf(configurator.getQualifiers());
            this.bean = configurator.getBean();
            this.isDelegate = configurator.isDelegate();
            this.isTransient = configurator.isTransient();
            this.member = configurator.getMember();
            this.annotated = configurator.getAnnotated();
        }

        public Type getType() {
            return this.requiredType;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Bean<?> getBean() {
            return this.bean;
        }

        public Member getMember() {
            return this.member;
        }

        public Annotated getAnnotated() {
            return this.annotated;
        }

        public boolean isDelegate() {
            return this.isDelegate;
        }

        public boolean isTransient() {
            return this.isTransient;
        }
    }
}

