/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.unbacked;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedMember;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedParameter;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedMemberIdentifier;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.reflection.Formats;

@SuppressWarnings(value={"SE_BAD_FIELD", "SE_NO_SUITABLE_CONSTRUCTOR", "SE_NO_SERIALVERSIONID"}, justification="False positive from FindBugs - serialization is handled by SerializationProxy.")
public class UnbackedAnnotatedConstructor<X>
extends UnbackedAnnotatedMember<X>
implements AnnotatedConstructor<X>,
Serializable {
    private final Constructor<X> constructor;
    private final List<AnnotatedParameter<X>> parameters;

    public static <X> AnnotatedConstructor<X> of(AnnotatedConstructor<X> originalConstructor, UnbackedAnnotatedType<X> declaringType, SharedObjectCache cache) {
        return new UnbackedAnnotatedConstructor<X>(originalConstructor.getBaseType(), originalConstructor.getTypeClosure(), originalConstructor.getAnnotations(), declaringType, originalConstructor.getParameters(), originalConstructor.getJavaMember(), cache);
    }

    public UnbackedAnnotatedConstructor(Type baseType, Set<Type> typeClosure, Set<Annotation> annotations, UnbackedAnnotatedType<X> declaringType, List<AnnotatedParameter<X>> originalParameters, Constructor<X> constructor, SharedObjectCache cache) {
        super(baseType, typeClosure, cache.getSharedSet(annotations), declaringType);
        this.constructor = constructor;
        ArrayList parameters = new ArrayList(originalParameters.size());
        for (AnnotatedParameter<X> originalParameter : originalParameters) {
            parameters.add(new UnbackedAnnotatedParameter(originalParameter.getBaseType(), originalParameter.getTypeClosure(), cache.getSharedSet(originalParameter.getAnnotations()), originalParameter.getPosition(), this));
        }
        this.parameters = ImmutableList.copyOf(parameters);
    }

    public Constructor<X> getJavaMember() {
        return this.constructor;
    }

    public List<AnnotatedParameter<X>> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return Formats.formatAnnotatedConstructor(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new UnbackedMemberIdentifier(this.getDeclaringType(), AnnotatedTypes.createConstructorId(this.constructor, this.getAnnotations(), this.getParameters()));
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw BeanLogger.LOG.proxyRequired();
    }
}

