/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.builtin.AbstractFacade;
import org.jboss.weld.bean.builtin.FacadeInjectionPoint;
import org.jboss.weld.event.EventPacket;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.EventLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.reflection.EventObjectTypeResolverBuilder;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.TypeResolver;

@SuppressWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR"}, justification="Uses SerializationProxy")
public class EventImpl<T>
extends AbstractFacade<T, Event<T>>
implements Event<T>,
Serializable {
    private static final String SUBTYPE_ARGUMENT_NAME = "subtype";
    private static final long serialVersionUID = 656782657242515455L;
    private final transient HierarchyDiscovery injectionPointTypeHierarchy = new HierarchyDiscovery(this.getType());
    private volatile transient CachedObservers cachedObservers;

    public static <E> EventImpl<E> of(InjectionPoint injectionPoint, BeanManagerImpl beanManager) {
        return new EventImpl(injectionPoint, beanManager);
    }

    private EventImpl(InjectionPoint injectionPoint, BeanManagerImpl beanManager) {
        super(injectionPoint, null, beanManager);
    }

    public String toString() {
        return Formats.formatAnnotations(this.getQualifiers()) + " Event<" + Formats.formatType(this.getType()) + ">";
    }

    public void fire(T event) {
        Preconditions.checkArgumentNotNull(event, "event");
        CachedObservers observers = this.getObservers(event);
        EventPacket<T> packet = EventPacket.of(event, observers.type, this.getQualifiers(), this.getInjectionPoint());
        this.getBeanManager().getGlobalStrictObserverNotifier().notifyObservers(packet, observers.methods);
    }

    private CachedObservers getObservers(T event) {
        CachedObservers cachedObservers = this.cachedObservers;
        if (cachedObservers != null && cachedObservers.rawType.equals(event.getClass())) {
            return cachedObservers;
        }
        Type eventType = this.getEventType(event);
        List observers = this.getBeanManager().getGlobalStrictObserverNotifier().resolveObserverMethods(eventType, this.getQualifiers());
        this.cachedObservers = cachedObservers = new CachedObservers(event.getClass(), eventType, observers);
        return cachedObservers;
    }

    public Event<T> select(Annotation ... qualifiers) {
        return this.selectEvent(this.getType(), qualifiers);
    }

    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
        Preconditions.checkArgumentNotNull(subtype, SUBTYPE_ARGUMENT_NAME);
        return this.selectEvent(subtype, qualifiers);
    }

    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        Preconditions.checkArgumentNotNull(subtype, SUBTYPE_ARGUMENT_NAME);
        return this.selectEvent(subtype.getType(), qualifiers);
    }

    private <U extends T> Event<U> selectEvent(Type subtype, Annotation[] newQualifiers) {
        this.getBeanManager().getGlobalStrictObserverNotifier().checkEventObjectType(subtype);
        return new EventImpl<T>(new FacadeInjectionPoint(this.getBeanManager(), this.getInjectionPoint(), subtype, this.getQualifiers(), newQualifiers), this.getBeanManager());
    }

    protected Type getEventType(T event) {
        Type resolvedType = event.getClass();
        if (Types.containsUnresolvedTypeVariableOrWildcard(resolvedType)) {
            resolvedType = this.injectionPointTypeHierarchy.resolveType(resolvedType);
        }
        if (Types.containsUnresolvedTypeVariableOrWildcard(resolvedType)) {
            Type canonicalEventType = Types.getCanonicalType(event.getClass());
            TypeResolver objectTypeResolver = new EventObjectTypeResolverBuilder(this.injectionPointTypeHierarchy.getResolver().getResolvedTypeVariables(), new HierarchyDiscovery(canonicalEventType).getResolver().getResolvedTypeVariables()).build();
            resolvedType = objectTypeResolver.resolveType(canonicalEventType);
        }
        return resolvedType;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw EventLogger.LOG.proxyRequired();
    }

    private class CachedObservers {
        private final Class<?> rawType;
        private final Type type;
        private final List<ObserverMethod<? super T>> methods;

        public CachedObservers(Class<?> rawType, Type type, List<ObserverMethod<? super T>> methods) {
            this.rawType = rawType;
            this.type = type;
            this.methods = methods;
        }
    }

    private static class SerializationProxy<T>
    extends AbstractFacade.AbstractFacadeSerializationProxy<T, Event<T>> {
        private static final long serialVersionUID = 9181171328831559650L;

        public SerializationProxy(EventImpl<T> event) {
            super(event);
        }

        private Object readResolve() throws ObjectStreamException {
            return EventImpl.of(this.getInjectionPoint(), this.getBeanManager());
        }
    }
}

