/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.util.collections.ImmutableSet;

public class EventPacket<T>
implements EventMetadata {
    private final T payload;
    private final Type type;
    private final InjectionPoint injectionPoint;
    private final Set<Annotation> qualifierSet;
    private final Annotation[] qualifierArray;

    public static <T> EventPacket<T> of(T event, Type eventType, Set<Annotation> qualifiers, InjectionPoint ip) {
        return new EventPacket<T>(event, eventType, qualifiers, null, ip);
    }

    public static <T> EventPacket<T> of(T event, Annotation ... qualifiers) {
        return new EventPacket<T>(event, event.getClass(), null, qualifiers, null);
    }

    private EventPacket(T payload, Type type, Set<Annotation> qualifierSet, Annotation[] qualifierArray, InjectionPoint injectionPoint) {
        this.payload = payload;
        this.type = type;
        this.qualifierSet = qualifierSet;
        this.qualifierArray = qualifierArray;
        this.injectionPoint = injectionPoint;
    }

    public T getPayload() {
        return this.payload;
    }

    public Type getType() {
        return this.type;
    }

    public Set<Annotation> getQualifiers() {
        ImmutableSet.Builder<Object> builder = ImmutableSet.builder();
        builder.add(AnyLiteral.INSTANCE);
        if (this.qualifierSet != null) {
            return builder.addAll((Iterable<Object>)this.qualifierSet).build();
        }
        if (this.qualifierArray != null) {
            return builder.addAll(this.qualifierArray).build();
        }
        throw new IllegalStateException();
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public String toString() {
        return "EventPacket [payload=" + this.payload + ", type=" + this.type + ", qualifiers=" + this.getQualifiers() + "]";
    }
}

