/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import java.util.Collection;
import java.util.stream.Collectors;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.serialization.spi.BeanIdentifier;

public abstract class AbstractNamingScheme
implements NamingScheme {
    private final String delimiter;

    public AbstractNamingScheme(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public boolean accept(String id) {
        return id.startsWith(this.getPrefix() + this.delimiter);
    }

    @Override
    public BeanIdentifier deprefix(String id) {
        return new StringBeanIdentifier(id.substring(this.getPrefix().length() + this.delimiter.length()));
    }

    @Override
    public String prefix(BeanIdentifier id) {
        return this.getPrefix() + this.delimiter + id.asString();
    }

    @Override
    public Collection<String> filterIds(Collection<String> ids) {
        return ids.stream().filter(this::accept).collect(Collectors.toList());
    }

    @Override
    public Collection<BeanIdentifier> deprefix(Collection<String> ids) {
        return ids.stream().map(this::deprefix).collect(Collectors.toList());
    }

    @Override
    public Collection<String> prefix(Collection<BeanIdentifier> ids) {
        return ids.stream().map(this::prefix).collect(Collectors.toList());
    }

    protected abstract String getPrefix();

    protected String getDelimiter() {
        return this.delimiter;
    }
}

