/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.Container;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.unbound.UnboundLiteral;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.event.Status;
import org.jboss.weld.logging.EventLogger;

public class DeferredEventNotification<T>
implements Runnable {
    protected final ObserverMethod<? super T> observer;
    private final T event;
    protected final EventMetadata metadata;
    private final CurrentEventMetadata currentEventMetadata;
    private final String contextId;
    private final Status status;
    private final boolean before;

    public DeferredEventNotification(String contextId, T event, EventMetadata metadata, ObserverMethod<? super T> observer, CurrentEventMetadata currentEventMetadata, Status status, boolean before) {
        this.contextId = contextId;
        this.observer = observer;
        this.event = event;
        this.metadata = metadata;
        this.currentEventMetadata = currentEventMetadata;
        this.status = status;
        this.before = before;
    }

    @Override
    public void run() {
        try {
            EventLogger.LOG.asyncFire(this.metadata, this.observer);
            new RunInRequest(this.contextId){

                @Override
                protected void execute() {
                    DeferredEventNotification.this.currentEventMetadata.push(DeferredEventNotification.this.metadata);
                    try {
                        DeferredEventNotification.this.observer.notify(DeferredEventNotification.this.event);
                    }
                    finally {
                        DeferredEventNotification.this.currentEventMetadata.pop();
                    }
                }
            }.run();
        }
        catch (Exception e) {
            EventLogger.LOG.asyncObserverFailure(this.metadata);
            EventLogger.LOG.catchingDebug(e);
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isBefore() {
        return this.before;
    }

    public String toString() {
        return "Deferred event [" + this.event + "] for [" + this.observer + "]";
    }

    private static abstract class RunInRequest {
        private final String contextId;

        public RunInRequest(String contextId) {
            this.contextId = contextId;
        }

        protected abstract void execute();

        public void run() {
            if (this.isRequestContextActive()) {
                this.execute();
            } else {
                RequestContext requestContext = (RequestContext)Container.instance(this.contextId).deploymentManager().instance().select(RequestContext.class, new Annotation[]{UnboundLiteral.INSTANCE}).get();
                try {
                    requestContext.activate();
                    this.execute();
                }
                finally {
                    requestContext.invalidate();
                    requestContext.deactivate();
                }
            }
        }

        private boolean isRequestContextActive() {
            for (RequestContext requestContext : Container.instance(this.contextId).deploymentManager().instance().select(RequestContext.class, new Annotation[0])) {
                if (!requestContext.isActive()) continue;
                return true;
            }
            return false;
        }
    }
}

