/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection.instantiation;

import java.util.List;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.reflection.instantiation.Instantiator;
import org.jboss.weld.util.reflection.instantiation.InstantiatorFactory;
import org.jboss.weld.util.reflection.instantiation.ReflectionFactoryInstantiator;
import org.jboss.weld.util.reflection.instantiation.UnsafeInstantiator;

public abstract class AbstractInstantiatorFactory
implements InstantiatorFactory {
    protected static final String MARKER = "META-INF/org.jboss.weld.enableUnsafeProxies";
    protected volatile Boolean enabled;
    protected final WeldConfiguration configuration;
    private Instantiator instantiator;
    private final List<Instantiator> instantiators;

    public AbstractInstantiatorFactory(WeldConfiguration configuration) {
        this.configuration = configuration;
        this.instantiators = ImmutableList.of(new Instantiator[]{new UnsafeInstantiator(), new ReflectionFactoryInstantiator()});
    }

    protected boolean checkInstantiator() {
        for (Instantiator i : this.instantiators) {
            if (!i.isAvailable()) continue;
            this.instantiator = i;
            return true;
        }
        return false;
    }

    @Override
    public Instantiator getInstantiator() {
        return this.instantiator;
    }
}

