/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module;

import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.Context;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.ServiceRegistries;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.WeldModule;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.util.ServiceLoader;
import org.jboss.weld.util.collections.ImmutableList;

public class WeldModules
implements Service {
    private final List<WeldModule> modules = (List)ServiceLoader.load(WeldModule.class, WeldClassLoaderResourceLoader.INSTANCE).stream().map(metadata -> (WeldModule)metadata.getValue()).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).collect(ImmutableList.collector());

    public WeldModules() {
        BootstrapLogger.LOG.debugv("Using Weld modules: {0}", this.modules.stream().map(m -> m.getName()).collect(Collectors.toList()));
    }

    public void postServiceRegistration(final String contextId, final ServiceRegistry services) {
        WeldModule.PostServiceRegistrationContext ctx = new WeldModule.PostServiceRegistrationContext(){

            @Override
            public ServiceRegistry getServices() {
                return services;
            }

            @Override
            public String getContextId() {
                return contextId;
            }
        };
        for (WeldModule module : this.modules) {
            module.postServiceRegistration(ctx);
        }
    }

    public void postContextRegistration(final String contextId, final ServiceRegistry services, final List<ContextHolder<? extends Context>> contexts) {
        WeldModule.PostContextRegistrationContext ctx = new WeldModule.PostContextRegistrationContext(){

            @Override
            public String getContextId() {
                return contextId;
            }

            @Override
            public ServiceRegistry getServices() {
                return ServiceRegistries.unmodifiableServiceRegistry(services);
            }

            @Override
            public void addContext(ContextHolder<? extends Context> context) {
                contexts.add(context);
            }
        };
        for (WeldModule module : this.modules) {
            module.postContextRegistration(ctx);
        }
    }

    public void preBeanRegistration(final BeanDeployment deployment, final Environment environment) {
        WeldModule.PreBeanRegistrationContext ctx = new WeldModule.PreBeanRegistrationContext(){

            @Override
            public void registerBean(AbstractBuiltInBean<?> bean) {
                deployment.getBeanDeployer().addBuiltInBean(bean);
            }

            @Override
            public Environment getEnvironment() {
                return environment;
            }

            @Override
            public BeanManagerImpl getBeanManager() {
                return deployment.getBeanManager();
            }

            @Override
            public BeanDeploymentArchive getBeanDeploymentArchive() {
                return deployment.getBeanDeploymentArchive();
            }
        };
        for (WeldModule module : this.modules) {
            module.preBeanRegistration(ctx);
        }
    }

    @Override
    public void cleanup() {
    }
}

