/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class DescriptorUtils {
    public static String makeDescriptor(String className) {
        String repl = className.replace(".", "/");
        return 'L' + repl + ';';
    }

    public static String makeDescriptor(Class<?> c) {
        if (Void.TYPE.equals(c)) {
            return "V";
        }
        if (Byte.TYPE.equals(c)) {
            return "B";
        }
        if (Character.TYPE.equals(c)) {
            return "C";
        }
        if (Double.TYPE.equals(c)) {
            return "D";
        }
        if (Float.TYPE.equals(c)) {
            return "F";
        }
        if (Integer.TYPE.equals(c)) {
            return "I";
        }
        if (Long.TYPE.equals(c)) {
            return "J";
        }
        if (Short.TYPE.equals(c)) {
            return "S";
        }
        if (Boolean.TYPE.equals(c)) {
            return "Z";
        }
        if (c.isArray()) {
            return c.getName().replace(".", "/");
        }
        return DescriptorUtils.makeDescriptor(c.getName());
    }

    public static String makeDescriptor(Constructor<?> c) {
        StringBuilder desc = new StringBuilder("(");
        for (Class<?> p : c.getParameterTypes()) {
            desc.append(DescriptorUtils.makeDescriptor(p));
        }
        desc.append(")");
        desc.append("V");
        return desc.toString();
    }

    public static String[] parameterDescriptors(String methodDescriptor) {
        int i = 1;
        ArrayList<String> ret = new ArrayList<String>();
        int arraystart = -1;
        while (methodDescriptor.charAt(i) != ')') {
            String type = null;
            if (methodDescriptor.charAt(i) == '[') {
                if (arraystart == -1) {
                    arraystart = i;
                }
            } else {
                if (methodDescriptor.charAt(i) == 'L') {
                    int start = i++;
                    while (methodDescriptor.charAt(i) != ';') {
                        ++i;
                    }
                    type = arraystart == -1 ? methodDescriptor.substring(start, i + 1) : methodDescriptor.substring(arraystart, i + 1);
                } else {
                    type = arraystart == -1 ? methodDescriptor.charAt(i) + "" : methodDescriptor.substring(arraystart, i + 1);
                }
                arraystart = -1;
                ret.add(type);
            }
            ++i;
        }
        String[] r = new String[ret.size()];
        for (int j = 0; j < ret.size(); ++j) {
            r[j] = (String)ret.get(j);
        }
        return r;
    }

    public static String[] parameterDescriptors(Method m) {
        return DescriptorUtils.parameterDescriptors(m.getParameterTypes());
    }

    public static String[] parameterDescriptors(Class<?>[] parameters) {
        String[] ret = new String[parameters.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = DescriptorUtils.makeDescriptor(parameters[i]);
        }
        return ret;
    }

    public static String returnType(String methodDescriptor) {
        return methodDescriptor.substring(methodDescriptor.lastIndexOf(41) + 1, methodDescriptor.length());
    }

    public static boolean isPrimitive(String descriptor) {
        return descriptor.length() == 1;
    }

    public static boolean isWide(String descriptor) {
        if (!DescriptorUtils.isPrimitive(descriptor)) {
            return false;
        }
        char c = descriptor.charAt(0);
        return c == 'D' || c == 'J';
    }

    public static boolean isWide(Class<?> cls) {
        return cls == Double.TYPE || cls == Long.TYPE;
    }

    public static String methodDescriptor(Method m) {
        StringBuilder desc = new StringBuilder("(");
        for (Class<?> p : m.getParameterTypes()) {
            desc.append(DescriptorUtils.makeDescriptor(p));
        }
        desc.append(")");
        desc.append(DescriptorUtils.makeDescriptor(m.getReturnType()));
        return desc.toString();
    }

    public static String methodDescriptor(String[] parameters, String returnType) {
        StringBuilder desc = new StringBuilder("(");
        for (String p : parameters) {
            desc.append(p);
        }
        desc.append(")");
        desc.append(returnType);
        return desc.toString();
    }

    public static String validateDescriptor(String descriptor) {
        if (descriptor.length() == 0) {
            throw new RuntimeException("descriptors may not be empty");
        }
        if (descriptor.length() > 1) {
            if (descriptor.startsWith("L")) {
                if (!descriptor.endsWith(";")) {
                    throw new RuntimeException(descriptor + " is not a valid descriptor");
                }
            } else if (!descriptor.startsWith("[")) {
                throw new RuntimeException(descriptor + " is not a valid descriptor");
            }
        } else {
            char type = descriptor.charAt(0);
            switch (type) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    break;
                }
                default: {
                    throw new RuntimeException(descriptor + " is not a valid descriptor");
                }
            }
        }
        return descriptor;
    }
}

