/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.el.CreationalContextCallable;
import org.jboss.weld.el.ELCreationalContext;
import org.jboss.weld.el.ELCreationalContextStack;
import org.jboss.weld.el.Namespace;
import org.jboss.weld.logging.ElLogger;
import org.jboss.weld.manager.BeanManagerImpl;

public abstract class AbstractWeldELResolver
extends ELResolver {
    protected abstract BeanManagerImpl getManager(ELContext var1);

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        BeanManagerImpl beanManager = this.getManager(context);
        if (property != null) {
            String name;
            Object value;
            String propertyString = property.toString();
            ElLogger.LOG.propertyLookup(propertyString);
            Namespace namespace = null;
            if (base == null) {
                if (this.getRootNamespace().contains(propertyString)) {
                    Namespace value2 = this.getRootNamespace().get(propertyString);
                    context.setPropertyResolved(true);
                    ElLogger.LOG.propertyResolved(propertyString, value2);
                    return value2;
                }
            } else if (base instanceof Namespace) {
                namespace = (Namespace)base;
                context.setPropertyResolved(true);
                if (namespace.contains(propertyString)) {
                    Namespace value3 = namespace.get(propertyString);
                    ElLogger.LOG.propertyResolved(propertyString, value3);
                    return value3;
                }
            } else {
                return null;
            }
            if ((value = this.lookup(beanManager, context, name = namespace != null ? namespace.qualifyName(propertyString) : propertyString)) != null) {
                context.setPropertyResolved(true);
                ElLogger.LOG.propertyResolved(propertyString, value);
                return value;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lookup(BeanManagerImpl beanManager, ELContext context, String name) {
        Bean bean = beanManager.resolve(beanManager.getBeans(name));
        if (bean == null) {
            return null;
        }
        Class scope = bean.getScope();
        if (!scope.equals(Dependent.class)) {
            return beanManager.getReference(bean, null, beanManager.createCreationalContext((Contextual)bean), true);
        }
        ELCreationalContextStack stack = ELCreationalContextStack.getCreationalContextStore(context);
        boolean release = stack.isEmpty();
        if (release) {
            stack.push(new CreationalContextCallable());
        }
        try {
            ELCreationalContext<?> ctx = ((CreationalContextCallable)stack.peek()).get();
            String beanName = bean.getName();
            Object value = ctx.getDependentInstanceForExpression(beanName);
            if (value == null) {
                value = this.getManager(context).getReference(bean, null, ctx, true);
                ctx.registerDependentInstanceForExpression(beanName, value);
            }
            Object object = value;
            return object;
        }
        finally {
            CreationalContextCallable callable;
            if (release && (callable = (CreationalContextCallable)stack.pop()).exists()) {
                callable.get().release();
            }
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
    }

    protected abstract Namespace getRootNamespace();
}

