/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.event.AsyncEventDeliveryStage;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.event.ResolvedObservers;
import org.jboss.weld.injection.ThreadLocalStack;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.reflection.Reflections;

public class ObserverNotifier {
    private static final RuntimeException NO_EXCEPTION_MARKER = new RuntimeException();
    private final TypeSafeObserverResolver resolver;
    private final SharedObjectCache sharedObjectCache;
    private final boolean strict;
    protected final CurrentEventMetadata currentEventMetadata;
    private final ComputingCache<Type, RuntimeException> eventTypeCheckCache;
    private final Executor asyncEventExecutor;

    protected ObserverNotifier(TypeSafeObserverResolver resolver, ServiceRegistry services, boolean strict) {
        this.resolver = resolver;
        this.sharedObjectCache = services.get(SharedObjectCache.class);
        this.strict = strict;
        this.currentEventMetadata = services.get(CurrentEventMetadata.class);
        this.eventTypeCheckCache = strict ? ComputingCacheBuilder.newBuilder().build(new EventTypeCheck()) : null;
        this.asyncEventExecutor = services.getOptional(ExecutorServices.class).map(e -> e.getTaskExecutor()).orElse(ForkJoinPool.commonPool());
    }

    public <T> ResolvedObservers<T> resolveObserverMethods(Type eventType, Annotation ... qualifiers) {
        this.checkEventObjectType(eventType);
        return this.resolveObserverMethods(this.buildEventResolvable(eventType, qualifiers));
    }

    public <T> ResolvedObservers<T> resolveObserverMethods(Type eventType, Set<Annotation> qualifiers) {
        this.checkEventObjectType(eventType);
        return this.resolveObserverMethods(this.buildEventResolvable(eventType, qualifiers));
    }

    public <T> ResolvedObservers<T> resolveObserverMethods(Resolvable resolvable) {
        return (ResolvedObservers)Reflections.cast(this.resolver.resolve(resolvable, true));
    }

    public void fireEvent(Object event, EventMetadata metadata, Annotation ... qualifiers) {
        this.fireEvent(event.getClass(), event, metadata, qualifiers);
    }

    public void fireEvent(Type eventType, Object event, Annotation ... qualifiers) {
        this.fireEvent(eventType, event, (EventMetadata)null, qualifiers);
    }

    protected void fireEvent(Type eventType, Object event, EventMetadata metadata, Annotation ... qualifiers) {
        this.checkEventObjectType(eventType);
        this.notify(this.resolveObserverMethods(this.buildEventResolvable(eventType, qualifiers)), event, metadata);
    }

    public void fireEvent(Object event, Resolvable resolvable) {
        this.checkEventObjectType(event);
        this.notify(this.resolveObserverMethods(resolvable), event, null);
    }

    protected Resolvable buildEventResolvable(Type eventType, Set<Annotation> qualifiers) {
        Set<Type> typeClosure = this.sharedObjectCache.getTypeClosureHolder(eventType).get();
        return new ResolvableBuilder(this.resolver.getMetaAnnotationStore()).addTypes(typeClosure).addType((Type)((Object)Object.class)).addQualifiers(qualifiers).addQualifierUnchecked(QualifierInstance.ANY).create();
    }

    protected Resolvable buildEventResolvable(Type eventType, Annotation ... qualifiers) {
        return new ResolvableBuilder(this.resolver.getMetaAnnotationStore()).addTypes(this.sharedObjectCache.getTypeClosureHolder(eventType).get()).addType((Type)((Object)Object.class)).addQualifiers(qualifiers).addQualifierUnchecked(QualifierInstance.ANY).create();
    }

    public void clear() {
        this.resolver.clear();
        if (this.eventTypeCheckCache != null) {
            this.eventTypeCheckCache.clear();
        }
    }

    protected void checkEventObjectType(Object event) {
        this.checkEventObjectType(event.getClass());
    }

    public void checkEventObjectType(Type eventType) {
        RuntimeException exception;
        if (this.strict && (exception = this.eventTypeCheckCache.getValue(eventType)) != NO_EXCEPTION_MARKER) {
            throw exception;
        }
    }

    public <T> void notify(ResolvedObservers<T> observers, T event, EventMetadata metadata) {
        if (!observers.isMetadataRequired()) {
            metadata = null;
        }
        this.notifySyncObservers(observers.getImmediateObservers(), event, metadata);
        this.notifyTransactionObservers(observers.getTransactionObservers(), event, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void notifySyncObservers(List<ObserverMethod<? super T>> observers, T event, EventMetadata metadata) {
        if (observers.isEmpty()) {
            return;
        }
        ThreadLocalStack.ThreadLocalStackReference<EventMetadata> stack = this.currentEventMetadata.pushIfNotNull(metadata);
        try {
            for (ObserverMethod<T> observerMethod : observers) {
                observerMethod.notify(event);
            }
        }
        finally {
            stack.pop();
        }
    }

    protected <T> void notifyTransactionObservers(List<ObserverMethod<? super T>> observers, T event, EventMetadata metadata) {
        this.notifySyncObservers(observers, event, metadata);
    }

    public <T, U extends T> CompletionStage<U> notifyAsync(ResolvedObservers<T> observers, U event, EventMetadata metadata, Executor executor) {
        if (!observers.isMetadataRequired()) {
            metadata = null;
        }
        this.notifyTransactionObservers(observers.getTransactionObservers(), event, metadata);
        return this.notifyAsyncObservers(observers.getImmediateObservers(), event, metadata, executor);
    }

    protected <T, U extends T> CompletionStage<U> notifyAsyncObservers(List<ObserverMethod<? super T>> observers, U event, EventMetadata metadata, Executor executor) {
        if (executor == null) {
            executor = this.asyncEventExecutor;
        }
        return new AsyncEventDeliveryStage<Object>(() -> {
            this.notifySyncObservers(observers, event, metadata);
            return event;
        }, executor);
    }

    private static class EventTypeCheck
    implements Function<Type, RuntimeException> {
        private EventTypeCheck() {
        }

        @Override
        public RuntimeException apply(Type eventType) {
            Type resolvedType = Types.getCanonicalType(eventType);
            if (Types.containsUnresolvedTypeVariableOrWildcard(resolvedType)) {
                return UtilLogger.LOG.typeParameterNotAllowedInEventType(eventType);
            }
            Class resolvedClass = Reflections.getRawType(eventType);
            for (Class clazz : Observers.CONTAINER_LIFECYCLE_EVENT_CANONICAL_SUPERTYPES) {
                if (!clazz.isAssignableFrom(resolvedClass)) continue;
                return UtilLogger.LOG.eventTypeNotAllowed(eventType);
            }
            return NO_EXCEPTION_MARKER;
        }
    }
}

