/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.activator;

import java.lang.annotation.Annotation;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.RequestScoped;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.event.FastEvent;
import org.jboss.weld.manager.BeanManagerImpl;

public abstract class AbstractActivateRequestContextInterceptor {
    protected final BeanManagerImpl beanManager;
    protected final RequestContext requestContext;
    protected final FastEvent<Object> fastEventInit;
    protected final FastEvent<Object> fastEventBeforeDestroyed;
    protected final FastEvent<Object> fastEventDestroyed;

    public AbstractActivateRequestContextInterceptor(RequestContext requestContext, BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
        this.requestContext = requestContext;
        this.fastEventInit = FastEvent.of(Object.class, beanManager, new Annotation[]{Initialized.Literal.REQUEST});
        this.fastEventBeforeDestroyed = FastEvent.of(Object.class, beanManager, new Annotation[]{BeforeDestroyed.Literal.REQUEST});
        this.fastEventDestroyed = FastEvent.of(Object.class, beanManager, new Annotation[]{Destroyed.Literal.REQUEST});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    Object invoke(InvocationContext ctx) throws Exception {
        if (this.isRequestContextActive()) {
            return ctx.proceed();
        }
        Object dummyPayload = new Object();
        try {
            this.requestContext.activate();
            this.fastEventInit.fire(dummyPayload);
            Object object = ctx.proceed();
            return object;
        }
        finally {
            this.requestContext.invalidate();
            this.fastEventBeforeDestroyed.fire(dummyPayload);
            this.requestContext.deactivate();
            this.fastEventDestroyed.fire(dummyPayload);
        }
    }

    boolean isRequestContextActive() {
        return this.beanManager.isContextActive(RequestScoped.class);
    }
}

