/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.TransientReference;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.ConstructorSignature;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.construction.api.AroundConstructCallback;
import org.jboss.weld.construction.api.ConstructionHandle;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.contexts.CreationalContextImpl;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.AbstractCallableInjectionPoint;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.security.GetAccessibleCopyOfMember;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.reflection.Reflections;

@SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class ConstructorInjectionPoint<T>
extends AbstractCallableInjectionPoint<T, T, Constructor<T>> {
    private final AnnotatedConstructor<T> constructor;
    private final ConstructorSignature signature;
    private final Constructor<T> accessibleConstructor;

    protected ConstructorInjectionPoint(EnhancedAnnotatedConstructor<T> constructor, Bean<T> declaringBean, Class<?> declaringComponentClass, InjectionPointFactory factory, BeanManagerImpl manager) {
        super(constructor, declaringBean, declaringComponentClass, false, factory, manager);
        this.constructor = constructor.slim();
        this.signature = constructor.getSignature();
        this.accessibleConstructor = AccessController.doPrivileged(new GetAccessibleCopyOfMember<Constructor>(constructor.getJavaMember()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T newInstance(BeanManagerImpl manager, CreationalContext<?> ctx) {
        WeldCreationalContext transientReferenceContext = null;
        if (this.hasTransientReferenceParameter) {
            transientReferenceContext = manager.createCreationalContext((Contextual)null);
        }
        try {
            Object[] parameterValues = this.getParameterValues(manager, ctx, transientReferenceContext);
            if (ctx instanceof CreationalContextImpl) {
                CreationalContextImpl weldCtx = (CreationalContextImpl)Reflections.cast(ctx);
                T t = this.invokeAroundConstructCallbacks(parameterValues, weldCtx);
                return t;
            }
            T t = this.newInstance(parameterValues);
            return t;
        }
        finally {
            if (this.hasTransientReferenceParameter) {
                transientReferenceContext.release();
            }
        }
    }

    private T invokeAroundConstructCallbacks(Object[] parameters, CreationalContextImpl<T> ctx) {
        List<AroundConstructCallback<T>> callbacks = ctx.getAroundConstructCallbacks();
        if (callbacks.isEmpty()) {
            return this.newInstance(parameters);
        }
        final Iterator<AroundConstructCallback<T>> iterator = callbacks.iterator();
        return this.invokeAroundConstructCallback(iterator.next(), new ConstructionHandle<T>(){

            @Override
            public T proceed(Object[] parameters, Map<String, Object> data) {
                if (iterator.hasNext()) {
                    return ConstructorInjectionPoint.this.invokeAroundConstructCallback((AroundConstructCallback)iterator.next(), this, ConstructorInjectionPoint.this.getComponentConstructor(), parameters, data);
                }
                return ConstructorInjectionPoint.this.newInstance(parameters);
            }
        }, this.getComponentConstructor(), parameters, new HashMap<String, Object>());
    }

    private T invokeAroundConstructCallback(AroundConstructCallback<T> callback, ConstructionHandle<T> ctx, AnnotatedConstructor<T> constructor, Object[] parameters, Map<String, Object> data) {
        try {
            return callback.aroundConstruct(ctx, constructor, parameters, data);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected T newInstance(Object[] parameterValues) {
        try {
            return this.accessibleConstructor.newInstance(parameterValues);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (InstantiationException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e);
        }
        return null;
    }

    public Object[] getParameterValues(BeanManagerImpl manager, CreationalContext<?> ctx, CreationalContext<?> transientReference) {
        if (this.getInjectionPoints().isEmpty()) {
            return Arrays2.EMPTY_ARRAY;
        }
        Object[] parameterValues = new Object[this.getParameterInjectionPoints().size()];
        List parameters = this.getParameterInjectionPoints();
        for (int i = 0; i < parameterValues.length; ++i) {
            ParameterInjectionPoint param = (ParameterInjectionPoint)parameters.get(i);
            parameterValues[i] = this.hasTransientReferenceParameter && param.getAnnotated().isAnnotationPresent(TransientReference.class) ? param.getValueToInject(manager, transientReference) : param.getValueToInject(manager, ctx);
        }
        return parameterValues;
    }

    @Override
    public AnnotatedConstructor<T> getAnnotated() {
        return this.constructor;
    }

    public ConstructorSignature getSignature() {
        return this.signature;
    }

    public AnnotatedConstructor<T> getComponentConstructor() {
        return this.constructor;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.constructor == null ? 0 : this.constructor.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstructorInjectionPoint other = (ConstructorInjectionPoint)obj;
        return !(this.constructor == null ? other.constructor != null : !this.constructor.equals(other.constructor));
    }
}

