/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.decorator.Decorator;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.interceptor.Interceptor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.events.AbstractContainerEvent;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeEventResolvable;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeImpl;
import org.jboss.weld.bootstrap.events.RequiredAnnotationDiscovery;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.event.ResolvedObservers;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.probe.BootstrapStats;
import org.jboss.weld.probe.DefaultJsonDataProvider;
import org.jboss.weld.probe.EventInfo;
import org.jboss.weld.probe.Exports;
import org.jboss.weld.probe.InvocationMonitor;
import org.jboss.weld.probe.JsonDataProvider;
import org.jboss.weld.probe.Monitored;
import org.jboss.weld.probe.MonitoredComponent;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.probe.ProbeDynamicMBean;
import org.jboss.weld.probe.ProbeLogger;
import org.jboss.weld.probe.ProbeObserver;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.bean.ForwardingBeanAttributes;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public class ProbeExtension
implements Extension {
    private final Probe probe = new Probe();
    private volatile JsonDataProvider jsonDataProvider;
    private volatile Pattern invocationMonitorExcludePattern;
    private volatile boolean eventMonitorContainerLifecycleEvents;

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        ProbeLogger.LOG.developmentModeEnabled();
        BeanManagerImpl manager = BeanManagerProxy.unwrap(beanManager);
        event.addAnnotatedType(manager.createAnnotatedType(Monitored.class), Monitored.class.getName());
        event.addAnnotatedType(manager.createAnnotatedType(MonitoredComponent.class), MonitoredComponent.class.getName());
        event.addAnnotatedType(manager.createAnnotatedType(InvocationMonitor.class), InvocationMonitor.class.getName());
        WeldConfiguration configuration = manager.getServices().get(WeldConfiguration.class);
        String exclude = configuration.getStringProperty(ConfigurationKey.PROBE_INVOCATION_MONITOR_EXCLUDE_TYPE);
        this.invocationMonitorExcludePattern = exclude.isEmpty() ? null : Pattern.compile(exclude);
        this.jsonDataProvider = new DefaultJsonDataProvider(this.probe, manager);
        this.eventMonitorContainerLifecycleEvents = configuration.getBooleanProperty(ConfigurationKey.PROBE_EVENT_MONITOR_CONTAINER_LIFECYCLE_EVENTS);
        this.addContainerLifecycleEvent(event, null, beanManager);
    }

    public <T> void processBeanAttributes(@Observes ProcessBeanAttributes<T> event, BeanManager beanManager) {
        this.probe.getBootstrapStats().increment(BootstrapStats.EventType.PBA);
        final BeanAttributes beanAttributes = event.getBeanAttributes();
        WeldManager weldManager = (WeldManager)beanManager;
        if (this.isMonitored(event.getAnnotated(), beanAttributes, weldManager)) {
            event.setBeanAttributes((BeanAttributes)new ForwardingBeanAttributes<T>(){

                @Override
                public Set<Class<? extends Annotation>> getStereotypes() {
                    return ImmutableSet.builder().addAll(this.attributes().getStereotypes()).add(MonitoredComponent.class).build();
                }

                @Override
                protected BeanAttributes<T> attributes() {
                    return beanAttributes;
                }

                public String toString() {
                    return beanAttributes.toString();
                }
            });
            ProbeLogger.LOG.monitoringStereotypeAdded(event.getAnnotated());
        }
        if (this.eventMonitorContainerLifecycleEvents) {
            this.addContainerLifecycleEvent(event, (Object)("Types: [" + Formats.formatTypes(event.getBeanAttributes().getTypes()) + "], qualifiers: [" + Formats.formatAnnotations(event.getBeanAttributes().getQualifiers()) + "]"), beanManager);
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        BeanManagerImpl weldManager;
        String exclude = (weldManager = BeanManagerProxy.unwrap(beanManager)).getServices().get(WeldConfiguration.class).getStringProperty(ConfigurationKey.PROBE_EVENT_MONITOR_EXCLUDE_TYPE);
        event.addObserverMethod((ObserverMethod)new ProbeObserver(weldManager, exclude.isEmpty() ? null : Pattern.compile(exclude), this.probe));
        this.addContainerLifecycleEvent(event, null, beanManager);
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        BeanManagerImpl manager = BeanManagerProxy.unwrap(beanManager);
        this.probe.init(manager);
        if (this.isJMXSupportEnabled(manager)) {
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                mbs.registerMBean(new ProbeDynamicMBean(this.jsonDataProvider, JsonDataProvider.class), this.constructProbeJsonDataMBeanName(manager, this.probe));
            }
            catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
                event.addDeploymentProblem((Throwable)ProbeLogger.LOG.unableToRegisterMBean(JsonDataProvider.class, manager.getContextId(), e));
            }
        }
        this.addContainerLifecycleEvent(event, null, beanManager);
        this.exportDataIfNeeded(manager);
    }

    public void beforeShutdown(@Observes BeforeShutdown event, BeanManager beanManager) {
        BeanManagerImpl manager = BeanManagerProxy.unwrap(beanManager);
        if (this.isJMXSupportEnabled(manager)) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName name = this.constructProbeJsonDataMBeanName(manager, this.probe);
                if (mbs.isRegistered(name)) {
                    mbs.unregisterMBean(name);
                }
            }
            catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException e) {
                throw ProbeLogger.LOG.unableToUnregisterMBean(JsonDataProvider.class, manager.getContextId(), e);
            }
        }
    }

    public void processAnnotatedTypes(@Observes ProcessAnnotatedType<?> event, BeanManager beanManager) {
        this.probe.getBootstrapStats().increment(BootstrapStats.EventType.PAT);
        this.addContainerLifecycleEvent(event, null, beanManager);
    }

    public void processInjectionPoints(@Observes ProcessInjectionPoint<?, ?> event, BeanManager beanManager) {
        this.probe.getBootstrapStats().increment(BootstrapStats.EventType.PIP);
        if (this.eventMonitorContainerLifecycleEvents) {
            this.addContainerLifecycleEvent(event, (Object)this.formatMember(event.getInjectionPoint().getMember()), beanManager);
        }
    }

    public void processInjectionTargets(@Observes ProcessInjectionTarget<?> event, BeanManager beanManager) {
        this.probe.getBootstrapStats().increment(BootstrapStats.EventType.PIT);
        if (this.eventMonitorContainerLifecycleEvents) {
            this.addContainerLifecycleEvent(event, (Object)Formats.formatType(event.getAnnotatedType().getBaseType(), false), beanManager);
        }
    }

    public void afterTypeDiscovery(@Observes AfterTypeDiscovery event, BeanManager beanManager) {
        this.addContainerLifecycleEvent(event, null, beanManager);
    }

    public void processObserverMethods(@Observes ProcessObserverMethod<?, ?> event, BeanManager beanManager) {
        this.probe.getBootstrapStats().increment(BootstrapStats.EventType.POM);
        if (this.eventMonitorContainerLifecycleEvents) {
            this.addContainerLifecycleEvent(event, (Object)(event.getAnnotatedMethod() != null ? this.formatMember(event.getAnnotatedMethod().getJavaMember()) : event.getObserverMethod().toString()), beanManager);
        }
    }

    public void processProducers(@Observes ProcessProducer<?, ?> event, BeanManager beanManager) {
        this.probe.getBootstrapStats().increment(BootstrapStats.EventType.PP);
        if (this.eventMonitorContainerLifecycleEvents) {
            this.addContainerLifecycleEvent(event, (Object)this.formatMember(event.getAnnotatedMember().getJavaMember()), beanManager);
        }
    }

    public void processBeans(@Observes ProcessBean<?> event, BeanManager beanManager) {
        this.probe.getBootstrapStats().increment(BootstrapStats.EventType.PB);
        if (this.eventMonitorContainerLifecycleEvents) {
            String info = event instanceof ProcessProducerMethod ? this.formatMember(((ProcessProducerMethod)event).getAnnotatedProducerMethod().getJavaMember()) : (event instanceof ProcessProducerField ? this.formatMember(((ProcessProducerField)event).getAnnotatedProducerField().getJavaMember()) : Formats.formatType(event.getBean().getBeanClass(), false));
            this.addContainerLifecycleEvent(event, (Object)info, beanManager);
        }
    }

    Probe getProbe() {
        return this.probe;
    }

    JsonDataProvider getJsonDataProvider() {
        return this.jsonDataProvider;
    }

    private boolean isJMXSupportEnabled(BeanManagerImpl manager) {
        return manager.getServices().get(WeldConfiguration.class).getBooleanProperty(ConfigurationKey.PROBE_JMX_SUPPORT);
    }

    private ObjectName constructProbeJsonDataMBeanName(BeanManagerImpl manager, Probe probe) throws MalformedObjectNameException {
        return new ObjectName(Probe.class.getPackage().getName() + ":type=JsonData,context=" + ObjectName.quote(manager.getContextId() + "_" + probe.getInitTs()));
    }

    private <T> boolean isMonitored(Annotated annotated, BeanAttributes<T> beanAttributes, WeldManager weldManager) {
        if (annotated.isAnnotationPresent(Interceptor.class) || annotated.isAnnotationPresent(Decorator.class)) {
            return false;
        }
        Type type = annotated instanceof AnnotatedMember ? ((AnnotatedMember)annotated).getDeclaringType().getBaseType() : annotated.getBaseType();
        UnproxyableResolutionException unproxyableException = Proxies.getUnproxyableTypeException(type, weldManager.getServices());
        if (unproxyableException != null) {
            ProbeLogger.LOG.invocationMonitorNotAssociatedNonProxyableType(type);
            ProbeLogger.LOG.catchingTrace((Throwable)((Object)unproxyableException));
            return false;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (this.invocationMonitorExcludePattern != null && this.invocationMonitorExcludePattern.matcher(clazz.getName()).matches()) {
                ProbeLogger.LOG.invocationMonitorNotAssociatedExcluded(clazz.getName());
                return false;
            }
        }
        return true;
    }

    private <T> void addContainerLifecycleEvent(T event, Object info, BeanManagerImpl beanManagerImpl) {
        ResolvedObservers resolvedObservers = null;
        Object eventType = null;
        if (event instanceof AbstractContainerEvent) {
            AbstractContainerEvent containerEvent = (AbstractContainerEvent)event;
            eventType = containerEvent.getEventType();
            resolvedObservers = beanManagerImpl.getGlobalLenientObserverNotifier().resolveObserverMethods((Type)eventType, new Annotation[0]);
        } else if (event instanceof ProcessAnnotatedTypeImpl) {
            ProcessAnnotatedTypeImpl processAnnotatedTypeEvent = (ProcessAnnotatedTypeImpl)event;
            eventType = ProcessAnnotatedType.class;
            info = Formats.formatType(processAnnotatedTypeEvent.getOriginalAnnotatedType().getBaseType(), false);
            resolvedObservers = beanManagerImpl.getGlobalLenientObserverNotifier().resolveObserverMethods(ProcessAnnotatedTypeEventResolvable.of(processAnnotatedTypeEvent, beanManagerImpl.getServices().get(RequiredAnnotationDiscovery.class)));
        }
        if (resolvedObservers != null && eventType != null) {
            this.probe.addEvent(new EventInfo((Type)eventType, Collections.emptySet(), info, null, (List)Reflections.cast(resolvedObservers.getAllObservers()), true, System.currentTimeMillis(), false));
        }
    }

    private <T> void addContainerLifecycleEvent(T event, Object payloadInfo, BeanManager beanManager) {
        if (this.eventMonitorContainerLifecycleEvents) {
            this.addContainerLifecycleEvent(event, payloadInfo, BeanManagerProxy.unwrap(beanManager));
        }
    }

    private String formatMember(Member member) {
        StringBuilder format = new StringBuilder();
        format.append(member.getDeclaringClass().getName());
        format.append(".");
        format.append(member.getName());
        if (member instanceof Method) {
            format.append("()");
        }
        return format.toString();
    }

    private void exportDataIfNeeded(BeanManagerImpl manager) {
        String export = manager.getServices().get(WeldConfiguration.class).getStringProperty(ConfigurationKey.PROBE_EXPORT_DATA_AFTER_DEPLOYMENT);
        if (!export.isEmpty()) {
            File exportPath = new File(export);
            if (!exportPath.canWrite()) {
                ProbeLogger.LOG.invalidExportPath(exportPath);
                return;
            }
            try {
                Files.write(new File(exportPath, "weld-probe-export.zip").toPath(), Exports.exportJsonData(this.jsonDataProvider), new OpenOption[0]);
            }
            catch (IOException e) {
                ProbeLogger.LOG.unableToExportData(e.getCause() != null ? e.getCause() : e);
                ProbeLogger.LOG.catchingTrace(e);
            }
        }
    }
}

