package org.jboss.weld.logging;

import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-08-24T10:03:06+0200")
public class ConfigurationLogger_$logger extends DelegatingBasicLogger implements ConfigurationLogger,org.jboss.weld.logging.WeldLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigurationLogger_$logger.class.getName();
    public ConfigurationLogger_$logger(final Logger log) {
        super(log);
    }
    private static final String invalidConfigurationPropertyValue = "WELD-001900: Invalid configuration property value {0} for key {1}";
    protected String invalidConfigurationPropertyValue$str() {
        return invalidConfigurationPropertyValue;
    }
    @Override
    public final IllegalStateException invalidConfigurationPropertyValue(final Object value, final Object key) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(invalidConfigurationPropertyValue$str(), value, key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String configurationPropertyTypeMismatch = "WELD-001901: Configuration property type {0} does not match the required type {1} for configuration key {2}";
    protected String configurationPropertyTypeMismatch$str() {
        return configurationPropertyTypeMismatch;
    }
    @Override
    public final IllegalStateException configurationPropertyTypeMismatch(final Object propertyType, final Object requiredType, final Object key) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(configurationPropertyTypeMismatch$str(), propertyType, requiredType, key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void configurationInitialized(final Object configuration) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, configurationInitialized$str(), configuration);
    }
    private static final String configurationInitialized = "WELD-001902: Following configuration was detected and applied: {0}";
    protected String configurationInitialized$str() {
        return configurationInitialized;
    }
    @Override
    public final void configurationKeyAlreadySet(final Object configurationKey, final Object value, final Object ignoredValue, final String mergedSourceDescription) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, configurationKeyAlreadySet$str(), configurationKey, value, ignoredValue, mergedSourceDescription);
    }
    private static final String configurationKeyAlreadySet = "WELD-001903: Configuration key {0} already set to {1} in a source with higher priority, value {2} from {3} is ignored";
    protected String configurationKeyAlreadySet$str() {
        return configurationKeyAlreadySet;
    }
    @Override
    public final void unsupportedConfigurationKeyFound(final Object key) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, unsupportedConfigurationKeyFound$str(), key);
    }
    private static final String unsupportedConfigurationKeyFound = "WELD-001904: Unsupported configuration key found and ignored: {0}";
    protected String unsupportedConfigurationKeyFound$str() {
        return unsupportedConfigurationKeyFound;
    }
    private static final String configurationKeyHasDifferentValues = "WELD-001905: Configuration key {0} set to different values in the same source:\n - {1}\n - {2}";
    protected String configurationKeyHasDifferentValues$str() {
        return configurationKeyHasDifferentValues;
    }
    @Override
    public final IllegalStateException configurationKeyHasDifferentValues(final Object key, final Object value1, final Object value2) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(configurationKeyHasDifferentValues$str(), key, value1, value2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void resourceLoaderNotSpecifiedForArchive(final Object archive) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, resourceLoaderNotSpecifiedForArchive$str(), archive);
    }
    private static final String resourceLoaderNotSpecifiedForArchive = "WELD-001906: ResourceLoader not specified for {0}, file properties will not be loaded";
    protected String resourceLoaderNotSpecifiedForArchive$str() {
        return resourceLoaderNotSpecifiedForArchive;
    }
    @Override
    public final void readingPropertiesFile(final Object file) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, readingPropertiesFile$str(), file);
    }
    private static final String readingPropertiesFile = "WELD-001907: Reading properties file: {0}";
    protected String readingPropertiesFile$str() {
        return readingPropertiesFile;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, throwable, catchingDebug$str());
    }
    private static final String catchingDebug = "Catching";
    protected String catchingDebug$str() {
        return catchingDebug;
    }
}
