package org.jboss.weld.logging;

import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;
import javax.enterprise.inject.spi.ObserverMethod;
import java.lang.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-08-24T10:03:06+0200")
public class EventLogger_$logger extends DelegatingBasicLogger implements EventLogger,org.jboss.weld.logging.WeldLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EventLogger_$logger.class.getName();
    public EventLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void asyncFire(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, asyncFire$str(), param1, param2);
    }
    private static final String asyncFire = "WELD-000400: Sending event {0} directly to observer {1}";
    protected String asyncFire$str() {
        return asyncFire;
    }
    @Override
    public final void asyncObserverFailure(final Object param1, final Object param2, final Object param3) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.ERROR, null, asyncObserverFailure$str(), param1, param2, param3);
    }
    private static final String asyncObserverFailure = "WELD-000401: Failure while notifying an observer {0} of event {1}.\n {2}";
    protected String asyncObserverFailure$str() {
        return asyncObserverFailure;
    }
    private static final String serializationProxyRequired = "WELD-000403: Proxy required";
    protected String serializationProxyRequired$str() {
        return serializationProxyRequired;
    }
    @Override
    public final InvalidObjectException serializationProxyRequired() {
        final InvalidObjectException result = new InvalidObjectException(String.format(serializationProxyRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidScopedConditionalObserver = "WELD-000404: Conditional observer method cannot be declared by a @Dependent scoped bean: {0}\n\tat {1}\n  StackTrace:";
    protected String invalidScopedConditionalObserver$str() {
        return invalidScopedConditionalObserver;
    }
    @Override
    public final DefinitionException invalidScopedConditionalObserver(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(invalidScopedConditionalObserver$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleEventParameters = "WELD-000405: Observer method cannot have more than one event parameter annotated with @Observes or @ObservesAsync: {0}\n\tat {1}\n  StackTrace:";
    protected String multipleEventParameters$str() {
        return multipleEventParameters;
    }
    @Override
    public final DefinitionException multipleEventParameters(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(multipleEventParameters$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDisposesParameter = "WELD-000406: Observer method cannot have a parameter annotated with @Disposes: {0}\n\tat {1}\n  StackTrace:";
    protected String invalidDisposesParameter$str() {
        return invalidDisposesParameter;
    }
    @Override
    public final DefinitionException invalidDisposesParameter(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(invalidDisposesParameter$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidProducer = "WELD-000407: Observer method cannot be annotated with @Produces: {0}\n\tat {1}\n  StackTrace:";
    protected String invalidProducer$str() {
        return invalidProducer;
    }
    @Override
    public final DefinitionException invalidProducer(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(invalidProducer$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidInitializer = "WELD-000408: Observer method cannot be annotated with @Inject, observer methods are automatically injection points: {0}\n\tat {1}\n  StackTrace:";
    protected String invalidInitializer$str() {
        return invalidInitializer;
    }
    @Override
    public final DefinitionException invalidInitializer(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(invalidInitializer$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidInjectionPoint = "WELD-000409: Observer method for container lifecycle event can only inject BeanManager: {0}\n\tat {1}\n  StackTrace:";
    protected String invalidInjectionPoint$str() {
        return invalidInjectionPoint;
    }
    @Override
    public final DefinitionException invalidInjectionPoint(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(invalidInjectionPoint$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidWithAnnotations = "WELD-000410: Observer method cannot define @WithAnnotations: {0}\n\tat {1}\n  StackTrace:";
    protected String invalidWithAnnotations$str() {
        return invalidWithAnnotations;
    }
    @Override
    public final DefinitionException invalidWithAnnotations(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(invalidWithAnnotations$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unrestrictedProcessAnnotatedTypes(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.INFO, null, unrestrictedProcessAnnotatedTypes$str(), param1);
    }
    private static final String unrestrictedProcessAnnotatedTypes = "WELD-000411: Observer method {0} receives events for all annotated types. Consider restricting events using @WithAnnotations or a generic type with bounds.";
    protected String unrestrictedProcessAnnotatedTypes$str() {
        return unrestrictedProcessAnnotatedTypes;
    }
    private static final String observerMethodsMethodReturnsNull = "WELD-000412: ObserverMethod.{0}() returned null for {1}";
    protected String observerMethodsMethodReturnsNull$str() {
        return observerMethodsMethodReturnsNull;
    }
    @Override
    public final DefinitionException observerMethodsMethodReturnsNull(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(observerMethodsMethodReturnsNull$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanClassMismatch = "WELD-000413: {0} cannot be replaced by an observer method with a different bean class {1}";
    protected String beanClassMismatch$str() {
        return beanClassMismatch;
    }
    @Override
    public final DefinitionException beanClassMismatch(final ObserverMethod<? extends Object> originalObserverMethod, final ObserverMethod<? extends Object> observerMethod) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(beanClassMismatch$str(), originalObserverMethod, observerMethod));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asyncContainerLifecycleEventObserver = "WELD-000414: Observer method for container lifecycle event cannot be asynchronous. {0}\n\tat {1}\n  StackTrace:";
    protected String asyncContainerLifecycleEventObserver$str() {
        return asyncContainerLifecycleEventObserver;
    }
    @Override
    public final DefinitionException asyncContainerLifecycleEventObserver(final ObserverMethod<? extends Object> observer, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(asyncContainerLifecycleEventObserver$str(), observer, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notifyMethodNotImplemented = "WELD-000415: Custom implementation of observer method does not override either notify(T) or notify(EventContext<T>): {0}";
    protected String notifyMethodNotImplemented$str() {
        return notifyMethodNotImplemented;
    }
    @Override
    public final DefinitionException notifyMethodNotImplemented(final Object observer) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(notifyMethodNotImplemented$str(), observer));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noneOrMultipleEventParametersDeclared = "WELD-000416: None or multiple event parameters declared on: {0}\n\tat {1}\n  StackTrace:";
    protected String noneOrMultipleEventParametersDeclared$str() {
        return noneOrMultipleEventParametersDeclared;
    }
    @Override
    public final IllegalArgumentException noneOrMultipleEventParametersDeclared(final Object method, final Object stackElement) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(noneOrMultipleEventParametersDeclared$str(), method, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void originalObservedTypeIsNotAssignableFrom(final Object originalObservedType, final Object observedType, final Object extension) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, originalObservedTypeIsNotAssignableFrom$str(), originalObservedType, observedType, extension);
    }
    private static final String originalObservedTypeIsNotAssignableFrom = "WELD-000417: The original observed type {0} is not assignable from {1} set by extension {2} - the observer method invocation may result in runtime exception!";
    protected String originalObservedTypeIsNotAssignableFrom$str() {
        return originalObservedTypeIsNotAssignableFrom;
    }
    private static final String staticContainerLifecycleEventObserver = "WELD-000418: Observer method for container lifecycle event cannot be static. {0}\n\tat {1}\n  StackTrace:";
    protected String staticContainerLifecycleEventObserver$str() {
        return staticContainerLifecycleEventObserver;
    }
    @Override
    public final DefinitionException staticContainerLifecycleEventObserver(final ObserverMethod<? extends Object> observer, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(staticContainerLifecycleEventObserver$str(), observer, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNotificationMode = "WELD-000419: {0} is not a valid notification mode for asynchronous observers";
    protected String invalidNotificationMode$str() {
        return invalidNotificationMode;
    }
    @Override
    public final IllegalArgumentException invalidNotificationMode(final Object mode) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(invalidNotificationMode$str(), mode));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noScheduledExecutorServicesProvided = "WELD-000420: Asynchronous observer notification with timeout option requires an implementation of ExecutorServices which provides an instance of ScheduledExecutorServices.";
    protected String noScheduledExecutorServicesProvided$str() {
        return noScheduledExecutorServicesProvided;
    }
    @Override
    public final UnsupportedOperationException noScheduledExecutorServicesProvided() {
        final UnsupportedOperationException result = new UnsupportedOperationException(noScheduledExecutorServicesProvided$str());
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidInputValueForTimeout = "WELD-000421: Invalid input value for asynchronous observer notification timeout. Has to be parseable String, java.lang.Long or long. Original exception: {0}";
    protected String invalidInputValueForTimeout$str() {
        return invalidInputValueForTimeout;
    }
    @Override
    public final IllegalArgumentException invalidInputValueForTimeout(final Object nfe) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(invalidInputValueForTimeout$str(), nfe));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, throwable, catchingDebug$str());
    }
    private static final String catchingDebug = "Catching";
    protected String catchingDebug$str() {
        return catchingDebug;
    }
}
