package org.jboss.weld.logging;

import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.weld.contexts.NonexistentConversationException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.weld.contexts.BusyConversationException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-11-23T10:58:41+0100")
public class ConversationLogger_$logger extends DelegatingBasicLogger implements ConversationLogger,org.jboss.weld.logging.WeldLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConversationLogger_$logger.class.getName();
    public ConversationLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void cleaningUpConversation(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, cleaningUpConversation$str(), param1);
    }
    private static final String cleaningUpConversation = "WELD-000304: Cleaning up conversation {0}";
    protected String cleaningUpConversation$str() {
        return cleaningUpConversation;
    }
    @Override
    public final void conversationLocked(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, conversationLocked$str(), param1);
    }
    private static final String conversationLocked = "WELD-000313: Lock acquired on conversation {0}";
    protected String conversationLocked$str() {
        return conversationLocked;
    }
    @Override
    public final void conversationUnlocked(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, conversationUnlocked$str(), param1);
    }
    private static final String conversationUnlocked = "WELD-000314: Lock released on conversation {0}";
    protected String conversationUnlocked$str() {
        return conversationUnlocked;
    }
    @Override
    public final void conversationUnavailable(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, conversationUnavailable$str(), param1, param2);
    }
    private static final String conversationUnavailable = "WELD-000315: Failed to acquire conversation lock in {0} ms for {1}";
    protected String conversationUnavailable$str() {
        return conversationUnavailable;
    }
    @Override
    public final void illegalConversationUnlockAttempt(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, illegalConversationUnlockAttempt$str(), param1, param2);
    }
    private static final String illegalConversationUnlockAttempt = "WELD-000316: Attempt to release lock on conversation {0} failed because {1}";
    protected String illegalConversationUnlockAttempt$str() {
        return illegalConversationUnlockAttempt;
    }
    @Override
    public final void promotedTransientConversation(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, promotedTransientConversation$str(), param1);
    }
    private static final String promotedTransientConversation = "WELD-000317: Promoted conversation {0} to long-running";
    protected String promotedTransientConversation$str() {
        return promotedTransientConversation;
    }
    @Override
    public final void demotedLongRunningConversation(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, demotedLongRunningConversation$str(), param1);
    }
    private static final String demotedLongRunningConversation = "WELD-000318: Returned long-running conversation {0} to transient";
    protected String demotedLongRunningConversation$str() {
        return demotedLongRunningConversation;
    }
    @Override
    public final void cleaningUpTransientConversation() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.TRACE, null, cleaningUpTransientConversation$str());
    }
    private static final String cleaningUpTransientConversation = "WELD-000320: Cleaning up transient conversation";
    protected String cleaningUpTransientConversation$str() {
        return cleaningUpTransientConversation;
    }
    private static final String noConversationFoundToRestore = "WELD-000321: No conversation found to restore for id {0}";
    protected String noConversationFoundToRestore$str() {
        return noConversationFoundToRestore;
    }
    @Override
    public final NonexistentConversationException noConversationFoundToRestore(final Object param1) {
        final NonexistentConversationException result = new NonexistentConversationException(java.text.MessageFormat.format(noConversationFoundToRestore$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conversationLockTimedout = "WELD-000322: Conversation lock timed out: {0}";
    protected String conversationLockTimedout$str() {
        return conversationLockTimedout;
    }
    @Override
    public final BusyConversationException conversationLockTimedout(final Object param1) {
        final BusyConversationException result = new BusyConversationException(java.text.MessageFormat.format(conversationLockTimedout$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void foundConversationFromRequest(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, foundConversationFromRequest$str(), param1);
    }
    private static final String foundConversationFromRequest = "WELD-000326: Found conversation id {0} in request parameter";
    protected String foundConversationFromRequest$str() {
        return foundConversationFromRequest;
    }
    @Override
    public final void resumingConversation(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, resumingConversation$str(), param1);
    }
    private static final String resumingConversation = "WELD-000327: Resuming conversation with id {0}";
    protected String resumingConversation$str() {
        return resumingConversation;
    }
    private static final String beginCalledOnLongRunningConversation = "WELD-000328: Attempt to call begin() on a long-running conversation";
    protected String beginCalledOnLongRunningConversation$str() {
        return beginCalledOnLongRunningConversation;
    }
    @Override
    public final IllegalStateException beginCalledOnLongRunningConversation() {
        final IllegalStateException result = new IllegalStateException(String.format(beginCalledOnLongRunningConversation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String endCalledOnTransientConversation = "WELD-000329: Attempt to call end() on a transient conversation";
    protected String endCalledOnTransientConversation$str() {
        return endCalledOnTransientConversation;
    }
    @Override
    public final IllegalStateException endCalledOnTransientConversation() {
        final IllegalStateException result = new IllegalStateException(String.format(endCalledOnTransientConversation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conversationIdAlreadyInUse = "WELD-000332: Conversation ID {0} is already in use";
    protected String conversationIdAlreadyInUse$str() {
        return conversationIdAlreadyInUse;
    }
    @Override
    public final IllegalArgumentException conversationIdAlreadyInUse(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(conversationIdAlreadyInUse$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mustCallAssociateBeforeActivate = "WELD-000333: Must call associate() before calling activate()";
    protected String mustCallAssociateBeforeActivate$str() {
        return mustCallAssociateBeforeActivate;
    }
    @Override
    public final IllegalStateException mustCallAssociateBeforeActivate() {
        final IllegalStateException result = new IllegalStateException(mustCallAssociateBeforeActivate$str());
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mustCallAssociateBeforeDeactivate = "WELD-000334: Must call associate() before calling deactivate()";
    protected String mustCallAssociateBeforeDeactivate$str() {
        return mustCallAssociateBeforeDeactivate;
    }
    @Override
    public final IllegalStateException mustCallAssociateBeforeDeactivate() {
        final IllegalStateException result = new IllegalStateException(mustCallAssociateBeforeDeactivate$str());
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void contextAlreadyActive(final Object request) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, contextAlreadyActive$str(), request);
    }
    private static final String contextAlreadyActive = "WELD-000335: Conversation context is already active, most likely it was not cleaned up properly during previous request processing: {0}";
    protected String contextAlreadyActive$str() {
        return contextAlreadyActive;
    }
    private static final String contextNotActive = "WELD-000336: Conversation context is not active";
    protected String contextNotActive$str() {
        return contextNotActive;
    }
    @Override
    public final IllegalStateException contextNotActive() {
        final IllegalStateException result = new IllegalStateException(contextNotActive$str());
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conversationNamingSchemeNotFound = "WELD-000337: Unable to find ConversationNamingScheme in the request, this conversation wasn't transient at the start of the request";
    protected String conversationNamingSchemeNotFound$str() {
        return conversationNamingSchemeNotFound;
    }
    @Override
    public final IllegalStateException conversationNamingSchemeNotFound() {
        final IllegalStateException result = new IllegalStateException(conversationNamingSchemeNotFound$str());
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conversationIdGeneratorNotFound = "WELD-000338: Unable to locate ConversationIdGenerator";
    protected String conversationIdGeneratorNotFound$str() {
        return conversationIdGeneratorNotFound;
    }
    @Override
    public final IllegalStateException conversationIdGeneratorNotFound() {
        final IllegalStateException result = new IllegalStateException(conversationIdGeneratorNotFound$str());
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mustCallAssociateBeforeGeneratingId = "WELD-000339: A request must be associated with the context in order to generate a conversation id";
    protected String mustCallAssociateBeforeGeneratingId$str() {
        return mustCallAssociateBeforeGeneratingId;
    }
    @Override
    public final IllegalStateException mustCallAssociateBeforeGeneratingId() {
        final IllegalStateException result = new IllegalStateException(mustCallAssociateBeforeGeneratingId$str());
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mustCallAssociateBeforeLoadingKnownConversations = "WELD-000340: A request must be associated with the context in order to load the known conversations";
    protected String mustCallAssociateBeforeLoadingKnownConversations$str() {
        return mustCallAssociateBeforeLoadingKnownConversations;
    }
    @Override
    public final IllegalStateException mustCallAssociateBeforeLoadingKnownConversations() {
        final IllegalStateException result = new IllegalStateException(mustCallAssociateBeforeLoadingKnownConversations$str());
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadConversations = "WELD-000341: Unable to load the conversations from the associated request - {0}: {1}, request: {2}";
    protected String unableToLoadConversations$str() {
        return unableToLoadConversations;
    }
    @Override
    public final IllegalStateException unableToLoadConversations(final String attributeName, final Object attributeValue, final Object request) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(unableToLoadConversations$str(), attributeName, attributeValue, request));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void endLockedConversation(final String cid) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, endLockedConversation$str(), cid);
    }
    private static final String endLockedConversation = "WELD-000342: Going to end a locked conversation with id {0}";
    protected String endLockedConversation$str() {
        return endLockedConversation;
    }
    private static final String unableToLoadCurrentConversation = "WELD-000343: Unable to load the current conversation from the associated request - {0}: {1}, request: {2}";
    protected String unableToLoadCurrentConversation$str() {
        return unableToLoadCurrentConversation;
    }
    @Override
    public final IllegalStateException unableToLoadCurrentConversation(final String attributeName, final Object attributeValue, final Object request) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(unableToLoadCurrentConversation$str(), attributeName, attributeValue, request));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, throwable, catchingDebug$str());
    }
    private static final String catchingDebug = "Catching";
    protected String catchingDebug$str() {
        return catchingDebug;
    }
}
