/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.ObjectStreamException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.code.BranchEnd;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.bean.proxy.CommonProxiedMethodFilters;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.ProxyMethodHandler;
import org.jboss.weld.bean.proxy.RunWithinInterceptionDecorationContextGenerator;
import org.jboss.weld.bean.proxy.util.SerializableClientProxy;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.proxy.WeldClientProxy;
import org.jboss.weld.security.GetDeclaredFieldAction;
import org.jboss.weld.security.SetAccessibleAction;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.bytecode.DeferredBytecode;
import org.jboss.weld.util.bytecode.MethodInformation;

public class ClientProxyFactory<T>
extends ProxyFactory<T> {
    private static final String CLIENT_PROXY_SUFFIX = "ClientProxy";
    private static final String HASH_CODE_METHOD = "hashCode";
    private static final String EMPTY_PARENTHESES = "()";
    private static final String BEAN_ID_FIELD = "BEAN_ID_FIELD";
    private final BeanIdentifier beanId;
    private volatile Field beanIdField;

    public ClientProxyFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean) {
        super(contextId, proxiedBeanType, typeClosure, bean);
        this.beanId = Container.instance(contextId).services().get(ContextualStore.class).putIfAbsent((Contextual<?>)bean);
    }

    @Override
    public T create(BeanInstance beanInstance) {
        try {
            Object instance = super.create(beanInstance);
            if (this.beanIdField == null) {
                Field f = AccessController.doPrivileged(new GetDeclaredFieldAction(instance.getClass(), BEAN_ID_FIELD));
                AccessController.doPrivileged(SetAccessibleAction.of(f));
                this.beanIdField = f;
            }
            this.beanIdField.set(instance, this.beanId);
            return instance;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    protected void addAdditionalInterfaces(Set<Class<?>> interfaces) {
        interfaces.add(WeldClientProxy.class);
    }

    @Override
    protected void addMethods(ClassFile proxyClassType, ClassMethod staticConstructor) {
        super.addMethods(proxyClassType, staticConstructor);
        this.generateWeldClientProxyMethod(proxyClassType);
    }

    private void generateWeldClientProxyMethod(ClassFile proxyClassType) {
        try {
            Method getContextualMetadata = WeldClientProxy.class.getMethod("getMetadata", new Class[0]);
            this.generateBodyForWeldClientProxyMethod(proxyClassType.addMethod(getContextualMetadata));
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private void generateBodyForWeldClientProxyMethod(ClassMethod method) throws Exception {
        CodeAttribute b = method.getCodeAttribute();
        b.aload(0);
        this.getMethodHandlerField(method.getClassFile(), b);
        b.returnInstruction();
    }

    @Override
    protected void addFields(ClassFile proxyClassType, List<DeferredBytecode> initialValueBytecode) {
        super.addFields(proxyClassType, initialValueBytecode);
        proxyClassType.addField(66, BEAN_ID_FIELD, BeanIdentifier.class);
    }

    @Override
    protected Class<? extends MethodHandler> getMethodHandlerType() {
        return ProxyMethodHandler.class;
    }

    @Override
    protected void addSerializationSupport(ClassFile proxyClassType) {
        Class[] exceptions = new Class[]{ObjectStreamException.class};
        ClassMethod writeReplace = proxyClassType.addMethod(2, "writeReplace", "Ljava/lang/Object;", new String[0]);
        writeReplace.addCheckedExceptions(exceptions);
        CodeAttribute b = writeReplace.getCodeAttribute();
        b.newInstruction(SerializableClientProxy.class.getName());
        b.dup();
        b.aload(0);
        b.getfield(proxyClassType.getName(), BEAN_ID_FIELD, BeanIdentifier.class);
        b.ldc(this.getContextId());
        b.invokespecial(SerializableClientProxy.class.getName(), "<init>", "(Lorg/jboss/weld/serialization/spi/BeanIdentifier;Ljava/lang/String;)V");
        b.returnInstruction();
    }

    @Override
    protected void createForwardingMethodBody(ClassMethod classMethod, final MethodInformation methodInfo, ClassMethod staticConstructor) {
        final Method method = methodInfo.getMethod();
        boolean bytecodeInvocationAllowed = Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getReturnType().getModifiers());
        for (Class<?> paramType : method.getParameterTypes()) {
            if (Modifier.isPublic(paramType.getModifiers())) continue;
            bytecodeInvocationAllowed = false;
            break;
        }
        if (!bytecodeInvocationAllowed) {
            this.createInterceptorBody(classMethod, methodInfo, staticConstructor);
            return;
        }
        new RunWithinInterceptionDecorationContextGenerator(classMethod, this){

            @Override
            void doWork(CodeAttribute b, ClassMethod classMethod) {
                ClientProxyFactory.this.loadBeanInstance(classMethod.getClassFile(), methodInfo, b);
                b.dup();
                String methodDescriptor = methodInfo.getDescriptor();
                b.loadMethodParameters();
                if (method.getDeclaringClass().isInterface()) {
                    b.invokeinterface(methodInfo.getDeclaringClass(), methodInfo.getName(), methodDescriptor);
                } else {
                    b.invokevirtual(methodInfo.getDeclaringClass(), methodInfo.getName(), methodDescriptor);
                }
            }

            @Override
            void doReturn(CodeAttribute b, ClassMethod classMethod) {
                if (method.getReturnType().isPrimitive()) {
                    b.returnInstruction();
                } else {
                    b.dupX1();
                    BranchEnd returnInstruction = b.ifAcmpeq();
                    b.returnInstruction();
                    b.branchEnd(returnInstruction);
                    b.aload(0);
                    b.checkcast(methodInfo.getMethod().getReturnType().getName());
                    b.returnInstruction();
                }
            }
        }.runStartIfNotEmpty();
    }

    private void loadBeanInstance(ClassFile file, MethodInformation methodInfo, CodeAttribute b) {
        b.aload(0);
        this.getMethodHandlerField(file, b);
        b.invokevirtual(ProxyMethodHandler.class.getName(), "getInstance", "()Ljava/lang/Object;");
        b.checkcast(methodInfo.getDeclaringClass());
    }

    @Override
    protected void generateHashCodeMethod(ClassFile proxyClassType) {
        ClassMethod method = proxyClassType.addMethod(1, HASH_CODE_METHOD, "I", new String[0]);
        CodeAttribute b = method.getCodeAttribute();
        b.loadClass(proxyClassType.getName());
        b.invokevirtual("java.lang.Object", HASH_CODE_METHOD, "()I");
        b.returnInstruction();
    }

    @Override
    protected void generateEqualsMethod(ClassFile proxyClassType) {
        ClassMethod method = proxyClassType.addMethod(1, "equals", "Z", new String[]{"Ljava/lang/Object;"});
        CodeAttribute b = method.getCodeAttribute();
        b.aload(1);
        b.instanceofInstruction(proxyClassType.getName());
        b.returnInstruction();
    }

    @Override
    protected String getProxyNameSuffix() {
        return CLIENT_PROXY_SUFFIX;
    }

    @Override
    protected boolean isMethodAccepted(Method method, Class<?> proxySuperclass) {
        return super.isMethodAccepted(method, proxySuperclass) && CommonProxiedMethodFilters.NON_PRIVATE.accept(method, proxySuperclass);
    }
}

