package org.jboss.weld.probe;

import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-04-24T12:19:09+0200")
public class ProbeLogger_$logger extends DelegatingBasicLogger implements ProbeLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ProbeLogger_$logger.class.getName();
    public ProbeLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void catchingTrace(final Throwable throwable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.TRACE, throwable, catchingTrace$str());
    }
    private static final String catchingTrace = "Catching";
    protected String catchingTrace$str() {
        return catchingTrace;
    }
    @Override
    public final void resourceMatched(final Object resource, final String pathInfo) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, resourceMatched$str(), resource, pathInfo);
    }
    private static final String resourceMatched = "PROBE-000001: Resource {0} matched for {1}";
    protected String resourceMatched$str() {
        return resourceMatched;
    }
    @Override
    public final void processingBeanDeploymentArchive(final Object archive) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.INFO, null, processingBeanDeploymentArchive$str(), archive);
    }
    private static final String processingBeanDeploymentArchive = "PROBE-000002: Processing bean deployment archive: {0}";
    protected String processingBeanDeploymentArchive$str() {
        return processingBeanDeploymentArchive;
    }
    @Override
    public final void introspectionProblem(final Object bean, final Throwable cause) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, cause, introspectionProblem$str(), bean);
    }
    private static final String introspectionProblem = "PROBE-000003: A problem occured during contextual instance introspection: {0}";
    protected String introspectionProblem$str() {
        return introspectionProblem;
    }
    @Override
    public final void filtersApplied(final Object filters) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, filtersApplied$str(), filters);
    }
    private static final String filtersApplied = "PROBE-000004: Filters applied: {0}";
    protected String filtersApplied$str() {
        return filtersApplied;
    }
    private static final String probeNotInitialized = "PROBE-000005: Probe is not properly initialized";
    protected String probeNotInitialized$str() {
        return probeNotInitialized;
    }
    @Override
    public final IllegalStateException probeNotInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(probeNotInitialized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void invocationMonitorNotAssociatedExcluded(final Object beanClass) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, invocationMonitorNotAssociatedExcluded$str(), beanClass);
    }
    private static final String invocationMonitorNotAssociatedExcluded = "PROBE-000006: {0} not monitored - excluded";
    protected String invocationMonitorNotAssociatedExcluded$str() {
        return invocationMonitorNotAssociatedExcluded;
    }
    @Override
    public final void developmentModeEnabled() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, developmentModeEnabled$str());
    }
    private static final String developmentModeEnabled = "PROBE-000008: \n=====================================\n Weld Development Mode: ENABLED\n ------------------------------------\n Disable this mode in production - it may have negative impact on performance and/or represent a potential security risk\n=====================================";
    protected String developmentModeEnabled$str() {
        return developmentModeEnabled;
    }
    @Override
    public final void monitoringStereotypeAdded(final Object bean) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, monitoringStereotypeAdded$str(), bean);
    }
    private static final String monitoringStereotypeAdded = "PROBE-000009: @MonitoredComponent stereotype added to {0}";
    protected String monitoringStereotypeAdded$str() {
        return monitoringStereotypeAdded;
    }
    @Override
    public final void invocationMonitorNotAssociatedNonProxyableType(final Object type) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, invocationMonitorNotAssociatedNonProxyableType$str(), type);
    }
    private static final String invocationMonitorNotAssociatedNonProxyableType = "PROBE-000010: {0} not monitored - non-proxyable type";
    protected String invocationMonitorNotAssociatedNonProxyableType$str() {
        return invocationMonitorNotAssociatedNonProxyableType;
    }
    @Override
    public final void eventExcluded(final Object type) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, eventExcluded$str(), type);
    }
    private static final String eventExcluded = "PROBE-000011: Event {0} not monitored - excluded";
    protected String eventExcluded$str() {
        return eventExcluded;
    }
    @Override
    public final void monitoringLimitExceeded(final Object monitor, final Object limit) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, monitoringLimitExceeded$str(), monitor, limit);
    }
    private static final String monitoringLimitExceeded = "PROBE-000012: {0} monitoring limit {1} exceed - some old data were removed";
    protected String monitoringLimitExceeded$str() {
        return monitoringLimitExceeded;
    }
    private static final String probeFilterUnableToOperate = "PROBE-000013: Probe filter is not able to operate - missing {0}";
    protected String probeFilterUnableToOperate$str() {
        return probeFilterUnableToOperate;
    }
    @Override
    public final IllegalStateException probeFilterUnableToOperate(final Class<? extends Object> component) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(probeFilterUnableToOperate$str(), component));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToRegisterMBean = "PROBE-000014: Cannot register a Probe MBean {0} for: {1}";
    protected String unableToRegisterMBean$str() {
        return unableToRegisterMBean;
    }
    @Override
    public final IllegalStateException unableToRegisterMBean(final Object mbean, final Object context, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(unableToRegisterMBean$str(), mbean, context), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToUnregisterMBean = "PROBE-000015: Cannot unregister a Probe MBean {0} for: {1}";
    protected String unableToUnregisterMBean$str() {
        return unableToUnregisterMBean;
    }
    @Override
    public final IllegalStateException unableToUnregisterMBean(final Object mbean, final Object context, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(unableToUnregisterMBean$str(), mbean, context), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToParseQueryFilter = "PROBE-000016: Unable to parse query filters: {0}";
    protected String unableToParseQueryFilter$str() {
        return unableToParseQueryFilter;
    }
    @Override
    public final IllegalArgumentException unableToParseQueryFilter(final Object filters) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(unableToParseQueryFilter$str(), filters));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void requestDenied(final Object requestInfo, final Object remoteAddr) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, requestDenied$str(), requestInfo, remoteAddr);
    }
    private static final String requestDenied = "PROBE-000017: Access to {0} denied for {1}";
    protected String requestDenied$str() {
        return requestDenied;
    }
    @Override
    public final void invalidExportPath(final Object path) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, invalidExportPath$str(), path);
    }
    private static final String invalidExportPath = "PROBE-000018: Export path does not exist or is not writable: {0}";
    protected String invalidExportPath$str() {
        return invalidExportPath;
    }
    @Override
    public final void unableToExportData(final Object path, final Object cause) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, unableToExportData$str(), path, cause);
    }
    private static final String unableToExportData = "PROBE-000019: Unable to export data to {0}: {1}";
    protected String unableToExportData$str() {
        return unableToExportData;
    }
    @Override
    public final void aroundConstructMonitoringProblem(final Object bean, final Throwable cause) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, cause, aroundConstructMonitoringProblem$str(), bean);
    }
    private static final String aroundConstructMonitoringProblem = "PROBE-000020: A problem occured during monitoring of bean instance construction: {0}";
    protected String aroundConstructMonitoringProblem$str() {
        return aroundConstructMonitoringProblem;
    }
    @Override
    public final void validationReportExported(final Object path) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, validationReportExported$str(), path);
    }
    private static final String validationReportExported = "PROBE-000021: \n=====================================\n Weld - Deployment Validation: FAILED \n ------------------------------------\n HTML report generated to: \n\n {0} \n=====================================";
    protected String validationReportExported$str() {
        return validationReportExported;
    }
    @Override
    public final void cannotUseUnifiedAnnotationToStringConversion(final Object path) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, cannotUseUnifiedAnnotationToStringConversion$str(), path);
    }
    private static final String cannotUseUnifiedAnnotationToStringConversion = "PROBE-000022: Probe was not allowed to use customized Annotation toString(), falling back to JDK's default Annotation.toString(). The exception was: {0}";
    protected String cannotUseUnifiedAnnotationToStringConversion$str() {
        return cannotUseUnifiedAnnotationToStringConversion;
    }
}
