package org.jboss.weld.module.web.logging;

import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.ClassLoader;
import java.lang.Object;
import java.util.Arrays;
import org.jboss.weld.module.web.servlet.ServletContextService;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-02-06T10:23:42+0100")
public class ServletLogger_$logger extends DelegatingBasicLogger implements ServletLogger,WeldLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ServletLogger_$logger.class.getName();
    public ServletLogger_$logger(final Logger log) {
        super(log);
    }
    private static final String onlyHttpServletLifecycleDefined = "WELD-000707: Non Http-Servlet lifecycle not defined";
    protected String onlyHttpServletLifecycleDefined$str() {
        return onlyHttpServletLifecycleDefined;
    }
    @Override
    public final IllegalStateException onlyHttpServletLifecycleDefined() {
        final IllegalStateException result = new IllegalStateException(String.format(onlyHttpServletLifecycleDefined$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void requestInitialized(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, requestInitialized$str(), param1);
    }
    private static final String requestInitialized = "WELD-000708: Initializing request {0}";
    protected String requestInitialized$str() {
        return requestInitialized;
    }
    @Override
    public final void requestDestroyed(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, requestDestroyed$str(), param1);
    }
    private static final String requestDestroyed = "WELD-000709: Destroying request {0}";
    protected String requestDestroyed$str() {
        return requestDestroyed;
    }
    private static final String cannotInjectObjectOutsideOfServletRequest = "WELD-000710: Cannot inject {0} outside of a Servlet request";
    protected String cannotInjectObjectOutsideOfServletRequest$str() {
        return cannotInjectObjectOutsideOfServletRequest;
    }
    @Override
    public final IllegalStateException cannotInjectObjectOutsideOfServletRequest(final Object param1, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(cannotInjectObjectOutsideOfServletRequest$str(), param1), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void webXmlMappingPatternIgnored(final String pattern) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, webXmlMappingPatternIgnored$str(), pattern);
    }
    private static final String webXmlMappingPatternIgnored = "WELD-000711: Context activation pattern {0} ignored as it is overriden by the integrator.";
    protected String webXmlMappingPatternIgnored$str() {
        return webXmlMappingPatternIgnored;
    }
    @Override
    public final void unableToDissociateContext(final Object context, final Object storage) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, unableToDissociateContext$str(), context, storage);
    }
    private static final String unableToDissociateContext = "WELD-000712: Unable to dissociate context {0} from the storage {1}";
    protected String unableToDissociateContext$str() {
        return unableToDissociateContext;
    }
    private static final String cannotInjectServletContext = "WELD-000713: Unable to inject ServletContext. None is associated with {0}, {1}";
    protected String cannotInjectServletContext$str() {
        return cannotInjectServletContext;
    }
    @Override
    public final IllegalStateException cannotInjectServletContext(final ClassLoader classLoader, final ServletContextService service) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(cannotInjectServletContext$str(), classLoader, service));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void guardLeak(final int value) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, guardLeak$str(), value);
    }
    private static final String guardLeak = "WELD-000714: HttpContextLifecycle guard leak detected. The Servlet container is not fully compliant. The value was {0}";
    protected String guardLeak$str() {
        return guardLeak;
    }
    @Override
    public final void guardNotSet() {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, guardNotSet$str());
    }
    private static final String guardNotSet = "WELD-000715: HttpContextLifecycle guard not set. The Servlet container is not fully compliant.";
    protected String guardNotSet$str() {
        return guardNotSet;
    }
    @Override
    public final void servlet2Environment() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, servlet2Environment$str());
    }
    private static final String servlet2Environment = "WELD-000716: Running in Servlet 2.x environment. Asynchronous request support is disabled.";
    protected String servlet2Environment$str() {
        return servlet2Environment;
    }
    @Override
    public final void unableToDeactivateContext(final Object context, final Object request) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, unableToDeactivateContext$str(), context, request);
    }
    private static final String unableToDeactivateContext = "WELD-000717: Unable to deactivate context {0} when destroying request {1}";
    protected String unableToDeactivateContext$str() {
        return unableToDeactivateContext;
    }
    @Override
    public final void noEeModuleDescriptor(final Object beanArchiveId) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, noEeModuleDescriptor$str(), beanArchiveId);
    }
    private static final String noEeModuleDescriptor = "WELD-000718: No EEModuleDescriptor defined for bean archive with ID: {0}. @Initialized and @Destroyed events for ApplicationScoped may be fired twice.";
    protected String noEeModuleDescriptor$str() {
        return noEeModuleDescriptor;
    }
    @Override
    public final void catchingDebug(final Throwable arg0) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, arg0, catchingDebug$str());
    }
    private static final String catchingDebug = "Catching";
    protected String catchingDebug$str() {
        return catchingDebug;
    }
}
