package org.jboss.weld.logging;

import org.jboss.weld.exceptions.NullInstanceException;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.weld.exceptions.IllegalProductException;
import org.jboss.weld.exceptions.CreationException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-11-27T13:36:28+0100")
public class BeanLogger_$logger extends DelegatingBasicLogger implements BeanLogger,org.jboss.weld.logging.WeldLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = BeanLogger_$logger.class.getName();
    public BeanLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void foundOneInjectableConstructor(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, foundOneInjectableConstructor$str(), param1, param2);
    }
    private static final String foundOneInjectableConstructor = "WELD-000001: Exactly one constructor ({0}) annotated with @Inject defined, using it as the bean constructor for {1}";
    protected String foundOneInjectableConstructor$str() {
        return foundOneInjectableConstructor;
    }
    @Override
    public final void foundDefaultConstructor(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, foundDefaultConstructor$str(), param1, param2);
    }
    private static final String foundDefaultConstructor = "WELD-000002: Exactly one constructor ({0}) defined, using it as the bean constructor for {1}";
    protected String foundDefaultConstructor$str() {
        return foundDefaultConstructor;
    }
    @Override
    public final void foundOnePostConstructMethod(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, foundOnePostConstructMethod$str(), param1, param2);
    }
    private static final String foundOnePostConstructMethod = "WELD-000004: Exactly one post construct method ({0}) for {1}";
    protected String foundOnePostConstructMethod$str() {
        return foundOnePostConstructMethod;
    }
    @Override
    public final void foundOnePreDestroyMethod(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, foundOnePreDestroyMethod$str(), param1, param2);
    }
    private static final String foundOnePreDestroyMethod = "WELD-000006: Exactly one pre destroy method ({0}) for {1}";
    protected String foundOnePreDestroyMethod$str() {
        return foundOnePreDestroyMethod;
    }
    @Override
    public final void createdSessionBeanProxy(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, createdSessionBeanProxy$str(), param1);
    }
    private static final String createdSessionBeanProxy = "WELD-000007: Created session bean proxy for {0}";
    protected String createdSessionBeanProxy$str() {
        return createdSessionBeanProxy;
    }
    @Override
    public final void callProxiedMethod(final Object param1, final Object param2, final Object param3, final Object param4) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, callProxiedMethod$str(), param1, param2, param3, param4);
    }
    private static final String callProxiedMethod = "WELD-000008: Called {0} on {1} with parameters {2} which returned {3}";
    protected String callProxiedMethod$str() {
        return callProxiedMethod;
    }
    private static final String dynamicLookupOfBuiltInNotAllowed = "WELD-000009: Dynamic lookup of {0} is not supported";
    protected String dynamicLookupOfBuiltInNotAllowed$str() {
        return dynamicLookupOfBuiltInNotAllowed;
    }
    @Override
    public final IllegalArgumentException dynamicLookupOfBuiltInNotAllowed(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(dynamicLookupOfBuiltInNotAllowed$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void qualifiersUsed(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, qualifiersUsed$str(), param1, param2);
    }
    private static final String qualifiersUsed = "WELD-000010: Using qualifiers {0} for {1}";
    protected String qualifiersUsed$str() {
        return qualifiersUsed;
    }
    @Override
    public final void creatingBean(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, creatingBean$str(), param1);
    }
    private static final String creatingBean = "WELD-000012: Building bean metadata for {0}";
    protected String creatingBean$str() {
        return creatingBean;
    }
    @Override
    public final void usingName(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, usingName$str(), param1, param2);
    }
    private static final String usingName = "WELD-000014: Using name {0} for {1}";
    protected String usingName$str() {
        return usingName;
    }
    @Override
    public final void usingScope(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, usingScope$str(), param1, param2);
    }
    private static final String usingScope = "WELD-000016: Using scope {0} for {1}";
    protected String usingScope$str() {
        return usingScope;
    }
    @Override
    public final void circularCall(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, circularCall$str(), param1, param2);
    }
    private static final String circularCall = "WELD-000018: Executing producer field or method {0} on incomplete declaring bean {1} due to circular injection";
    protected String circularCall$str() {
        return circularCall;
    }
    @Override
    public final void errorDestroying(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.ERROR, null, errorDestroying$str(), param1, param2);
    }
    private static final String errorDestroying = "WELD-000019: Error destroying an instance {0} of {1}";
    protected String errorDestroying$str() {
        return errorDestroying;
    }
    private static final String typeParameterMustBeConcrete = "WELD-000023: Type parameter must be a concrete type:  {0}";
    protected String typeParameterMustBeConcrete$str() {
        return typeParameterMustBeConcrete;
    }
    @Override
    public final String typeParameterMustBeConcrete(final Object param1) {
        return java.text.MessageFormat.format(typeParameterMustBeConcrete$str(), param1);
    }
    private static final String invalidResourceProducerField = "WELD-000025: Tried to create an EEResourceProducerField, but no @Resource, @PersistenceContext, @PersistenceUnit, @WebServiceRef or @EJB is present: {0}";
    protected String invalidResourceProducerField$str() {
        return invalidResourceProducerField;
    }
    @Override
    public final IllegalStateException invalidResourceProducerField(final Object param1) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(invalidResourceProducerField$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String securityServicesNotAvailable = "WELD-000026: Security Services not available - unable to obtain the Principal";
    protected String securityServicesNotAvailable$str() {
        return securityServicesNotAvailable;
    }
    @Override
    public final IllegalStateException securityServicesNotAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(securityServicesNotAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionServicesNotAvailable = "WELD-000027: Transaction Services not available - unable to obtain the UserTransaction";
    protected String transactionServicesNotAvailable$str() {
        return transactionServicesNotAvailable;
    }
    @Override
    public final IllegalStateException transactionServicesNotAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(transactionServicesNotAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interceptionModelNull = "WELD-000028: Interception model must not be null";
    protected String interceptionModelNull$str() {
        return interceptionModelNull;
    }
    @Override
    public final IllegalArgumentException interceptionModelNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(interceptionModelNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interceptionTypeNull = "WELD-000029: InterceptionType must not be null";
    protected String interceptionTypeNull$str() {
        return interceptionTypeNull;
    }
    @Override
    public final IllegalArgumentException interceptionTypeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(interceptionTypeNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String methodNull = "WELD-000030: Method must not be null";
    protected String methodNull$str() {
        return methodNull;
    }
    @Override
    public final IllegalArgumentException methodNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(methodNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interceptionTypeLifecycle = "WELD-000031: InterceptionType must not be lifecycle, but it is {0}";
    protected String interceptionTypeLifecycle$str() {
        return interceptionTypeLifecycle;
    }
    @Override
    public final IllegalArgumentException interceptionTypeLifecycle(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(interceptionTypeLifecycle$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interceptionTypeNotLifecycle = "WELD-000032: InterceptionType must be lifecycle, but it is {0}";
    protected String interceptionTypeNotLifecycle$str() {
        return interceptionTypeNotLifecycle;
    }
    @Override
    public final IllegalArgumentException interceptionTypeNotLifecycle(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(interceptionTypeNotLifecycle$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String proxyInstantiationFailed = "WELD-000033: Could not instantiate client proxy for {0}";
    protected String proxyInstantiationFailed$str() {
        return proxyInstantiationFailed;
    }
    @Override
    public final String proxyInstantiationFailed(final Object param1) {
        return java.text.MessageFormat.format(proxyInstantiationFailed$str(), param1);
    }
    private static final String proxyInstantiationBeanAccessFailed = "WELD-000034: Could not access bean correctly when creating client proxy for {0}";
    protected String proxyInstantiationBeanAccessFailed$str() {
        return proxyInstantiationBeanAccessFailed;
    }
    @Override
    public final String proxyInstantiationBeanAccessFailed(final Object param1) {
        return java.text.MessageFormat.format(proxyInstantiationBeanAccessFailed$str(), param1);
    }
    private static final String beanIdCreationFailed = "WELD-000035: There was an error creating an id for {0}";
    protected String beanIdCreationFailed$str() {
        return beanIdCreationFailed;
    }
    @Override
    public final DefinitionException beanIdCreationFailed(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(beanIdCreationFailed$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedUnwrappedCustomDecorator = "WELD-000036: Unexpected unwrapped custom decorator instance: {0}";
    protected String unexpectedUnwrappedCustomDecorator$str() {
        return unexpectedUnwrappedCustomDecorator;
    }
    @Override
    public final IllegalStateException unexpectedUnwrappedCustomDecorator(final Object param1) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(unexpectedUnwrappedCustomDecorator$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRemoveMethodInvocation = "WELD-000037: Cannot call EJB remove method directly on non-dependent scoped bean {0}";
    protected String invalidRemoveMethodInvocation$str() {
        return invalidRemoveMethodInvocation;
    }
    @Override
    public final UnsupportedOperationException invalidRemoveMethodInvocation(final Object param1) {
        final UnsupportedOperationException result = new UnsupportedOperationException(java.text.MessageFormat.format(invalidRemoveMethodInvocation$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String delegateNotOnDecorator = "WELD-000038: A bean class that is not a decorator has an injection point annotated @Delegate\n  at injection point {0}\n\tat {1}\n  StackTrace:";
    protected String delegateNotOnDecorator$str() {
        return delegateNotOnDecorator;
    }
    @Override
    public final DefinitionException delegateNotOnDecorator(final Object ip, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(delegateNotOnDecorator$str(), ip, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String typedClassNotInHierarchy = "WELD-000039: @Typed class {0} not present in the set of bean types of {1} [{2}]";
    protected String typedClassNotInHierarchy$str() {
        return typedClassNotInHierarchy;
    }
    @Override
    public final DefinitionException typedClassNotInHierarchy(final Object param1, final Object param2, final Object types) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(typedClassNotInHierarchy$str(), param1, param2, types));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleScopesFoundFromStereotypes = "WELD-000040: All stereotypes must specify the same scope or the bean must declare a scope - declared on {0}, declared stereotypes [{1}], possible scopes {2}{3}";
    protected String multipleScopesFoundFromStereotypes$str() {
        return multipleScopesFoundFromStereotypes;
    }
    @Override
    public final DefinitionException multipleScopesFoundFromStereotypes(final Object declaredOn, final Object stereotypes, final Object possibleScopes, final String stack) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(multipleScopesFoundFromStereotypes$str(), declaredOn, stereotypes, possibleScopes, stack));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nameNotAllowedOnSpecialization = "WELD-000041: Specializing bean may not declare a bean name if it is declared by specialized bean\n  specializing: {0}\n  specialized: {1}";
    protected String nameNotAllowedOnSpecialization$str() {
        return nameNotAllowedOnSpecialization;
    }
    @Override
    public final DefinitionException nameNotAllowedOnSpecialization(final Object specializing, final Object specialized) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(nameNotAllowedOnSpecialization$str(), specializing, specialized));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonContainerDecorator = "WELD-000042: Cannot operate on non container provided decorator {0}";
    protected String nonContainerDecorator$str() {
        return nonContainerDecorator;
    }
    @Override
    public final IllegalStateException nonContainerDecorator(final Object param1) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(nonContainerDecorator$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanNotEeResourceProducer = "WELD-000043: The following bean is not an EE resource producer:  {0}";
    protected String beanNotEeResourceProducer$str() {
        return beanNotEeResourceProducer;
    }
    @Override
    public final IllegalStateException beanNotEeResourceProducer(final Object param1) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(beanNotEeResourceProducer$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullInstance = "WELD-000044: Unable to obtain instance from {0}";
    protected String nullInstance$str() {
        return nullInstance;
    }
    @Override
    public final NullInstanceException nullInstance(final Object param1) {
        final NullInstanceException result = new NullInstanceException(java.text.MessageFormat.format(nullInstance$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serializationProxyRequired = "WELD-000045: Unable to deserialize object - serialization proxy is required";
    protected String serializationProxyRequired$str() {
        return serializationProxyRequired;
    }
    @Override
    public final InvalidObjectException serializationProxyRequired() {
        final InvalidObjectException result = new InvalidObjectException(String.format(serializationProxyRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onlyOneScopeAllowed = "WELD-000046: At most one scope may be specified on {0}";
    protected String onlyOneScopeAllowed$str() {
        return onlyOneScopeAllowed;
    }
    @Override
    public final DefinitionException onlyOneScopeAllowed(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(onlyOneScopeAllowed$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String specializingBeanMustExtendABean = "WELD-000047: Specializing bean must extend another bean:  {0}";
    protected String specializingBeanMustExtendABean$str() {
        return specializingBeanMustExtendABean;
    }
    @Override
    public final DefinitionException specializingBeanMustExtendABean(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(specializingBeanMustExtendABean$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingInterceptorBindings = "WELD-000048: Conflicting interceptor bindings found on {0}";
    protected String conflictingInterceptorBindings$str() {
        return conflictingInterceptorBindings;
    }
    @Override
    public final String conflictingInterceptorBindings(final Object param1) {
        return java.text.MessageFormat.format(conflictingInterceptorBindings$str(), param1);
    }
    private static final String invocationError = "WELD-000049: Unable to invoke {0} on {1}";
    protected String invocationError$str() {
        return invocationError;
    }
    @Override
    public final WeldException invocationError(final Object param1, final Object param2, final Throwable cause) {
        final WeldException result = new WeldException(java.text.MessageFormat.format(invocationError$str(), param1, param2), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String producerCastError = "WELD-000050: Cannot cast producer type {0} to bean type {1}";
    protected String producerCastError$str() {
        return producerCastError;
    }
    @Override
    public final WeldException producerCastError(final Object param1, final Object param2, final Throwable cause) {
        final WeldException result = new WeldException(java.text.MessageFormat.format(producerCastError$str(), param1, param2), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullNotAllowedFromProducer = "WELD-000052: Cannot return null from a non-dependent producer method: {0}\n\tat {1}\n  StackTrace:";
    protected String nullNotAllowedFromProducer$str() {
        return nullNotAllowedFromProducer;
    }
    @Override
    public final IllegalProductException nullNotAllowedFromProducer(final Object param1, final Object stackElement) {
        final IllegalProductException result = new IllegalProductException(java.text.MessageFormat.format(nullNotAllowedFromProducer$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonSerializableProductError = "WELD-000053: Producers cannot declare passivating scope and return a non-serializable class: {0}\n\tat {1}\n  StackTrace:";
    protected String nonSerializableProductError$str() {
        return nonSerializableProductError;
    }
    @Override
    public final IllegalProductException nonSerializableProductError(final Object param1, final Object stackElement) {
        final IllegalProductException result = new IllegalProductException(java.text.MessageFormat.format(nonSerializableProductError$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unserializableProductInjectionError = "WELD-000054: Producers cannot produce unserializable instances for injection into an injection point that requires a passivation capable dependency\n  Producer:  {0}\n\tat {1}\n  Injection Point:  {2}\n\tat {3}\n  StackTrace:";
    protected String unserializableProductInjectionError$str() {
        return unserializableProductInjectionError;
    }
    @Override
    public final IllegalProductException unserializableProductInjectionError(final Object producer, final Object producerStackElement, final Object ip, final Object ipStackElement) {
        final IllegalProductException result = new IllegalProductException(java.text.MessageFormat.format(unserializableProductInjectionError$str(), producer, producerStackElement, ip, ipStackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDelegateInjectionPoint = "WELD-000059: No delegate injection point defined for {0}";
    protected String noDelegateInjectionPoint$str() {
        return noDelegateInjectionPoint;
    }
    @Override
    public final DefinitionException noDelegateInjectionPoint(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(noDelegateInjectionPoint$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooManyDelegateInjectionPoints = "WELD-000060: Too many delegate injection points defined for {0}";
    protected String tooManyDelegateInjectionPoints$str() {
        return tooManyDelegateInjectionPoints;
    }
    @Override
    public final DefinitionException tooManyDelegateInjectionPoints(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(tooManyDelegateInjectionPoints$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String delegateMustSupportEveryDecoratedType = "WELD-000061: The delegate type does not extend or implement the decorated type. \n  Decorated type: {0}\n  Decorator: {1}";
    protected String delegateMustSupportEveryDecoratedType$str() {
        return delegateMustSupportEveryDecoratedType;
    }
    @Override
    public final DefinitionException delegateMustSupportEveryDecoratedType(final Object decoratedType, final Object decorator) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(delegateMustSupportEveryDecoratedType$str(), decoratedType, decorator));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToProcessDecoratedType = "WELD-000064: Unable to process decorated type: {0}";
    protected String unableToProcessDecoratedType$str() {
        return unableToProcessDecoratedType;
    }
    @Override
    public final IllegalStateException unableToProcessDecoratedType(final Object decoratedType) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(unableToProcessDecoratedType$str(), decoratedType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleDisposeParams = "WELD-000066: {0} has more than one @Dispose parameter \n\tat {1}\n  StackTrace:";
    protected String multipleDisposeParams$str() {
        return multipleDisposeParams;
    }
    @Override
    public final DefinitionException multipleDisposeParams(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(multipleDisposeParams$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String inconsistentAnnotationsOnMethod = "WELD-000067: {0} is not allowed on same method as {1}, see {2}\n\tat {3}\n  StackTrace:";
    protected String inconsistentAnnotationsOnMethod$str() {
        return inconsistentAnnotationsOnMethod;
    }
    @Override
    public final DefinitionException inconsistentAnnotationsOnMethod(final Object param1, final Object param2, final Object param3, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(inconsistentAnnotationsOnMethod$str(), param1, param2, param3, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String methodNotBusinessMethod = "WELD-000068: {0} method {1} is not a business method of {2}\n\tat {3}\n  StackTrace:";
    protected String methodNotBusinessMethod$str() {
        return methodNotBusinessMethod;
    }
    @Override
    public final DefinitionException methodNotBusinessMethod(final Object methodType, final Object param1, final Object param2, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(methodNotBusinessMethod$str(), methodType, param1, param2, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String simpleBeanAsNonStaticInnerClassNotAllowed = "WELD-000070: Simple bean {0} cannot be a non-static inner class";
    protected String simpleBeanAsNonStaticInnerClassNotAllowed$str() {
        return simpleBeanAsNonStaticInnerClassNotAllowed;
    }
    @Override
    public final DefinitionException simpleBeanAsNonStaticInnerClassNotAllowed(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(simpleBeanAsNonStaticInnerClassNotAllowed$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String managedBeanWithParameterizedBeanClassMustBeDependent = "WELD-000071: Managed bean with a parameterized bean class must be @Dependent: {0}";
    protected String managedBeanWithParameterizedBeanClassMustBeDependent$str() {
        return managedBeanWithParameterizedBeanClassMustBeDependent;
    }
    @Override
    public final DefinitionException managedBeanWithParameterizedBeanClassMustBeDependent(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(managedBeanWithParameterizedBeanClassMustBeDependent$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passivatingBeanNeedsSerializableImpl = "WELD-000072: Bean declaring a passivating scope must be passivation capable.  Bean:  {0}";
    protected String passivatingBeanNeedsSerializableImpl$str() {
        return passivatingBeanNeedsSerializableImpl;
    }
    @Override
    public final DeploymentException passivatingBeanNeedsSerializableImpl(final Object param1) {
        final DeploymentException result = new DeploymentException(java.text.MessageFormat.format(passivatingBeanNeedsSerializableImpl$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String finalBeanClassWithDecoratorsNotAllowed = "WELD-000073: Bean class which has decorators cannot be declared final:  {0}";
    protected String finalBeanClassWithDecoratorsNotAllowed$str() {
        return finalBeanClassWithDecoratorsNotAllowed;
    }
    @Override
    public final DeploymentException finalBeanClassWithDecoratorsNotAllowed(final Object param1) {
        final DeploymentException result = new DeploymentException(java.text.MessageFormat.format(finalBeanClassWithDecoratorsNotAllowed$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String publicFieldOnNormalScopedBeanNotAllowed = "WELD-000075: Normal scoped managed bean implementation class has a public field:  {0}";
    protected String publicFieldOnNormalScopedBeanNotAllowed$str() {
        return publicFieldOnNormalScopedBeanNotAllowed;
    }
    @Override
    public final DefinitionException publicFieldOnNormalScopedBeanNotAllowed(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(publicFieldOnNormalScopedBeanNotAllowed$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parameterAnnotationNotAllowedOnConstructor = "WELD-000076: Bean constructor must not have a parameter annotated with {0}: {1}\n\tat {2}\n  StackTrace:";
    protected String parameterAnnotationNotAllowedOnConstructor$str() {
        return parameterAnnotationNotAllowedOnConstructor;
    }
    @Override
    public final DefinitionException parameterAnnotationNotAllowedOnConstructor(final Object param1, final Object param2, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(parameterAnnotationNotAllowedOnConstructor$str(), param1, param2, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleDisposalMethods = "WELD-000077: Cannot declare multiple disposal methods for this producer method.\n\nProducer method:  {0}\nDisposal methods:  {1}";
    protected String multipleDisposalMethods$str() {
        return multipleDisposalMethods;
    }
    @Override
    public final DefinitionException multipleDisposalMethods(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(multipleDisposalMethods$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String producerMethodNotSpecializing = "WELD-000078: Specialized producer method does not override another producer method: {0}\n\tat {1}\n  StackTrace:";
    protected String producerMethodNotSpecializing$str() {
        return producerMethodNotSpecializing;
    }
    @Override
    public final DefinitionException producerMethodNotSpecializing(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(producerMethodNotSpecializing$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sessionBeanProxyInstantiationFailed = "WELD-000079: Could not instantiate a proxy for a session bean:  {0}\n  Proxy: {1}";
    protected String sessionBeanProxyInstantiationFailed$str() {
        return sessionBeanProxyInstantiationFailed;
    }
    @Override
    public final CreationException sessionBeanProxyInstantiationFailed(final Object sessionBean, final Object proxyClass, final Throwable cause) {
        final CreationException result = new CreationException(java.text.MessageFormat.format(sessionBeanProxyInstantiationFailed$str(), sessionBean, proxyClass), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbCannotBeInterceptor = "WELD-000080: Enterprise beans cannot be interceptors:  {0}";
    protected String ejbCannotBeInterceptor$str() {
        return ejbCannotBeInterceptor;
    }
    @Override
    public final DefinitionException ejbCannotBeInterceptor(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(ejbCannotBeInterceptor$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbCannotBeDecorator = "WELD-000081: Enterprise beans cannot be decorators:  {0}";
    protected String ejbCannotBeDecorator$str() {
        return ejbCannotBeDecorator;
    }
    @Override
    public final DefinitionException ejbCannotBeDecorator(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(ejbCannotBeDecorator$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String scopeNotAllowedOnStatelessSessionBean = "WELD-000082: Scope {0} is not allowed on stateless session beans for {1}. Only @Dependent is allowed.";
    protected String scopeNotAllowedOnStatelessSessionBean$str() {
        return scopeNotAllowedOnStatelessSessionBean;
    }
    @Override
    public final DefinitionException scopeNotAllowedOnStatelessSessionBean(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(scopeNotAllowedOnStatelessSessionBean$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String scopeNotAllowedOnSingletonBean = "WELD-000083: Scope {0} is not allowed on singleton session beans for {1}. Only @Dependent and @ApplicationScoped is allowed.";
    protected String scopeNotAllowedOnSingletonBean$str() {
        return scopeNotAllowedOnSingletonBean;
    }
    @Override
    public final DefinitionException scopeNotAllowedOnSingletonBean(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(scopeNotAllowedOnSingletonBean$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String specializingEnterpriseBeanMustExtendAnEnterpriseBean = "WELD-000084: Specializing enterprise bean must extend another enterprise bean:  {0}";
    protected String specializingEnterpriseBeanMustExtendAnEnterpriseBean$str() {
        return specializingEnterpriseBeanMustExtendAnEnterpriseBean;
    }
    @Override
    public final DefinitionException specializingEnterpriseBeanMustExtendAnEnterpriseBean(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(specializingEnterpriseBeanMustExtendAnEnterpriseBean$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotDestroyNullBean = "WELD-000085: Cannot destroy null instance of {0}";
    protected String cannotDestroyNullBean$str() {
        return cannotDestroyNullBean;
    }
    @Override
    public final IllegalArgumentException cannotDestroyNullBean(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(cannotDestroyNullBean$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotDestroyEnterpriseBeanNotCreated = "WELD-000086: Cannot destroy session bean instance not created by the container:  {0}";
    protected String cannotDestroyEnterpriseBeanNotCreated$str() {
        return cannotDestroyEnterpriseBeanNotCreated;
    }
    @Override
    public final IllegalArgumentException cannotDestroyEnterpriseBeanNotCreated(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(cannotDestroyEnterpriseBeanNotCreated$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String messageDrivenBeansCannotBeManaged = "WELD-000087: Message driven beans cannot be Managed Beans:  {0}";
    protected String messageDrivenBeansCannotBeManaged$str() {
        return messageDrivenBeansCannotBeManaged;
    }
    @Override
    public final DefinitionException messageDrivenBeansCannotBeManaged(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(messageDrivenBeansCannotBeManaged$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String observerMethodMustBeStaticOrBusiness = "WELD-000088: Observer method must be static or local business method:  {0}\n\tat {1}\n  StackTrace:";
    protected String observerMethodMustBeStaticOrBusiness$str() {
        return observerMethodMustBeStaticOrBusiness;
    }
    @Override
    public final DefinitionException observerMethodMustBeStaticOrBusiness(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(observerMethodMustBeStaticOrBusiness$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooManyEjbsForClass = "WELD-000089: Unable to determine EJB for {0}, multiple EJBs with that class:  {1}";
    protected String tooManyEjbsForClass$str() {
        return tooManyEjbsForClass;
    }
    @Override
    public final IllegalStateException tooManyEjbsForClass(final Object param1, final Object param2) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(tooManyEjbsForClass$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String abstractMethodMustMatchDecoratedType = "WELD-000090: A decorator has an abstract method that is not declared by any decorated type\n  Method: {0}\n\tat {1}\n  StackTrace:";
    protected String abstractMethodMustMatchDecoratedType$str() {
        return abstractMethodMustMatchDecoratedType;
    }
    @Override
    public final DefinitionException abstractMethodMustMatchDecoratedType(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(abstractMethodMustMatchDecoratedType$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String injectedFieldCannotBeProducer = "WELD-000094: Injected field {0} cannot be annotated @Produces on {1}";
    protected String injectedFieldCannotBeProducer$str() {
        return injectedFieldCannotBeProducer;
    }
    @Override
    public final DefinitionException injectedFieldCannotBeProducer(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(injectedFieldCannotBeProducer$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String genericSessionBeanMustBeDependent = "WELD-000095: Session bean with generic class {0} must be @Dependent scope";
    protected String genericSessionBeanMustBeDependent$str() {
        return genericSessionBeanMustBeDependent;
    }
    @Override
    public final DefinitionException genericSessionBeanMustBeDependent(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(genericSessionBeanMustBeDependent$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String producerFieldOnSessionBeanMustBeStatic = "WELD-000096: Producer fields on session beans must be static. Field {0} declared on {1}";
    protected String producerFieldOnSessionBeanMustBeStatic$str() {
        return producerFieldOnSessionBeanMustBeStatic;
    }
    @Override
    public final DefinitionException producerFieldOnSessionBeanMustBeStatic(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(producerFieldOnSessionBeanMustBeStatic$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String producerMethodWithTypeVariableReturnTypeMustBeDependent = "WELD-000097: A producer method with a parameterized return type with a type variable must be declared @Dependent scoped: \n  {0}\n\tat {1}\n  StackTrace:";
    protected String producerMethodWithTypeVariableReturnTypeMustBeDependent$str() {
        return producerMethodWithTypeVariableReturnTypeMustBeDependent;
    }
    @Override
    public final DefinitionException producerMethodWithTypeVariableReturnTypeMustBeDependent(final Object param1, final String stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(producerMethodWithTypeVariableReturnTypeMustBeDependent$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String producerMethodCannotHaveAWildcardReturnType = "WELD-000098: A producer method return type may not contain a wildcard: \n  {0}\n\tat {1}\n  StackTrace:";
    protected String producerMethodCannotHaveAWildcardReturnType$str() {
        return producerMethodCannotHaveAWildcardReturnType;
    }
    @Override
    public final DefinitionException producerMethodCannotHaveAWildcardReturnType(final Object param1, final String stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(producerMethodCannotHaveAWildcardReturnType$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoadClass = "WELD-000099: Cannot load class {0} during deserialization of proxy";
    protected String cannotLoadClass$str() {
        return cannotLoadClass;
    }
    @Override
    public final WeldException cannotLoadClass(final Object param1, final Throwable cause) {
        final WeldException result = new WeldException(java.text.MessageFormat.format(cannotLoadClass$str(), param1), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String proxyDeserializationFailure = "WELD-001500: Failed to deserialize proxy object with beanId {0}";
    protected String proxyDeserializationFailure$str() {
        return proxyDeserializationFailure;
    }
    @Override
    public final WeldException proxyDeserializationFailure(final Object param1) {
        final WeldException result = new WeldException(java.text.MessageFormat.format(proxyDeserializationFailure$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanInstanceNotSetOnProxy = "WELD-001501: Method call requires a BeanInstance which has not been set for this proxy {0}";
    protected String beanInstanceNotSetOnProxy$str() {
        return beanInstanceNotSetOnProxy;
    }
    @Override
    public final WeldException beanInstanceNotSetOnProxy(final Object param1) {
        final WeldException result = new WeldException(java.text.MessageFormat.format(beanInstanceNotSetOnProxy$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonDependentResourceProducerField = "WELD-001502: Resource producer field [{0}] must be @Dependent scoped";
    protected String nonDependentResourceProducerField$str() {
        return nonDependentResourceProducerField;
    }
    @Override
    public final DefinitionException nonDependentResourceProducerField(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(nonDependentResourceProducerField$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String finalBeanClassWithInterceptorsNotAllowed = "WELD-001503: Bean class which has interceptors cannot be declared final:  {0}";
    protected String finalBeanClassWithInterceptorsNotAllowed$str() {
        return finalBeanClassWithInterceptorsNotAllowed;
    }
    @Override
    public final DeploymentException finalBeanClassWithInterceptorsNotAllowed(final Object param1) {
        final DeploymentException result = new DeploymentException(java.text.MessageFormat.format(finalBeanClassWithInterceptorsNotAllowed$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String finalInterceptedBeanMethodNotAllowed = "WELD-001504: Intercepted bean method {0} (intercepted by {1}) cannot be declared final";
    protected String finalInterceptedBeanMethodNotAllowed$str() {
        return finalInterceptedBeanMethodNotAllowed;
    }
    @Override
    public final DeploymentException finalInterceptedBeanMethodNotAllowed(final Object param1, final Object param2) {
        final DeploymentException result = new DeploymentException(java.text.MessageFormat.format(finalInterceptedBeanMethodNotAllowed$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void finalMethodNotIntercepted(final Object method, final Object interceptor) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, finalMethodNotIntercepted$str(), method, interceptor);
    }
    private static final String finalMethodNotIntercepted = "WELD-001505: Method {0} cannot be intercepted by {1} - will be ignored by interceptors and should never be invoked upon the proxy instance!";
    protected String finalMethodNotIntercepted$str() {
        return finalMethodNotIntercepted;
    }
    @Override
    public final void createdNewClientProxyType(final Object param1, final Object param2, final Object param3) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, createdNewClientProxyType$str(), param1, param2, param3);
    }
    private static final String createdNewClientProxyType = "WELD-001506: Created new client proxy of type {0} for bean {1} with ID {2}";
    protected String createdNewClientProxyType$str() {
        return createdNewClientProxyType;
    }
    @Override
    public final void lookedUpClientProxy(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, lookedUpClientProxy$str(), param1, param2);
    }
    private static final String lookedUpClientProxy = "WELD-001507: Located client proxy of type {0} for bean {1}";
    protected String lookedUpClientProxy$str() {
        return lookedUpClientProxy;
    }
    private static final String injectionTargetCannotBeCreatedForInterface = "WELD-001508: Cannot create an InjectionTarget from {0} as it is an interface";
    protected String injectionTargetCannotBeCreatedForInterface$str() {
        return injectionTargetCannotBeCreatedForInterface;
    }
    @Override
    public final DefinitionException injectionTargetCannotBeCreatedForInterface(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(injectionTargetCannotBeCreatedForInterface$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String proxyHandlerSerializedForNonSerializableBean = "WELD-001510: Non passivation capable bean serialized with ProxyMethodHandler";
    protected String proxyHandlerSerializedForNonSerializableBean$str() {
        return proxyHandlerSerializedForNonSerializableBean;
    }
    @Override
    public final WeldException proxyHandlerSerializedForNonSerializableBean() {
        final WeldException result = new WeldException(String.format(proxyHandlerSerializedForNonSerializableBean$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String specializingBeanMissingSpecializedType = "WELD-001511: Specializing bean {0} does not have bean type {1} of specialized bean {2}";
    protected String specializingBeanMissingSpecializedType$str() {
        return specializingBeanMissingSpecializedType;
    }
    @Override
    public final DefinitionException specializingBeanMissingSpecializedType(final Object param1, final Object param2, final Object param3) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(specializingBeanMissingSpecializedType$str(), param1, param2, param3));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidInjectionPointType = "WELD-001512: {0} cannot be constructed for {1}";
    protected String invalidInjectionPointType$str() {
        return invalidInjectionPointType;
    }
    @Override
    public final IllegalArgumentException invalidInjectionPointType(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(invalidInjectionPointType$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAnnotatedCallable = "WELD-001513: An implementation of AnnotatedCallable must implement either AnnotatedConstructor or AnnotatedMethod, {0}";
    protected String invalidAnnotatedCallable$str() {
        return invalidAnnotatedCallable;
    }
    @Override
    public final IllegalArgumentException invalidAnnotatedCallable(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(invalidAnnotatedCallable$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAnnotatedMember = "WELD-001514: An implementation of AnnotatedMember must implement either AnnotatedConstructor, AnnotatedMethod or AnnotatedField, {0}";
    protected String invalidAnnotatedMember$str() {
        return invalidAnnotatedMember;
    }
    @Override
    public final IllegalArgumentException invalidAnnotatedMember(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(invalidAnnotatedMember$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadMember = "WELD-001515: Unable to load annotated member {0}";
    protected String unableToLoadMember$str() {
        return unableToLoadMember;
    }
    @Override
    public final IllegalStateException unableToLoadMember(final Object param1) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(unableToLoadMember$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String namedResourceProducerField = "WELD-001516: Resource producer field [{0}] must not have an EL name";
    protected String namedResourceProducerField$str() {
        return namedResourceProducerField;
    }
    @Override
    public final DefinitionException namedResourceProducerField(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(namedResourceProducerField$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidResourceProducerType = "WELD-001517: The type of the resource producer field [{0}] does not match the resource type {1}";
    protected String invalidResourceProducerType$str() {
        return invalidResourceProducerType;
    }
    @Override
    public final DefinitionException invalidResourceProducerType(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(invalidResourceProducerType$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String declaringBeanMissing = "WELD-001518: Cannot create Producer implementation. Declaring bean missing for a non-static member {0}";
    protected String declaringBeanMissing$str() {
        return declaringBeanMissing;
    }
    @Override
    public final IllegalArgumentException declaringBeanMissing(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(declaringBeanMissing$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void injectionTargetCreatedForAbstractClass(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, injectionTargetCreatedForAbstractClass$str(), param1);
    }
    private static final String injectionTargetCreatedForAbstractClass = "WELD-001519: An InjectionTarget is created for an abstract {0}. It will not be possible to produce instances of this type!";
    protected String injectionTargetCreatedForAbstractClass$str() {
        return injectionTargetCreatedForAbstractClass;
    }
    private static final String beansWithDifferentBeanNamesCannotBeSpecialized = "WELD-001520: Beans with different bean names {0}, {1} cannot be specialized by a single bean {2}";
    protected String beansWithDifferentBeanNamesCannotBeSpecialized$str() {
        return beansWithDifferentBeanNamesCannotBeSpecialized;
    }
    @Override
    public final DefinitionException beansWithDifferentBeanNamesCannotBeSpecialized(final Object param1, final Object param2, final Object param3) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(beansWithDifferentBeanNamesCannotBeSpecialized$str(), param1, param2, param3));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAnnotatedOfInjectionPoint = "WELD-001521: InjectionPoint.getAnnotated() must return either AnnotatedParameter or AnnotatedField but {0} was returned for {1}";
    protected String invalidAnnotatedOfInjectionPoint$str() {
        return invalidAnnotatedOfInjectionPoint;
    }
    @Override
    public final IllegalArgumentException invalidAnnotatedOfInjectionPoint(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(invalidAnnotatedOfInjectionPoint$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToRestoreInjectionPoint = "WELD-001522: Unable to restore InjectionPoint. No matching InjectionPoint found on {0}";
    protected String unableToRestoreInjectionPoint$str() {
        return unableToRestoreInjectionPoint;
    }
    @Override
    public final IllegalStateException unableToRestoreInjectionPoint(final Object param1) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(unableToRestoreInjectionPoint$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToRestoreInjectionPointMultiple = "WELD-001523: Unable to restore InjectionPoint. Multiple matching InjectionPoints found on {0}:\n  - {1},\n  - {2}";
    protected String unableToRestoreInjectionPointMultiple$str() {
        return unableToRestoreInjectionPointMultiple;
    }
    @Override
    public final IllegalStateException unableToRestoreInjectionPointMultiple(final Object param1, final Object param2, final Object param3) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(unableToRestoreInjectionPointMultiple$str(), param1, param2, param3));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadProxyClass = "WELD-001524: Unable to load proxy class for bean {0} with class {1}";
    protected String unableToLoadProxyClass$str() {
        return unableToLoadProxyClass;
    }
    @Override
    public final WeldException unableToLoadProxyClass(final Object param1, final Object param2, final Throwable cause) {
        final WeldException result = new WeldException(java.text.MessageFormat.format(unableToLoadProxyClass$str(), param1, param2), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String destroyUnsupported = "WELD-001525: Instance.destroy() is not supported. The underlying context {0} does not support destroying of contextual instances";
    protected String destroyUnsupported$str() {
        return destroyUnsupported;
    }
    @Override
    public final UnsupportedOperationException destroyUnsupported(final Object param1) {
        final UnsupportedOperationException result = new UnsupportedOperationException(java.text.MessageFormat.format(destroyUnsupported$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passivatingBeanHasNonPassivationCapableDecorator = "WELD-001526: Managed bean declaring a passivating scope has a non-passivation capable decorator.  Bean:  {0}  Decorator: {1}";
    protected String passivatingBeanHasNonPassivationCapableDecorator$str() {
        return passivatingBeanHasNonPassivationCapableDecorator;
    }
    @Override
    public final DeploymentException passivatingBeanHasNonPassivationCapableDecorator(final Object param1, final Object param2) {
        final DeploymentException result = new DeploymentException(java.text.MessageFormat.format(passivatingBeanHasNonPassivationCapableDecorator$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passivatingBeanHasNonPassivationCapableInterceptor = "WELD-001527: Managed bean declaring a passivating scope has a non-serializable interceptor.  Bean:  {0}  Interceptor: {1}";
    protected String passivatingBeanHasNonPassivationCapableInterceptor$str() {
        return passivatingBeanHasNonPassivationCapableInterceptor;
    }
    @Override
    public final DeploymentException passivatingBeanHasNonPassivationCapableInterceptor(final Object param1, final Object param2) {
        final DeploymentException result = new DeploymentException(java.text.MessageFormat.format(passivatingBeanHasNonPassivationCapableInterceptor$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void injectionTargetCreatedForClassWithoutAppropriateConstructor(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, injectionTargetCreatedForClassWithoutAppropriateConstructor$str(), param1);
    }
    private static final String injectionTargetCreatedForClassWithoutAppropriateConstructor = "WELD-001529: An InjectionTarget is created for a {0} which does not have any appropriate constructor. It will not be possible to produce instances of this type!";
    protected String injectionTargetCreatedForClassWithoutAppropriateConstructor$str() {
        return injectionTargetCreatedForClassWithoutAppropriateConstructor;
    }
    private static final String injectionTargetCannotProduceInstance = "WELD-001530: Cannot produce an instance of {0}.";
    protected String injectionTargetCannotProduceInstance$str() {
        return injectionTargetCannotProduceInstance;
    }
    @Override
    public final CreationException injectionTargetCannotProduceInstance(final Object param1) {
        final CreationException result = new CreationException(java.text.MessageFormat.format(injectionTargetCannotProduceInstance$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String instanceIteratorRemoveUnsupported = "WELD-001531: Instance.iterator().remove() is not supported.";
    protected String instanceIteratorRemoveUnsupported$str() {
        return instanceIteratorRemoveUnsupported;
    }
    @Override
    public final UnsupportedOperationException instanceIteratorRemoveUnsupported() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(instanceIteratorRemoveUnsupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passivationCapableBeanHasNullId = "WELD-001532: A passivation capable bean cannot have a null id: {0}";
    protected String passivationCapableBeanHasNullId$str() {
        return passivationCapableBeanHasNullId;
    }
    @Override
    public final IllegalArgumentException passivationCapableBeanHasNullId(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(passivationCapableBeanHasNullId$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void injectionTargetCreatedForNonStaticInnerClass(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, injectionTargetCreatedForNonStaticInnerClass$str(), param1);
    }
    private static final String injectionTargetCreatedForNonStaticInnerClass = "WELD-001533: An InjectionTarget is created for a non-static inner {0}. It will not be possible to produce instances of this type!";
    protected String injectionTargetCreatedForNonStaticInnerClass$str() {
        return injectionTargetCreatedForNonStaticInnerClass;
    }
    private static final String decoratedHasNoNoargsConstructor = "WELD-001534: Bean class which has decorators must have a public constructor without parameters: {0}";
    protected String decoratedHasNoNoargsConstructor$str() {
        return decoratedHasNoNoargsConstructor;
    }
    @Override
    public final DeploymentException decoratedHasNoNoargsConstructor(final Object param1) {
        final DeploymentException result = new DeploymentException(java.text.MessageFormat.format(decoratedHasNoNoargsConstructor$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String decoratedNoargsConstructorIsPrivate = "WELD-001535: Constructor without parameters cannot be private in bean class which has decorators: {0}\n\tat {1}\n  StackTrace:";
    protected String decoratedNoargsConstructorIsPrivate$str() {
        return decoratedNoargsConstructorIsPrivate;
    }
    @Override
    public final DeploymentException decoratedNoargsConstructorIsPrivate(final Object param1, final Object stackElement) {
        final DeploymentException result = new DeploymentException(java.text.MessageFormat.format(decoratedNoargsConstructorIsPrivate$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void foundInjectableConstructors(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, foundInjectableConstructors$str(), param1, param2);
    }
    private static final String foundInjectableConstructors = "WELD-001536: Found {0} constructors annotated with @Inject for {1}";
    protected String foundInjectableConstructors$str() {
        return foundInjectableConstructors;
    }
    private static final String injectionTargetCreatedForClassWithoutAppropriateConstructorException = "WELD-001537: An InjectionTarget is created for a {0} which does not have any appropriate constructor.";
    protected String injectionTargetCreatedForClassWithoutAppropriateConstructorException$str() {
        return injectionTargetCreatedForClassWithoutAppropriateConstructorException;
    }
    @Override
    public final DefinitionException injectionTargetCreatedForClassWithoutAppropriateConstructorException(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(injectionTargetCreatedForClassWithoutAppropriateConstructorException$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void createdContextInstance(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, createdContextInstance$str(), param1, param2);
    }
    private static final String createdContextInstance = "WELD-001538: Created context instance for bean {0} identified as {1}";
    protected String createdContextInstance$str() {
        return createdContextInstance;
    }
    @Override
    public final void createdMethodHandlerInitializerForDecoratorProxy(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, createdMethodHandlerInitializerForDecoratorProxy$str(), param1);
    }
    private static final String createdMethodHandlerInitializerForDecoratorProxy = "WELD-001539: Created MH initializer body for decorator proxy: {0}";
    protected String createdMethodHandlerInitializerForDecoratorProxy$str() {
        return createdMethodHandlerInitializerForDecoratorProxy;
    }
    @Override
    public final void addingMethodToEnterpriseProxy(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, addingMethodToEnterpriseProxy$str(), param1);
    }
    private static final String addingMethodToEnterpriseProxy = "WELD-001540: Adding method to enterprise proxy: {0}";
    protected String addingMethodToEnterpriseProxy$str() {
        return addingMethodToEnterpriseProxy;
    }
    @Override
    public final void addingMethodToProxy(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, addingMethodToProxy$str(), param1);
    }
    private static final String addingMethodToProxy = "WELD-001541: Adding method to proxy: {0}";
    protected String addingMethodToProxy$str() {
        return addingMethodToProxy;
    }
    @Override
    public final void generatingProxyClass(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, generatingProxyClass$str(), param1);
    }
    private static final String generatingProxyClass = "WELD-001542: Retrieving/generating proxy class {0}";
    protected String generatingProxyClass$str() {
        return generatingProxyClass;
    }
    @Override
    public final void createdProxyClass(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, createdProxyClass$str(), param1, param2);
    }
    private static final String createdProxyClass = "WELD-001543: Created Proxy class of type {0} supporting interfaces {1}";
    protected String createdProxyClass$str() {
        return createdProxyClass;
    }
    @Override
    public final void methodHandlerProcessingReturningBeanInstance(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, methodHandlerProcessingReturningBeanInstance$str(), param1);
    }
    private static final String methodHandlerProcessingReturningBeanInstance = "WELD-001544: MethodHandler processing returning bean instance for {0}";
    protected String methodHandlerProcessingReturningBeanInstance$str() {
        return methodHandlerProcessingReturningBeanInstance;
    }
    @Override
    public final void methodHandlerProcessingCall(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, methodHandlerProcessingCall$str(), param1, param2);
    }
    private static final String methodHandlerProcessingCall = "WELD-001545: MethodHandler processing call to {0} for {1}";
    protected String methodHandlerProcessingCall$str() {
        return methodHandlerProcessingCall;
    }
    @Override
    public final void settingNewMethodHandler(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, settingNewMethodHandler$str(), param1, param2);
    }
    private static final String settingNewMethodHandler = "WELD-001546: Setting new MethodHandler with bean instance for {0} on {1}";
    protected String settingNewMethodHandler$str() {
        return settingNewMethodHandler;
    }
    @Override
    public final void invokingInterceptorChain(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, invokingInterceptorChain$str(), param1, param2);
    }
    private static final String invokingInterceptorChain = "WELD-001547: Invoking interceptor chain for method {0} on {1}";
    protected String invokingInterceptorChain$str() {
        return invokingInterceptorChain;
    }
    @Override
    public final void invokingMethodDirectly(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, invokingMethodDirectly$str(), param1, param2);
    }
    private static final String invokingMethodDirectly = "WELD-001548: Invoking method {0} directly on {1}";
    protected String invokingMethodDirectly$str() {
        return invokingMethodDirectly;
    }
    private static final String unableToDetermineParentCreationalContext = "WELD-001549: Unable to determine parent creational context of {0}";
    protected String unableToDetermineParentCreationalContext$str() {
        return unableToDetermineParentCreationalContext;
    }
    @Override
    public final IllegalArgumentException unableToDetermineParentCreationalContext(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(unableToDetermineParentCreationalContext$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String producerFieldWithTypeVariableBeanTypeMustBeDependent = "WELD-001550: A producer field with a parameterized type with a type variable must be declared @Dependent scoped: \n  {0}\n\tat {1}\n  StackTrace:";
    protected String producerFieldWithTypeVariableBeanTypeMustBeDependent$str() {
        return producerFieldWithTypeVariableBeanTypeMustBeDependent;
    }
    @Override
    public final DefinitionException producerFieldWithTypeVariableBeanTypeMustBeDependent(final Object param1, final String stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(producerFieldWithTypeVariableBeanTypeMustBeDependent$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String producerFieldCannotHaveAWildcardBeanType = "WELD-001551: A producer field type may not contain a wildcard: \n  {0}\n\tat {1}\n  StackTrace:";
    protected String producerFieldCannotHaveAWildcardBeanType$str() {
        return producerFieldCannotHaveAWildcardBeanType;
    }
    @Override
    public final DefinitionException producerFieldCannotHaveAWildcardBeanType(final Object param1, final String stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(producerFieldCannotHaveAWildcardBeanType$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void extensionWithNonStaticPublicField(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, extensionWithNonStaticPublicField$str(), param1, param2);
    }
    private static final String extensionWithNonStaticPublicField = "WELD-001552: An extension ({0}) has a non-static public field ({1}).";
    protected String extensionWithNonStaticPublicField$str() {
        return extensionWithNonStaticPublicField;
    }
    @Override
    public final void activatedSessionBeanProxy(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, activatedSessionBeanProxy$str(), param1);
    }
    private static final String activatedSessionBeanProxy = "WELD-001553: Proxy activated after passivation for {0}";
    protected String activatedSessionBeanProxy$str() {
        return activatedSessionBeanProxy;
    }
    private static final String beanMethodReturnsNull = "WELD-001554: Bean.{0}() returned null for {1}";
    protected String beanMethodReturnsNull$str() {
        return beanMethodReturnsNull;
    }
    @Override
    public final DefinitionException beanMethodReturnsNull(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(beanMethodReturnsNull$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String decoratorMethodReturnsNull = "WELD-001555: Decorator.{0}() returned null for {1}";
    protected String decoratorMethodReturnsNull$str() {
        return decoratorMethodReturnsNull;
    }
    @Override
    public final DefinitionException decoratorMethodReturnsNull(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(decoratorMethodReturnsNull$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String specializingManagedBeanCanExtendOnlyManagedBeans = "WELD-001556: Specializing {0} cannot specialize a non-managed bean {1}";
    protected String specializingManagedBeanCanExtendOnlyManagedBeans$str() {
        return specializingManagedBeanCanExtendOnlyManagedBeans;
    }
    @Override
    public final DefinitionException specializingManagedBeanCanExtendOnlyManagedBeans(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(specializingManagedBeanCanExtendOnlyManagedBeans$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void beanCannotBeDumped(final Object param1, final Throwable cause) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, cause, beanCannotBeDumped$str(), param1);
    }
    private static final String beanCannotBeDumped = "WELD-001557: Unable to dump the proxy class file for {0}";
    protected String beanCannotBeDumped$str() {
        return beanCannotBeDumped;
    }
    @Override
    public final void directoryCannotBeCreated(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, directoryCannotBeCreated$str(), param1);
    }
    private static final String directoryCannotBeCreated = "WELD-001558: Unable to create directory {0} to dump the proxy classes.";
    protected String directoryCannotBeCreated$str() {
        return directoryCannotBeCreated;
    }
    private static final String beanBuilderInvalidCreateCallback = "WELD-001559: Bean builder {0} does not define a create lifecycle callback.";
    protected String beanBuilderInvalidCreateCallback$str() {
        return beanBuilderInvalidCreateCallback;
    }
    @Override
    public final DefinitionException beanBuilderInvalidCreateCallback(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(beanBuilderInvalidCreateCallback$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanBuilderInvalidDestroyCallback = "WELD-001560: Bean builder {0} does not define a destroy lifecycle callback.";
    protected String beanBuilderInvalidDestroyCallback$str() {
        return beanBuilderInvalidDestroyCallback;
    }
    @Override
    public final DefinitionException beanBuilderInvalidDestroyCallback(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(beanBuilderInvalidDestroyCallback$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanBuilderInvalidBeanManager = "WELD-001561: Bean builder {0} does not define a BeanManager.";
    protected String beanBuilderInvalidBeanManager$str() {
        return beanBuilderInvalidBeanManager;
    }
    @Override
    public final DefinitionException beanBuilderInvalidBeanManager(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(beanBuilderInvalidBeanManager$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String producerMethodReturnTypeInvalidTypeVariable = "WELD-001562: A producer method return type may not be a type variable or an array type whose component type is a type variable: \n  {0}\n\tat {1}\n  StackTrace:";
    protected String producerMethodReturnTypeInvalidTypeVariable$str() {
        return producerMethodReturnTypeInvalidTypeVariable;
    }
    @Override
    public final DefinitionException producerMethodReturnTypeInvalidTypeVariable(final Object param1, final String stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(producerMethodReturnTypeInvalidTypeVariable$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String producerFieldTypeInvalidTypeVariable = "WELD-001563: A producer field type may not be a type variable or an array type whose component type is a type variable: \n  {0}\n\tat {1}\n  StackTrace:";
    protected String producerFieldTypeInvalidTypeVariable$str() {
        return producerFieldTypeInvalidTypeVariable;
    }
    @Override
    public final DefinitionException producerFieldTypeInvalidTypeVariable(final Object param1, final String stackElement) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(producerFieldTypeInvalidTypeVariable$str(), param1, stackElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String statelessSessionBeanInjectionPointMetadataNotAvailable = "WELD-001564: Injection point metadata injected into a stateless session bean may only be accessed within its business method invocation";
    protected String statelessSessionBeanInjectionPointMetadataNotAvailable$str() {
        return statelessSessionBeanInjectionPointMetadataNotAvailable;
    }
    @Override
    public final IllegalStateException statelessSessionBeanInjectionPointMetadataNotAvailable() {
        final IllegalStateException result = new IllegalStateException(statelessSessionBeanInjectionPointMetadataNotAvailable$str());
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noInterceptionFunction = "WELD-001565: Interceptor builder {0} does not define an interception function.";
    protected String noInterceptionFunction$str() {
        return noInterceptionFunction;
    }
    @Override
    public final DefinitionException noInterceptionFunction(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(noInterceptionFunction$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noInterceptionType = "WELD-001566: Interceptor builder {0} does not define any InterceptionType.";
    protected String noInterceptionType$str() {
        return noInterceptionType;
    }
    @Override
    public final DefinitionException noInterceptionType(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(noInterceptionType$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateContextualInstanceOfBuilderInterceptor = "WELD-001567: Cannot create contextual instance of {0}";
    protected String cannotCreateContextualInstanceOfBuilderInterceptor$str() {
        return cannotCreateContextualInstanceOfBuilderInterceptor;
    }
    @Override
    public final IllegalStateException cannotCreateContextualInstanceOfBuilderInterceptor(final Object param1) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(cannotCreateContextualInstanceOfBuilderInterceptor$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateClassFile = "WELD-001568: Unable to create ClassFile for: {1}.";
    protected String unableToCreateClassFile$str() {
        return unableToCreateClassFile;
    }
    @Override
    public final IllegalStateException unableToCreateClassFile(final Object name, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(unableToCreateClassFile$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInjectInjectionPointMetadataIntoNonDependent = "WELD-001569: Cannot inject injection point metadata in a non @Dependent bean: {0}";
    protected String cannotInjectInjectionPointMetadataIntoNonDependent$str() {
        return cannotInjectInjectionPointMetadataIntoNonDependent;
    }
    @Override
    public final IllegalArgumentException cannotInjectInjectionPointMetadataIntoNonDependent(final Object bean) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(cannotInjectInjectionPointMetadataIntoNonDependent$str(), bean));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noCallbackSpecifiedForCustomBean = "WELD-001570: Invalid BeanConfigurator setup - no callback was specified for {0}";
    protected String noCallbackSpecifiedForCustomBean$str() {
        return noCallbackSpecifiedForCustomBean;
    }
    @Override
    public final IllegalStateException noCallbackSpecifiedForCustomBean(final Object bean) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(noCallbackSpecifiedForCustomBean$str(), bean));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void generatingProxyToDefaultPackage(final Object param1, final Object param2, final Object param3) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.INFO, null, generatingProxyToDefaultPackage$str(), param1, param2, param3);
    }
    private static final String generatingProxyToDefaultPackage = "WELD-001571: Proxy for {0} created in {1} because {2}.";
    protected String generatingProxyToDefaultPackage$str() {
        return generatingProxyToDefaultPackage;
    }
    private static final String initABDnotInvoked = "WELD-001572: Cannot create instance of session bean from Annotated Type {0} before AfterDeploymentValidation phase.";
    protected String initABDnotInvoked$str() {
        return initABDnotInvoked;
    }
    @Override
    public final CreationException initABDnotInvoked(final Object bean) {
        final CreationException result = new CreationException(java.text.MessageFormat.format(initABDnotInvoked$str(), bean));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotObtainHandlerContextualReference = "WELD-001573: Cannot obtain contextual reference for {0} - producing WeldInstance does not exist anymore";
    protected String cannotObtainHandlerContextualReference$str() {
        return cannotObtainHandlerContextualReference;
    }
    @Override
    public final IllegalStateException cannotObtainHandlerContextualReference(final Object handler) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(cannotObtainHandlerContextualReference$str(), handler));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotDestroyHandlerContextualReference(final Object handler) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, cannotDestroyHandlerContextualReference$str(), handler);
    }
    private static final String cannotDestroyHandlerContextualReference = "WELD-001574: Cannot destroy contextual instance for {0} - producing WeldInstance does not exist anymore";
    protected String cannotDestroyHandlerContextualReference$str() {
        return cannotDestroyHandlerContextualReference;
    }
    private static final String selectByTypeOnlyWorksOnObject = "WELD-001575: WeldInstance.select(Type subtype, Annotation... qualifiers) can be invoked only on an instance of WeldInstance<Object>.";
    protected String selectByTypeOnlyWorksOnObject$str() {
        return selectByTypeOnlyWorksOnObject;
    }
    @Override
    public final IllegalStateException selectByTypeOnlyWorksOnObject() {
        final IllegalStateException result = new IllegalStateException(selectByTypeOnlyWorksOnObject$str());
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void creatingProxyInstanceUsingDifferentInstantiator(final Object proxyClass, final Object newInstantiator, final Object oldInstantiator) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, creatingProxyInstanceUsingDifferentInstantiator$str(), proxyClass, newInstantiator, oldInstantiator);
    }
    private static final String creatingProxyInstanceUsingDifferentInstantiator = "WELD-001576: Using {1} to instantiate a shared proxy class {0}; the deployment implementation [{2}] does not match the instantiator the proxy was created with";
    protected String creatingProxyInstanceUsingDifferentInstantiator$str() {
        return creatingProxyInstanceUsingDifferentInstantiator;
    }
    @Override
    public final void privateFinalMethodOnInterceptedBean(final Object beanClass, final Object method) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.INFO, null, privateFinalMethodOnInterceptedBean$str(), beanClass, method);
    }
    private static final String privateFinalMethodOnInterceptedBean = "WELD-001577: Detected private final method: {1}\non an intercepted bean: {0}\nWeld will ignore this method during interception.";
    protected String privateFinalMethodOnInterceptedBean$str() {
        return privateFinalMethodOnInterceptedBean;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, throwable, catchingDebug$str());
    }
    private static final String catchingDebug = "Catching";
    protected String catchingDebug$str() {
        return catchingDebug;
    }
}
