package org.jboss.weld.logging;

import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.weld.exceptions.CreationException;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-08-12T15:52:30+0200")
public class InterceptorLogger_$logger extends DelegatingBasicLogger implements InterceptorLogger,org.jboss.weld.logging.WeldLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = InterceptorLogger_$logger.class.getName();
    public InterceptorLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void interceptorAnnotationClassNotFound(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, interceptorAnnotationClassNotFound$str(), param1);
    }
    private static final String interceptorAnnotationClassNotFound = "WELD-001700: Interceptor annotation class {0} not found, interception based on it is not enabled";
    protected String interceptorAnnotationClassNotFound$str() {
        return interceptorAnnotationClassNotFound;
    }
    @Override
    public final void invokingNextInterceptorInChain(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.TRACE, null, invokingNextInterceptorInChain$str(), param1);
    }
    private static final String invokingNextInterceptorInChain = "WELD-001701: Invoking next interceptor in chain: {0}";
    protected String invokingNextInterceptorInChain$str() {
        return invokingNextInterceptorInChain;
    }
    private static final String nullInterceptorBindings = "WELD-001702: Interceptor.getInterceptorBindings() returned null for {0}";
    protected String nullInterceptorBindings$str() {
        return nullInterceptorBindings;
    }
    @Override
    public final DefinitionException nullInterceptorBindings(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(nullInterceptorBindings$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToDetermineInterceptedBean(final Object injectionPoint) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.INFO, null, unableToDetermineInterceptedBean$str(), injectionPoint);
    }
    private static final String unableToDetermineInterceptedBean = "WELD-001703: Unable to determine the @Intercepted Bean<?> for {0}";
    protected String unableToDetermineInterceptedBean$str() {
        return unableToDetermineInterceptedBean;
    }
    private static final String interceptedBeanCanOnlyBeInjectedIntoInterceptor = "WELD-001704: @Intercepted Bean<?> can only be injected into an interceptor: {0}";
    protected String interceptedBeanCanOnlyBeInjectedIntoInterceptor$str() {
        return interceptedBeanCanOnlyBeInjectedIntoInterceptor;
    }
    @Override
    public final IllegalArgumentException interceptedBeanCanOnlyBeInjectedIntoInterceptor(final Object injectionPoint) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(interceptedBeanCanOnlyBeInjectedIntoInterceptor$str(), injectionPoint));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String targetInstanceNotCreated = "WELD-001705: Target instance not created - one of the interceptor methods in the AroundConstruct chain did not invoke InvocationContext.proceed() for: {0}";
    protected String targetInstanceNotCreated$str() {
        return targetInstanceNotCreated;
    }
    @Override
    public final CreationException targetInstanceNotCreated(final Object constructor) {
        final CreationException result = new CreationException(java.text.MessageFormat.format(targetInstanceNotCreated$str(), constructor));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interceptionFactoryNotReusable = "WELD-001706: InterceptionFactory.createInterceptedInstance() may only be called once";
    protected String interceptionFactoryNotReusable$str() {
        return interceptionFactoryNotReusable;
    }
    @Override
    public final IllegalStateException interceptionFactoryNotReusable() {
        final IllegalStateException result = new IllegalStateException(interceptionFactoryNotReusable$str());
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void interceptionFactoryConfigureInvoked(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, interceptionFactoryConfigureInvoked$str(), param1);
    }
    private static final String interceptionFactoryConfigureInvoked = "WELD-001707: InterceptionFactory.configure() was invoked for AnnotatedType: {0}";
    protected String interceptionFactoryConfigureInvoked$str() {
        return interceptionFactoryConfigureInvoked;
    }
    @Override
    public final void interceptionFactoryIgnoreFinalMethodsInvoked(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, interceptionFactoryIgnoreFinalMethodsInvoked$str(), param1);
    }
    private static final String interceptionFactoryIgnoreFinalMethodsInvoked = "WELD-001708: InterceptionFactory.ignoreFinalMethods() was invoked for AnnotatedType: {0}. Final methods will be ignored during proxy generation!";
    protected String interceptionFactoryIgnoreFinalMethodsInvoked$str() {
        return interceptionFactoryIgnoreFinalMethodsInvoked;
    }
    @Override
    public final void interceptionFactoryNotRequired(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, interceptionFactoryNotRequired$str(), param1);
    }
    private static final String interceptionFactoryNotRequired = "WELD-001709: InterceptionFactory skipped wrapper creation for AnnotatedType {0} because no @AroundInvoke interceptor was bound to it.";
    protected String interceptionFactoryNotRequired$str() {
        return interceptionFactoryNotRequired;
    }
    @Override
    public final void interceptionFactoryInternalContainerConstruct(final Object type) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, interceptionFactoryInternalContainerConstruct$str(), type);
    }
    private static final String interceptionFactoryInternalContainerConstruct = "WELD-001710: InterceptionFactory skipped wrapper creation for an internal container construct of type {0}";
    protected String interceptionFactoryInternalContainerConstruct$str() {
        return interceptionFactoryInternalContainerConstruct;
    }
    private static final String interceptionFactoryNotOnInstance = "WELD-001711: InterceptionFactory is not supported on interfaces. Check InterceptionFactory<{0}>";
    protected String interceptionFactoryNotOnInstance$str() {
        return interceptionFactoryNotOnInstance;
    }
    @Override
    public final IllegalStateException interceptionFactoryNotOnInstance(final Object param1) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(interceptionFactoryNotOnInstance$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, throwable, catchingDebug$str());
    }
    private static final String catchingDebug = "Catching";
    protected String catchingDebug$str() {
        return catchingDebug;
    }
}
