package org.jboss.weld.logging;

import java.util.Locale;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-04-14T11:42:29+0200")
public class SerializationLogger_$logger extends DelegatingBasicLogger implements SerializationLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SerializationLogger_$logger.class.getName();
    public SerializationLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unableToGetBeanIdentifier$str() {
        return "WELD-001800: Unable to get bean identifier at position {0} from {1}";
    }
    @Override
    public final IllegalStateException unableToGetBeanIdentifier(final int index, final Object info) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToGetBeanIdentifier$str(), index, info));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unableToDeserialize$str() {
        return "WELD-001801: Unable to deserialize {0}";
    }
    @Override
    public final InvalidObjectException unableToDeserialize(final Object info, final Throwable cause) {
        final InvalidObjectException result = new InvalidObjectException(_formatMessage(unableToDeserialize$str(), info));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
