package org.jboss.weld.logging;

import java.util.Locale;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.weld.exceptions.CreationException;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-05-12T11:08:55+0200")
public class InterceptorLogger_$logger extends DelegatingBasicLogger implements InterceptorLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = InterceptorLogger_$logger.class.getName();
    public InterceptorLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void interceptorAnnotationClassNotFound(final Object param1) {
        super.log.logv(FQCN, WARN, null, interceptorAnnotationClassNotFound$str(), param1);
    }
    protected String interceptorAnnotationClassNotFound$str() {
        return "WELD-001700: Interceptor annotation class {0} not found, interception based on it is not enabled";
    }
    @Override
    public final void invokingNextInterceptorInChain(final Object param1) {
        super.log.logv(FQCN, TRACE, null, invokingNextInterceptorInChain$str(), param1);
    }
    protected String invokingNextInterceptorInChain$str() {
        return "WELD-001701: Invoking next interceptor in chain: {0}";
    }
    protected String nullInterceptorBindings$str() {
        return "WELD-001702: Interceptor.getInterceptorBindings() returned null for {0}";
    }
    @Override
    public final DefinitionException nullInterceptorBindings(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(nullInterceptorBindings$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void unableToDetermineInterceptedBean(final Object injectionPoint) {
        super.log.logv(FQCN, INFO, null, unableToDetermineInterceptedBean$str(), injectionPoint);
    }
    protected String unableToDetermineInterceptedBean$str() {
        return "WELD-001703: Unable to determine the @Intercepted Bean<?> for {0}";
    }
    protected String interceptedBeanCanOnlyBeInjectedIntoInterceptor$str() {
        return "WELD-001704: @Intercepted Bean<?> can only be injected into an interceptor: {0}";
    }
    @Override
    public final IllegalArgumentException interceptedBeanCanOnlyBeInjectedIntoInterceptor(final Object injectionPoint) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(interceptedBeanCanOnlyBeInjectedIntoInterceptor$str(), injectionPoint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String targetInstanceNotCreated$str() {
        return "WELD-001705: Target instance not created - one of the interceptor methods in the AroundConstruct chain did not invoke InvocationContext.proceed() for: {0}";
    }
    @Override
    public final CreationException targetInstanceNotCreated(final Object constructor) {
        final CreationException result = new CreationException(_formatMessage(targetInstanceNotCreated$str(), constructor));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptionFactoryNotReusable$str() {
        return "WELD-001706: InterceptionFactory.createInterceptedInstance() may only be called once";
    }
    @Override
    public final IllegalStateException interceptionFactoryNotReusable() {
        final IllegalStateException result = new IllegalStateException(interceptionFactoryNotReusable$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void interceptionFactoryConfigureInvoked(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, interceptionFactoryConfigureInvoked$str(), param1);
    }
    protected String interceptionFactoryConfigureInvoked$str() {
        return "WELD-001707: InterceptionFactory.configure() was invoked for AnnotatedType: {0}";
    }
    @Override
    public final void interceptionFactoryIgnoreFinalMethodsInvoked(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, interceptionFactoryIgnoreFinalMethodsInvoked$str(), param1);
    }
    protected String interceptionFactoryIgnoreFinalMethodsInvoked$str() {
        return "WELD-001708: InterceptionFactory.ignoreFinalMethods() was invoked for AnnotatedType: {0}. Final methods will be ignored during proxy generation!";
    }
    @Override
    public final void interceptionFactoryNotRequired(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, interceptionFactoryNotRequired$str(), param1);
    }
    protected String interceptionFactoryNotRequired$str() {
        return "WELD-001709: InterceptionFactory skipped wrapper creation for AnnotatedType {0} because no @AroundInvoke interceptor was bound to it.";
    }
    @Override
    public final void interceptionFactoryInternalContainerConstruct(final Object type) {
        super.log.logv(FQCN, DEBUG, null, interceptionFactoryInternalContainerConstruct$str(), type);
    }
    protected String interceptionFactoryInternalContainerConstruct$str() {
        return "WELD-001710: InterceptionFactory skipped wrapper creation for an internal container construct of type {0}";
    }
    protected String interceptionFactoryNotOnInstance$str() {
        return "WELD-001711: InterceptionFactory is not supported on interfaces. Check InterceptionFactory<{0}>";
    }
    @Override
    public final IllegalStateException interceptionFactoryNotOnInstance(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(interceptionFactoryNotOnInstance$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
