/*
 * JBoss, Home of Professional Open Source
 * Copyright 2016, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.weld.bootstrap;

import java.util.Collection;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;

import org.jboss.weld.event.ContainerLifecycleEventObserverMethod;

/**
 * A synthetic extension. This extension is not registered as a bean, Weld only registers the synthetic container lifecycle observer methods.
 *
 * @author Martin Kouba
 */
public interface SyntheticExtension extends Extension {

    /**
     *
     * @return a collection of synthetic container lifecycle observer methods
     */
    Collection<ContainerLifecycleEventObserverMethod<?>> getObservers();

    /**
     * Allows to initialize the synthetic observers before put into service.
     *
     * @param beanManager
     */
    default void initialize(BeanManager beanManager) {
    }

}
