package org.jboss.weld.logging;

import java.util.Locale;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-06-22T08:23:47+0200")
public class ConfigurationLogger_$logger extends DelegatingBasicLogger implements ConfigurationLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigurationLogger_$logger.class.getName();
    public ConfigurationLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String invalidConfigurationPropertyValue$str() {
        return "WELD-001900: Invalid configuration property value {0} for key {1}";
    }
    @Override
    public final IllegalStateException invalidConfigurationPropertyValue(final Object value, final Object key) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(invalidConfigurationPropertyValue$str(), value, key));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String configurationPropertyTypeMismatch$str() {
        return "WELD-001901: Configuration property type {0} does not match the required type {1} for configuration key {2}";
    }
    @Override
    public final IllegalStateException configurationPropertyTypeMismatch(final Object propertyType, final Object requiredType, final Object key) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(configurationPropertyTypeMismatch$str(), propertyType, requiredType, key));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void configurationInitialized(final Object configuration) {
        super.log.logv(FQCN, DEBUG, null, configurationInitialized$str(), configuration);
    }
    protected String configurationInitialized$str() {
        return "WELD-001902: Following configuration was detected and applied: {0}";
    }
    @Override
    public final void configurationKeyAlreadySet(final Object configurationKey, final Object value, final Object ignoredValue, final String mergedSourceDescription) {
        super.log.logv(FQCN, DEBUG, null, configurationKeyAlreadySet$str(), configurationKey, value, ignoredValue, mergedSourceDescription);
    }
    protected String configurationKeyAlreadySet$str() {
        return "WELD-001903: Configuration key {0} already set to {1} in a source with higher priority, value {2} from {3} is ignored";
    }
    @Override
    public final void unsupportedConfigurationKeyFound(final Object key) {
        super.log.logv(FQCN, WARN, null, unsupportedConfigurationKeyFound$str(), key);
    }
    protected String unsupportedConfigurationKeyFound$str() {
        return "WELD-001904: Unsupported configuration key found and ignored: {0}";
    }
    protected String configurationKeyHasDifferentValues$str() {
        return "WELD-001905: Configuration key {0} set to different values in the same source:\n - {1}\n - {2}";
    }
    @Override
    public final IllegalStateException configurationKeyHasDifferentValues(final Object key, final Object value1, final Object value2) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(configurationKeyHasDifferentValues$str(), key, value1, value2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void resourceLoaderNotSpecifiedForArchive(final Object archive) {
        super.log.logv(FQCN, DEBUG, null, resourceLoaderNotSpecifiedForArchive$str(), archive);
    }
    protected String resourceLoaderNotSpecifiedForArchive$str() {
        return "WELD-001906: ResourceLoader not specified for {0}, file properties will not be loaded";
    }
    @Override
    public final void readingPropertiesFile(final Object file) {
        super.log.logv(FQCN, DEBUG, null, readingPropertiesFile$str(), file);
    }
    protected String readingPropertiesFile$str() {
        return "WELD-001907: Reading properties file: {0}";
    }
    @Override
    public final void cannotSetIntegratorOnlyConfigurationProperty(final Object key, final Object value) {
        super.log.logv(FQCN, WARN, null, cannotSetIntegratorOnlyConfigurationProperty$str(), key, value);
    }
    protected String cannotSetIntegratorOnlyConfigurationProperty$str() {
        return "WELD-001908: Configuration property {0} can only be set by integrator - value {1} ignored";
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
