package org.jboss.weld.logging;

import java.util.Locale;
import org.jboss.weld.exceptions.NullInstanceException;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.weld.exceptions.IllegalProductException;
import org.jboss.weld.exceptions.CreationException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-10-14T10:47:09+0200")
public class BeanLogger_$logger extends DelegatingBasicLogger implements BeanLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = BeanLogger_$logger.class.getName();
    public BeanLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void foundOneInjectableConstructor(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, foundOneInjectableConstructor$str(), param1, param2);
    }
    protected String foundOneInjectableConstructor$str() {
        return "WELD-000001: Exactly one constructor ({0}) annotated with @Inject defined, using it as the bean constructor for {1}";
    }
    @Override
    public final void foundDefaultConstructor(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, foundDefaultConstructor$str(), param1, param2);
    }
    protected String foundDefaultConstructor$str() {
        return "WELD-000002: Exactly one constructor ({0}) defined, using it as the bean constructor for {1}";
    }
    @Override
    public final void foundOnePostConstructMethod(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, foundOnePostConstructMethod$str(), param1, param2);
    }
    protected String foundOnePostConstructMethod$str() {
        return "WELD-000004: Exactly one post construct method ({0}) for {1}";
    }
    @Override
    public final void foundOnePreDestroyMethod(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, foundOnePreDestroyMethod$str(), param1, param2);
    }
    protected String foundOnePreDestroyMethod$str() {
        return "WELD-000006: Exactly one pre destroy method ({0}) for {1}";
    }
    @Override
    public final void createdSessionBeanProxy(final Object param1) {
        super.log.logv(FQCN, TRACE, null, createdSessionBeanProxy$str(), param1);
    }
    protected String createdSessionBeanProxy$str() {
        return "WELD-000007: Created session bean proxy for {0}";
    }
    @Override
    public final void callProxiedMethod(final Object param1, final Object param2, final Object param3, final Object param4) {
        super.log.logv(FQCN, TRACE, null, callProxiedMethod$str(), param1, param2, param3, param4);
    }
    protected String callProxiedMethod$str() {
        return "WELD-000008: Called {0} on {1} with parameters {2} which returned {3}";
    }
    protected String dynamicLookupOfBuiltInNotAllowed$str() {
        return "WELD-000009: Dynamic lookup of {0} is not supported";
    }
    @Override
    public final IllegalArgumentException dynamicLookupOfBuiltInNotAllowed(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(dynamicLookupOfBuiltInNotAllowed$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void qualifiersUsed(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, qualifiersUsed$str(), param1, param2);
    }
    protected String qualifiersUsed$str() {
        return "WELD-000010: Using qualifiers {0} for {1}";
    }
    @Override
    public final void creatingBean(final Object param1) {
        super.log.logv(FQCN, TRACE, null, creatingBean$str(), param1);
    }
    protected String creatingBean$str() {
        return "WELD-000012: Building bean metadata for {0}";
    }
    @Override
    public final void usingName(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, usingName$str(), param1, param2);
    }
    protected String usingName$str() {
        return "WELD-000014: Using name {0} for {1}";
    }
    @Override
    public final void usingScope(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, usingScope$str(), param1, param2);
    }
    protected String usingScope$str() {
        return "WELD-000016: Using scope {0} for {1}";
    }
    @Override
    public final void circularCall(final Object param1, final Object param2) {
        super.log.logv(FQCN, WARN, null, circularCall$str(), param1, param2);
    }
    protected String circularCall$str() {
        return "WELD-000018: Executing producer field or method {0} on incomplete declaring bean {1} due to circular injection";
    }
    @Override
    public final void errorDestroying(final Object param1, final Object param2) {
        super.log.logv(FQCN, ERROR, null, errorDestroying$str(), param1, param2);
    }
    protected String errorDestroying$str() {
        return "WELD-000019: Error destroying an instance {0} of {1}";
    }
    protected String typeParameterMustBeConcrete$str() {
        return "WELD-000023: Type parameter must be a concrete type:  {0}";
    }
    @Override
    public final String typeParameterMustBeConcrete(final Object param1) {
        return _formatMessage(typeParameterMustBeConcrete$str(), param1);
    }
    protected String invalidResourceProducerField$str() {
        return "WELD-000025: Tried to create an EEResourceProducerField, but no @Resource, @PersistenceContext, @PersistenceUnit, @WebServiceRef or @EJB is present: {0}";
    }
    @Override
    public final IllegalStateException invalidResourceProducerField(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(invalidResourceProducerField$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String securityServicesNotAvailable$str() {
        return "WELD-000026: Security Services not available - unable to obtain the Principal";
    }
    @Override
    public final IllegalStateException securityServicesNotAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), securityServicesNotAvailable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String transactionServicesNotAvailable$str() {
        return "WELD-000027: Transaction Services not available - unable to obtain the UserTransaction";
    }
    @Override
    public final IllegalStateException transactionServicesNotAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), transactionServicesNotAvailable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptionModelNull$str() {
        return "WELD-000028: Interception model must not be null";
    }
    @Override
    public final IllegalArgumentException interceptionModelNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), interceptionModelNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptionTypeNull$str() {
        return "WELD-000029: InterceptionType must not be null";
    }
    @Override
    public final IllegalArgumentException interceptionTypeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), interceptionTypeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String methodNull$str() {
        return "WELD-000030: Method must not be null";
    }
    @Override
    public final IllegalArgumentException methodNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), methodNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptionTypeLifecycle$str() {
        return "WELD-000031: InterceptionType must not be lifecycle, but it is {0}";
    }
    @Override
    public final IllegalArgumentException interceptionTypeLifecycle(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(interceptionTypeLifecycle$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptionTypeNotLifecycle$str() {
        return "WELD-000032: InterceptionType must be lifecycle, but it is {0}";
    }
    @Override
    public final IllegalArgumentException interceptionTypeNotLifecycle(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(interceptionTypeNotLifecycle$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String proxyInstantiationFailed$str() {
        return "WELD-000033: Could not instantiate client proxy for {0}";
    }
    @Override
    public final String proxyInstantiationFailed(final Object param1) {
        return _formatMessage(proxyInstantiationFailed$str(), param1);
    }
    protected String proxyInstantiationBeanAccessFailed$str() {
        return "WELD-000034: Could not access bean correctly when creating client proxy for {0}";
    }
    @Override
    public final String proxyInstantiationBeanAccessFailed(final Object param1) {
        return _formatMessage(proxyInstantiationBeanAccessFailed$str(), param1);
    }
    protected String beanIdCreationFailed$str() {
        return "WELD-000035: There was an error creating an id for {0}";
    }
    @Override
    public final DefinitionException beanIdCreationFailed(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(beanIdCreationFailed$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedUnwrappedCustomDecorator$str() {
        return "WELD-000036: Unexpected unwrapped custom decorator instance: {0}";
    }
    @Override
    public final IllegalStateException unexpectedUnwrappedCustomDecorator(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unexpectedUnwrappedCustomDecorator$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRemoveMethodInvocation$str() {
        return "WELD-000037: Cannot call EJB remove method directly on non-dependent scoped bean {0}";
    }
    @Override
    public final UnsupportedOperationException invalidRemoveMethodInvocation(final Object param1) {
        final UnsupportedOperationException result = new UnsupportedOperationException(_formatMessage(invalidRemoveMethodInvocation$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String delegateNotOnDecorator$str() {
        return "WELD-000038: A bean class that is not a decorator has an injection point annotated @Delegate\n  at injection point {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException delegateNotOnDecorator(final Object ip, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(delegateNotOnDecorator$str(), ip, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String typedClassNotInHierarchy$str() {
        return "WELD-000039: @Typed class {0} not present in the set of bean types of {1} [{2}]";
    }
    @Override
    public final DefinitionException typedClassNotInHierarchy(final Object param1, final Object param2, final Object types) {
        final DefinitionException result = new DefinitionException(_formatMessage(typedClassNotInHierarchy$str(), param1, param2, types));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleScopesFoundFromStereotypes$str() {
        return "WELD-000040: All stereotypes must specify the same scope or the bean must declare a scope - declared on {0}, declared stereotypes [{1}], possible scopes {2}{3}";
    }
    @Override
    public final DefinitionException multipleScopesFoundFromStereotypes(final Object declaredOn, final Object stereotypes, final Object possibleScopes, final String stack) {
        final DefinitionException result = new DefinitionException(_formatMessage(multipleScopesFoundFromStereotypes$str(), declaredOn, stereotypes, possibleScopes, stack));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nameNotAllowedOnSpecialization$str() {
        return "WELD-000041: Specializing bean may not declare a bean name if it is declared by specialized bean\n  specializing: {0}\n  specialized: {1}";
    }
    @Override
    public final DefinitionException nameNotAllowedOnSpecialization(final Object specializing, final Object specialized) {
        final DefinitionException result = new DefinitionException(_formatMessage(nameNotAllowedOnSpecialization$str(), specializing, specialized));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonContainerDecorator$str() {
        return "WELD-000042: Cannot operate on non container provided decorator {0}";
    }
    @Override
    public final IllegalStateException nonContainerDecorator(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(nonContainerDecorator$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanNotEeResourceProducer$str() {
        return "WELD-000043: The following bean is not an EE resource producer:  {0}";
    }
    @Override
    public final IllegalStateException beanNotEeResourceProducer(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(beanNotEeResourceProducer$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullInstance$str() {
        return "WELD-000044: Unable to obtain instance from {0}";
    }
    @Override
    public final NullInstanceException nullInstance(final Object param1) {
        final NullInstanceException result = new NullInstanceException(_formatMessage(nullInstance$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String serializationProxyRequired$str() {
        return "WELD-000045: Unable to deserialize object - serialization proxy is required";
    }
    @Override
    public final InvalidObjectException serializationProxyRequired() {
        final InvalidObjectException result = new InvalidObjectException(String.format(getLoggingLocale(), serializationProxyRequired$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String onlyOneScopeAllowed$str() {
        return "WELD-000046: At most one scope may be specified on {0}";
    }
    @Override
    public final DefinitionException onlyOneScopeAllowed(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(onlyOneScopeAllowed$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String specializingBeanMustExtendABean$str() {
        return "WELD-000047: Specializing bean must extend another bean:  {0}";
    }
    @Override
    public final DefinitionException specializingBeanMustExtendABean(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(specializingBeanMustExtendABean$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingInterceptorBindings$str() {
        return "WELD-000048: Conflicting interceptor bindings found on {0}";
    }
    @Override
    public final String conflictingInterceptorBindings(final Object param1) {
        return _formatMessage(conflictingInterceptorBindings$str(), param1);
    }
    protected String invocationError$str() {
        return "WELD-000049: Unable to invoke {0} on {1}";
    }
    @Override
    public final WeldException invocationError(final Object param1, final Object param2, final Throwable cause) {
        final WeldException result = new WeldException(_formatMessage(invocationError$str(), param1, param2), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String producerCastError$str() {
        return "WELD-000050: Cannot cast producer type {0} to bean type {1}";
    }
    @Override
    public final WeldException producerCastError(final Object param1, final Object param2, final Throwable cause) {
        final WeldException result = new WeldException(_formatMessage(producerCastError$str(), param1, param2), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullNotAllowedFromProducer$str() {
        return "WELD-000052: Cannot return null from a non-dependent producer method: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final IllegalProductException nullNotAllowedFromProducer(final Object param1, final Object stackElement) {
        final IllegalProductException result = new IllegalProductException(_formatMessage(nullNotAllowedFromProducer$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonSerializableProductError$str() {
        return "WELD-000053: Producers cannot declare passivating scope and return a non-serializable class: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final IllegalProductException nonSerializableProductError(final Object param1, final Object stackElement) {
        final IllegalProductException result = new IllegalProductException(_formatMessage(nonSerializableProductError$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unserializableProductInjectionError$str() {
        return "WELD-000054: Producers cannot produce unserializable instances for injection into an injection point that requires a passivation capable dependency\n  Producer:  {0}\n\tat {1}\n  Injection Point:  {2}\n\tat {3}\n  StackTrace:";
    }
    @Override
    public final IllegalProductException unserializableProductInjectionError(final Object producer, final Object producerStackElement, final Object ip, final Object ipStackElement) {
        final IllegalProductException result = new IllegalProductException(_formatMessage(unserializableProductInjectionError$str(), producer, producerStackElement, ip, ipStackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDelegateInjectionPoint$str() {
        return "WELD-000059: No delegate injection point defined for {0}";
    }
    @Override
    public final DefinitionException noDelegateInjectionPoint(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(noDelegateInjectionPoint$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tooManyDelegateInjectionPoints$str() {
        return "WELD-000060: Too many delegate injection points defined for {0}";
    }
    @Override
    public final DefinitionException tooManyDelegateInjectionPoints(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(tooManyDelegateInjectionPoints$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String delegateMustSupportEveryDecoratedType$str() {
        return "WELD-000061: The delegate type does not extend or implement the decorated type. \n  Decorated type: {0}\n  Decorator: {1}";
    }
    @Override
    public final DefinitionException delegateMustSupportEveryDecoratedType(final Object decoratedType, final Object decorator) {
        final DefinitionException result = new DefinitionException(_formatMessage(delegateMustSupportEveryDecoratedType$str(), decoratedType, decorator));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToProcessDecoratedType$str() {
        return "WELD-000064: Unable to process decorated type: {0}";
    }
    @Override
    public final IllegalStateException unableToProcessDecoratedType(final Object decoratedType) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToProcessDecoratedType$str(), decoratedType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleDisposeParams$str() {
        return "WELD-000066: {0} has more than one @Dispose parameter \n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException multipleDisposeParams(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(multipleDisposeParams$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String inconsistentAnnotationsOnMethod$str() {
        return "WELD-000067: {0} is not allowed on same method as {1}, see {2}\n\tat {3}\n  StackTrace:";
    }
    @Override
    public final DefinitionException inconsistentAnnotationsOnMethod(final Object param1, final Object param2, final Object param3, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(inconsistentAnnotationsOnMethod$str(), param1, param2, param3, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String methodNotBusinessMethod$str() {
        return "WELD-000068: {0} method {1} is not a business method of {2}\n\tat {3}\n  StackTrace:";
    }
    @Override
    public final DefinitionException methodNotBusinessMethod(final Object methodType, final Object param1, final Object param2, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(methodNotBusinessMethod$str(), methodType, param1, param2, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String simpleBeanAsNonStaticInnerClassNotAllowed$str() {
        return "WELD-000070: Simple bean {0} cannot be a non-static inner class";
    }
    @Override
    public final DefinitionException simpleBeanAsNonStaticInnerClassNotAllowed(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(simpleBeanAsNonStaticInnerClassNotAllowed$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String managedBeanWithParameterizedBeanClassMustBeDependent$str() {
        return "WELD-000071: Managed bean with a parameterized bean class must be @Dependent: {0}";
    }
    @Override
    public final DefinitionException managedBeanWithParameterizedBeanClassMustBeDependent(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(managedBeanWithParameterizedBeanClassMustBeDependent$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String passivatingBeanNeedsSerializableImpl$str() {
        return "WELD-000072: Bean declaring a passivating scope must be passivation capable.  Bean:  {0}";
    }
    @Override
    public final DeploymentException passivatingBeanNeedsSerializableImpl(final Object param1) {
        final DeploymentException result = new DeploymentException(_formatMessage(passivatingBeanNeedsSerializableImpl$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String finalBeanClassWithDecoratorsNotAllowed$str() {
        return "WELD-000073: Bean class which has decorators cannot be declared final:  {0}";
    }
    @Override
    public final DeploymentException finalBeanClassWithDecoratorsNotAllowed(final Object param1) {
        final DeploymentException result = new DeploymentException(_formatMessage(finalBeanClassWithDecoratorsNotAllowed$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String publicFieldOnNormalScopedBeanNotAllowed$str() {
        return "WELD-000075: Normal scoped managed bean implementation class has a public field:  {0}";
    }
    @Override
    public final DefinitionException publicFieldOnNormalScopedBeanNotAllowed(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(publicFieldOnNormalScopedBeanNotAllowed$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String parameterAnnotationNotAllowedOnConstructor$str() {
        return "WELD-000076: Bean constructor must not have a parameter annotated with {0}: {1}\n\tat {2}\n  StackTrace:";
    }
    @Override
    public final DefinitionException parameterAnnotationNotAllowedOnConstructor(final Object param1, final Object param2, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(parameterAnnotationNotAllowedOnConstructor$str(), param1, param2, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleDisposalMethods$str() {
        return "WELD-000077: Cannot declare multiple disposal methods for this producer method.\n\nProducer method:  {0}\nDisposal methods:  {1}";
    }
    @Override
    public final DefinitionException multipleDisposalMethods(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(multipleDisposalMethods$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String producerMethodNotSpecializing$str() {
        return "WELD-000078: Specialized producer method does not override another producer method: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException producerMethodNotSpecializing(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(producerMethodNotSpecializing$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sessionBeanProxyInstantiationFailed$str() {
        return "WELD-000079: Could not instantiate a proxy for a session bean:  {0}\n  Proxy: {1}";
    }
    @Override
    public final CreationException sessionBeanProxyInstantiationFailed(final Object sessionBean, final Object proxyClass, final Throwable cause) {
        final CreationException result = new CreationException(_formatMessage(sessionBeanProxyInstantiationFailed$str(), sessionBean, proxyClass), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ejbCannotBeInterceptor$str() {
        return "WELD-000080: Enterprise beans cannot be interceptors:  {0}";
    }
    @Override
    public final DefinitionException ejbCannotBeInterceptor(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(ejbCannotBeInterceptor$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ejbCannotBeDecorator$str() {
        return "WELD-000081: Enterprise beans cannot be decorators:  {0}";
    }
    @Override
    public final DefinitionException ejbCannotBeDecorator(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(ejbCannotBeDecorator$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String scopeNotAllowedOnStatelessSessionBean$str() {
        return "WELD-000082: Scope {0} is not allowed on stateless session beans for {1}. Only @Dependent is allowed.";
    }
    @Override
    public final DefinitionException scopeNotAllowedOnStatelessSessionBean(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(scopeNotAllowedOnStatelessSessionBean$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String scopeNotAllowedOnSingletonBean$str() {
        return "WELD-000083: Scope {0} is not allowed on singleton session beans for {1}. Only @Dependent and @ApplicationScoped is allowed.";
    }
    @Override
    public final DefinitionException scopeNotAllowedOnSingletonBean(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(scopeNotAllowedOnSingletonBean$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String specializingEnterpriseBeanMustExtendAnEnterpriseBean$str() {
        return "WELD-000084: Specializing enterprise bean must extend another enterprise bean:  {0}";
    }
    @Override
    public final DefinitionException specializingEnterpriseBeanMustExtendAnEnterpriseBean(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(specializingEnterpriseBeanMustExtendAnEnterpriseBean$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotDestroyNullBean$str() {
        return "WELD-000085: Cannot destroy null instance of {0}";
    }
    @Override
    public final IllegalArgumentException cannotDestroyNullBean(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(cannotDestroyNullBean$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotDestroyEnterpriseBeanNotCreated$str() {
        return "WELD-000086: Cannot destroy session bean instance not created by the container:  {0}";
    }
    @Override
    public final IllegalArgumentException cannotDestroyEnterpriseBeanNotCreated(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(cannotDestroyEnterpriseBeanNotCreated$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageDrivenBeansCannotBeManaged$str() {
        return "WELD-000087: Message driven beans cannot be Managed Beans:  {0}";
    }
    @Override
    public final DefinitionException messageDrivenBeansCannotBeManaged(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(messageDrivenBeansCannotBeManaged$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String observerMethodMustBeStaticOrBusiness$str() {
        return "WELD-000088: Observer method must be static or local business method:  {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException observerMethodMustBeStaticOrBusiness(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(observerMethodMustBeStaticOrBusiness$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tooManyEjbsForClass$str() {
        return "WELD-000089: Unable to determine EJB for {0}, multiple EJBs with that class:  {1}";
    }
    @Override
    public final IllegalStateException tooManyEjbsForClass(final Object param1, final Object param2) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(tooManyEjbsForClass$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String abstractMethodMustMatchDecoratedType$str() {
        return "WELD-000090: A decorator has an abstract method that is not declared by any decorated type\n  Method: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException abstractMethodMustMatchDecoratedType(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(abstractMethodMustMatchDecoratedType$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String injectedFieldCannotBeProducer$str() {
        return "WELD-000094: Injected field {0} cannot be annotated @Produces on {1}";
    }
    @Override
    public final DefinitionException injectedFieldCannotBeProducer(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(injectedFieldCannotBeProducer$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String genericSessionBeanMustBeDependent$str() {
        return "WELD-000095: Session bean with generic class {0} must be @Dependent scope";
    }
    @Override
    public final DefinitionException genericSessionBeanMustBeDependent(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(genericSessionBeanMustBeDependent$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String producerFieldOnSessionBeanMustBeStatic$str() {
        return "WELD-000096: Producer fields on session beans must be static. Field {0} declared on {1}";
    }
    @Override
    public final DefinitionException producerFieldOnSessionBeanMustBeStatic(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(producerFieldOnSessionBeanMustBeStatic$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String producerMethodWithTypeVariableReturnTypeMustBeDependent$str() {
        return "WELD-000097: A producer method with a parameterized return type with a type variable must be declared @Dependent scoped: \n  {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException producerMethodWithTypeVariableReturnTypeMustBeDependent(final Object param1, final String stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(producerMethodWithTypeVariableReturnTypeMustBeDependent$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String producerMethodCannotHaveAWildcardReturnType$str() {
        return "WELD-000098: A producer method return type may not contain a wildcard: \n  {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException producerMethodCannotHaveAWildcardReturnType(final Object param1, final String stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(producerMethodCannotHaveAWildcardReturnType$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotLoadClass$str() {
        return "WELD-000099: Cannot load class {0} during deserialization of proxy";
    }
    @Override
    public final WeldException cannotLoadClass(final Object param1, final Throwable cause) {
        final WeldException result = new WeldException(_formatMessage(cannotLoadClass$str(), param1), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String proxyDeserializationFailure$str() {
        return "WELD-001500: Failed to deserialize proxy object with beanId {0}";
    }
    @Override
    public final WeldException proxyDeserializationFailure(final Object param1) {
        final WeldException result = new WeldException(_formatMessage(proxyDeserializationFailure$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanInstanceNotSetOnProxy$str() {
        return "WELD-001501: Method call requires a BeanInstance which has not been set for this proxy {0}";
    }
    @Override
    public final WeldException beanInstanceNotSetOnProxy(final Object param1) {
        final WeldException result = new WeldException(_formatMessage(beanInstanceNotSetOnProxy$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonDependentResourceProducerField$str() {
        return "WELD-001502: Resource producer field [{0}] must be @Dependent scoped";
    }
    @Override
    public final DefinitionException nonDependentResourceProducerField(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(nonDependentResourceProducerField$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String finalBeanClassWithInterceptorsNotAllowed$str() {
        return "WELD-001503: Bean class which has interceptors cannot be declared final:  {0}";
    }
    @Override
    public final DeploymentException finalBeanClassWithInterceptorsNotAllowed(final Object param1) {
        final DeploymentException result = new DeploymentException(_formatMessage(finalBeanClassWithInterceptorsNotAllowed$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String finalInterceptedBeanMethodNotAllowed$str() {
        return "WELD-001504: Intercepted bean method {0} (intercepted by {1}) cannot be declared final";
    }
    @Override
    public final DeploymentException finalInterceptedBeanMethodNotAllowed(final Object param1, final Object param2) {
        final DeploymentException result = new DeploymentException(_formatMessage(finalInterceptedBeanMethodNotAllowed$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void finalMethodNotIntercepted(final Object method, final Object interceptor) {
        super.log.logv(FQCN, WARN, null, finalMethodNotIntercepted$str(), method, interceptor);
    }
    protected String finalMethodNotIntercepted$str() {
        return "WELD-001505: Method {0} cannot be intercepted by {1} - will be ignored by interceptors and should never be invoked upon the proxy instance!";
    }
    @Override
    public final void createdNewClientProxyType(final Object param1, final Object param2, final Object param3) {
        super.log.logv(FQCN, TRACE, null, createdNewClientProxyType$str(), param1, param2, param3);
    }
    protected String createdNewClientProxyType$str() {
        return "WELD-001506: Created new client proxy of type {0} for bean {1} with ID {2}";
    }
    @Override
    public final void lookedUpClientProxy(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, lookedUpClientProxy$str(), param1, param2);
    }
    protected String lookedUpClientProxy$str() {
        return "WELD-001507: Located client proxy of type {0} for bean {1}";
    }
    protected String injectionTargetCannotBeCreatedForInterface$str() {
        return "WELD-001508: Cannot create an InjectionTarget from {0} as it is an interface";
    }
    @Override
    public final DefinitionException injectionTargetCannotBeCreatedForInterface(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(injectionTargetCannotBeCreatedForInterface$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String proxyHandlerSerializedForNonSerializableBean$str() {
        return "WELD-001510: Non passivation capable bean serialized with ProxyMethodHandler";
    }
    @Override
    public final WeldException proxyHandlerSerializedForNonSerializableBean() {
        final WeldException result = new WeldException(String.format(getLoggingLocale(), proxyHandlerSerializedForNonSerializableBean$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String specializingBeanMissingSpecializedType$str() {
        return "WELD-001511: Specializing bean {0} does not have bean type {1} of specialized bean {2}";
    }
    @Override
    public final DefinitionException specializingBeanMissingSpecializedType(final Object param1, final Object param2, final Object param3) {
        final DefinitionException result = new DefinitionException(_formatMessage(specializingBeanMissingSpecializedType$str(), param1, param2, param3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidInjectionPointType$str() {
        return "WELD-001512: {0} cannot be constructed for {1}";
    }
    @Override
    public final IllegalArgumentException invalidInjectionPointType(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidInjectionPointType$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAnnotatedCallable$str() {
        return "WELD-001513: An implementation of AnnotatedCallable must implement either AnnotatedConstructor or AnnotatedMethod, {0}";
    }
    @Override
    public final IllegalArgumentException invalidAnnotatedCallable(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidAnnotatedCallable$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAnnotatedMember$str() {
        return "WELD-001514: An implementation of AnnotatedMember must implement either AnnotatedConstructor, AnnotatedMethod or AnnotatedField, {0}";
    }
    @Override
    public final IllegalArgumentException invalidAnnotatedMember(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidAnnotatedMember$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToLoadMember$str() {
        return "WELD-001515: Unable to load annotated member {0}";
    }
    @Override
    public final IllegalStateException unableToLoadMember(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToLoadMember$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String namedResourceProducerField$str() {
        return "WELD-001516: Resource producer field [{0}] must not have an EL name";
    }
    @Override
    public final DefinitionException namedResourceProducerField(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(namedResourceProducerField$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidResourceProducerType$str() {
        return "WELD-001517: The type of the resource producer field [{0}] does not match the resource type {1}";
    }
    @Override
    public final DefinitionException invalidResourceProducerType(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(invalidResourceProducerType$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String declaringBeanMissing$str() {
        return "WELD-001518: Cannot create Producer implementation. Declaring bean missing for a non-static member {0}";
    }
    @Override
    public final IllegalArgumentException declaringBeanMissing(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(declaringBeanMissing$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void injectionTargetCreatedForAbstractClass(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, injectionTargetCreatedForAbstractClass$str(), param1);
    }
    protected String injectionTargetCreatedForAbstractClass$str() {
        return "WELD-001519: An InjectionTarget is created for an abstract {0}. It will not be possible to produce instances of this type!";
    }
    protected String beansWithDifferentBeanNamesCannotBeSpecialized$str() {
        return "WELD-001520: Beans with different bean names {0}, {1} cannot be specialized by a single bean {2}";
    }
    @Override
    public final DefinitionException beansWithDifferentBeanNamesCannotBeSpecialized(final Object param1, final Object param2, final Object param3) {
        final DefinitionException result = new DefinitionException(_formatMessage(beansWithDifferentBeanNamesCannotBeSpecialized$str(), param1, param2, param3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAnnotatedOfInjectionPoint$str() {
        return "WELD-001521: InjectionPoint.getAnnotated() must return either AnnotatedParameter or AnnotatedField but {0} was returned for {1}";
    }
    @Override
    public final IllegalArgumentException invalidAnnotatedOfInjectionPoint(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidAnnotatedOfInjectionPoint$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToRestoreInjectionPoint$str() {
        return "WELD-001522: Unable to restore InjectionPoint. No matching InjectionPoint found on {0}";
    }
    @Override
    public final IllegalStateException unableToRestoreInjectionPoint(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToRestoreInjectionPoint$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToRestoreInjectionPointMultiple$str() {
        return "WELD-001523: Unable to restore InjectionPoint. Multiple matching InjectionPoints found on {0}:\n  - {1},\n  - {2}";
    }
    @Override
    public final IllegalStateException unableToRestoreInjectionPointMultiple(final Object param1, final Object param2, final Object param3) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToRestoreInjectionPointMultiple$str(), param1, param2, param3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToLoadProxyClass$str() {
        return "WELD-001524: Unable to load proxy class for bean {0} with class {1}";
    }
    @Override
    public final WeldException unableToLoadProxyClass(final Object param1, final Object param2, final Throwable cause) {
        final WeldException result = new WeldException(_formatMessage(unableToLoadProxyClass$str(), param1, param2), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String destroyUnsupported$str() {
        return "WELD-001525: Instance.destroy() is not supported. The underlying context {0} does not support destroying of contextual instances";
    }
    @Override
    public final UnsupportedOperationException destroyUnsupported(final Object param1) {
        final UnsupportedOperationException result = new UnsupportedOperationException(_formatMessage(destroyUnsupported$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String passivatingBeanHasNonPassivationCapableDecorator$str() {
        return "WELD-001526: Managed bean declaring a passivating scope has a non-passivation capable decorator.  Bean:  {0}  Decorator: {1}";
    }
    @Override
    public final DeploymentException passivatingBeanHasNonPassivationCapableDecorator(final Object param1, final Object param2) {
        final DeploymentException result = new DeploymentException(_formatMessage(passivatingBeanHasNonPassivationCapableDecorator$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String passivatingBeanHasNonPassivationCapableInterceptor$str() {
        return "WELD-001527: Managed bean declaring a passivating scope has a non-serializable interceptor.  Bean:  {0}  Interceptor: {1}";
    }
    @Override
    public final DeploymentException passivatingBeanHasNonPassivationCapableInterceptor(final Object param1, final Object param2) {
        final DeploymentException result = new DeploymentException(_formatMessage(passivatingBeanHasNonPassivationCapableInterceptor$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void injectionTargetCreatedForClassWithoutAppropriateConstructor(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, injectionTargetCreatedForClassWithoutAppropriateConstructor$str(), param1);
    }
    protected String injectionTargetCreatedForClassWithoutAppropriateConstructor$str() {
        return "WELD-001529: An InjectionTarget is created for a {0} which does not have any appropriate constructor. It will not be possible to produce instances of this type!";
    }
    protected String injectionTargetCannotProduceInstance$str() {
        return "WELD-001530: Cannot produce an instance of {0}.";
    }
    @Override
    public final CreationException injectionTargetCannotProduceInstance(final Object param1) {
        final CreationException result = new CreationException(_formatMessage(injectionTargetCannotProduceInstance$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String instanceIteratorRemoveUnsupported$str() {
        return "WELD-001531: Instance.iterator().remove() is not supported.";
    }
    @Override
    public final UnsupportedOperationException instanceIteratorRemoveUnsupported() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), instanceIteratorRemoveUnsupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String passivationCapableBeanHasNullId$str() {
        return "WELD-001532: A passivation capable bean cannot have a null id: {0}";
    }
    @Override
    public final IllegalArgumentException passivationCapableBeanHasNullId(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(passivationCapableBeanHasNullId$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void injectionTargetCreatedForNonStaticInnerClass(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, injectionTargetCreatedForNonStaticInnerClass$str(), param1);
    }
    protected String injectionTargetCreatedForNonStaticInnerClass$str() {
        return "WELD-001533: An InjectionTarget is created for a non-static inner {0}. It will not be possible to produce instances of this type!";
    }
    protected String decoratedHasNoNoargsConstructor$str() {
        return "WELD-001534: Bean class which has decorators must have a public constructor without parameters: {0}";
    }
    @Override
    public final DeploymentException decoratedHasNoNoargsConstructor(final Object param1) {
        final DeploymentException result = new DeploymentException(_formatMessage(decoratedHasNoNoargsConstructor$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String decoratedNoargsConstructorIsPrivate$str() {
        return "WELD-001535: Constructor without parameters cannot be private in bean class which has decorators: {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DeploymentException decoratedNoargsConstructorIsPrivate(final Object param1, final Object stackElement) {
        final DeploymentException result = new DeploymentException(_formatMessage(decoratedNoargsConstructorIsPrivate$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void foundInjectableConstructors(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, foundInjectableConstructors$str(), param1, param2);
    }
    protected String foundInjectableConstructors$str() {
        return "WELD-001536: Found {0} constructors annotated with @Inject for {1}";
    }
    protected String injectionTargetCreatedForClassWithoutAppropriateConstructorException$str() {
        return "WELD-001537: An InjectionTarget is created for a {0} which does not have any appropriate constructor.";
    }
    @Override
    public final DefinitionException injectionTargetCreatedForClassWithoutAppropriateConstructorException(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(injectionTargetCreatedForClassWithoutAppropriateConstructorException$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void createdContextInstance(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, createdContextInstance$str(), param1, param2);
    }
    protected String createdContextInstance$str() {
        return "WELD-001538: Created context instance for bean {0} identified as {1}";
    }
    @Override
    public final void createdMethodHandlerInitializerForDecoratorProxy(final Object param1) {
        super.log.logv(FQCN, TRACE, null, createdMethodHandlerInitializerForDecoratorProxy$str(), param1);
    }
    protected String createdMethodHandlerInitializerForDecoratorProxy$str() {
        return "WELD-001539: Created MH initializer body for decorator proxy: {0}";
    }
    @Override
    public final void addingMethodToEnterpriseProxy(final Object param1) {
        super.log.logv(FQCN, TRACE, null, addingMethodToEnterpriseProxy$str(), param1);
    }
    protected String addingMethodToEnterpriseProxy$str() {
        return "WELD-001540: Adding method to enterprise proxy: {0}";
    }
    @Override
    public final void addingMethodToProxy(final Object param1) {
        super.log.logv(FQCN, TRACE, null, addingMethodToProxy$str(), param1);
    }
    protected String addingMethodToProxy$str() {
        return "WELD-001541: Adding method to proxy: {0}";
    }
    @Override
    public final void generatingProxyClass(final Object param1) {
        super.log.logv(FQCN, TRACE, null, generatingProxyClass$str(), param1);
    }
    protected String generatingProxyClass$str() {
        return "WELD-001542: Retrieving/generating proxy class {0}";
    }
    @Override
    public final void createdProxyClass(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, createdProxyClass$str(), param1, param2);
    }
    protected String createdProxyClass$str() {
        return "WELD-001543: Created Proxy class of type {0} supporting interfaces {1}";
    }
    @Override
    public final void methodHandlerProcessingReturningBeanInstance(final Object param1) {
        super.log.logv(FQCN, TRACE, null, methodHandlerProcessingReturningBeanInstance$str(), param1);
    }
    protected String methodHandlerProcessingReturningBeanInstance$str() {
        return "WELD-001544: MethodHandler processing returning bean instance for {0}";
    }
    @Override
    public final void methodHandlerProcessingCall(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, methodHandlerProcessingCall$str(), param1, param2);
    }
    protected String methodHandlerProcessingCall$str() {
        return "WELD-001545: MethodHandler processing call to {0} for {1}";
    }
    @Override
    public final void settingNewMethodHandler(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, settingNewMethodHandler$str(), param1, param2);
    }
    protected String settingNewMethodHandler$str() {
        return "WELD-001546: Setting new MethodHandler with bean instance for {0} on {1}";
    }
    @Override
    public final void invokingInterceptorChain(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, invokingInterceptorChain$str(), param1, param2);
    }
    protected String invokingInterceptorChain$str() {
        return "WELD-001547: Invoking interceptor chain for method {0} on {1}";
    }
    @Override
    public final void invokingMethodDirectly(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, invokingMethodDirectly$str(), param1, param2);
    }
    protected String invokingMethodDirectly$str() {
        return "WELD-001548: Invoking method {0} directly on {1}";
    }
    protected String unableToDetermineParentCreationalContext$str() {
        return "WELD-001549: Unable to determine parent creational context of {0}";
    }
    @Override
    public final IllegalArgumentException unableToDetermineParentCreationalContext(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(unableToDetermineParentCreationalContext$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String producerFieldWithTypeVariableBeanTypeMustBeDependent$str() {
        return "WELD-001550: A producer field with a parameterized type with a type variable must be declared @Dependent scoped: \n  {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException producerFieldWithTypeVariableBeanTypeMustBeDependent(final Object param1, final String stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(producerFieldWithTypeVariableBeanTypeMustBeDependent$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String producerFieldCannotHaveAWildcardBeanType$str() {
        return "WELD-001551: A producer field type may not contain a wildcard: \n  {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException producerFieldCannotHaveAWildcardBeanType(final Object param1, final String stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(producerFieldCannotHaveAWildcardBeanType$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void extensionWithNonStaticPublicField(final Object param1, final Object param2) {
        super.log.logv(FQCN, WARN, null, extensionWithNonStaticPublicField$str(), param1, param2);
    }
    protected String extensionWithNonStaticPublicField$str() {
        return "WELD-001552: An extension ({0}) has a non-static public field ({1}).";
    }
    @Override
    public final void activatedSessionBeanProxy(final Object param1) {
        super.log.logv(FQCN, TRACE, null, activatedSessionBeanProxy$str(), param1);
    }
    protected String activatedSessionBeanProxy$str() {
        return "WELD-001553: Proxy activated after passivation for {0}";
    }
    protected String beanMethodReturnsNull$str() {
        return "WELD-001554: Bean.{0}() returned null for {1}";
    }
    @Override
    public final DefinitionException beanMethodReturnsNull(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(beanMethodReturnsNull$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String decoratorMethodReturnsNull$str() {
        return "WELD-001555: Decorator.{0}() returned null for {1}";
    }
    @Override
    public final DefinitionException decoratorMethodReturnsNull(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(decoratorMethodReturnsNull$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String specializingManagedBeanCanExtendOnlyManagedBeans$str() {
        return "WELD-001556: Specializing {0} cannot specialize a non-managed bean {1}";
    }
    @Override
    public final DefinitionException specializingManagedBeanCanExtendOnlyManagedBeans(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(specializingManagedBeanCanExtendOnlyManagedBeans$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void beanCannotBeDumped(final Object param1, final Throwable cause) {
        super.log.logv(FQCN, WARN, cause, beanCannotBeDumped$str(), param1);
    }
    protected String beanCannotBeDumped$str() {
        return "WELD-001557: Unable to dump the proxy class file for {0}";
    }
    @Override
    public final void directoryCannotBeCreated(final Object param1) {
        super.log.logv(FQCN, WARN, null, directoryCannotBeCreated$str(), param1);
    }
    protected String directoryCannotBeCreated$str() {
        return "WELD-001558: Unable to create directory {0} to dump the proxy classes.";
    }
    protected String beanBuilderInvalidCreateCallback$str() {
        return "WELD-001559: Bean builder {0} does not define a create lifecycle callback.";
    }
    @Override
    public final DefinitionException beanBuilderInvalidCreateCallback(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(beanBuilderInvalidCreateCallback$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanBuilderInvalidDestroyCallback$str() {
        return "WELD-001560: Bean builder {0} does not define a destroy lifecycle callback.";
    }
    @Override
    public final DefinitionException beanBuilderInvalidDestroyCallback(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(beanBuilderInvalidDestroyCallback$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanBuilderInvalidBeanManager$str() {
        return "WELD-001561: Bean builder {0} does not define a BeanManager.";
    }
    @Override
    public final DefinitionException beanBuilderInvalidBeanManager(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(beanBuilderInvalidBeanManager$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String producerMethodReturnTypeInvalidTypeVariable$str() {
        return "WELD-001562: A producer method return type may not be a type variable or an array type whose component type is a type variable: \n  {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException producerMethodReturnTypeInvalidTypeVariable(final Object param1, final String stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(producerMethodReturnTypeInvalidTypeVariable$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String producerFieldTypeInvalidTypeVariable$str() {
        return "WELD-001563: A producer field type may not be a type variable or an array type whose component type is a type variable: \n  {0}\n\tat {1}\n  StackTrace:";
    }
    @Override
    public final DefinitionException producerFieldTypeInvalidTypeVariable(final Object param1, final String stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(producerFieldTypeInvalidTypeVariable$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String statelessSessionBeanInjectionPointMetadataNotAvailable$str() {
        return "WELD-001564: Injection point metadata injected into a stateless session bean may only be accessed within its business method invocation";
    }
    @Override
    public final IllegalStateException statelessSessionBeanInjectionPointMetadataNotAvailable() {
        final IllegalStateException result = new IllegalStateException(statelessSessionBeanInjectionPointMetadataNotAvailable$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noInterceptionFunction$str() {
        return "WELD-001565: Interceptor builder {0} does not define an interception function.";
    }
    @Override
    public final DefinitionException noInterceptionFunction(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(noInterceptionFunction$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noInterceptionType$str() {
        return "WELD-001566: Interceptor builder {0} does not define any InterceptionType.";
    }
    @Override
    public final DefinitionException noInterceptionType(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(noInterceptionType$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCreateContextualInstanceOfBuilderInterceptor$str() {
        return "WELD-001567: Cannot create contextual instance of {0}";
    }
    @Override
    public final IllegalStateException cannotCreateContextualInstanceOfBuilderInterceptor(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(cannotCreateContextualInstanceOfBuilderInterceptor$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateClassFile$str() {
        return "WELD-001568: Unable to create ClassFile for: {1}.";
    }
    @Override
    public final IllegalStateException unableToCreateClassFile(final Object name, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToCreateClassFile$str(), name), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotInjectInjectionPointMetadataIntoNonDependent$str() {
        return "WELD-001569: Cannot inject injection point metadata in a non @Dependent bean: {0}";
    }
    @Override
    public final IllegalArgumentException cannotInjectInjectionPointMetadataIntoNonDependent(final Object bean) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(cannotInjectInjectionPointMetadataIntoNonDependent$str(), bean));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noCallbackSpecifiedForCustomBean$str() {
        return "WELD-001570: Invalid BeanConfigurator setup - no callback was specified for {0}";
    }
    @Override
    public final IllegalStateException noCallbackSpecifiedForCustomBean(final Object bean) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(noCallbackSpecifiedForCustomBean$str(), bean));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void generatingProxyToDefaultPackage(final Object param1, final Object param2, final Object param3) {
        super.log.logv(FQCN, INFO, null, generatingProxyToDefaultPackage$str(), param1, param2, param3);
    }
    protected String generatingProxyToDefaultPackage$str() {
        return "WELD-001571: Proxy for {0} created in {1} because {2}.";
    }
    protected String initABDnotInvoked$str() {
        return "WELD-001572: Cannot create instance of session bean from Annotated Type {0} before AfterDeploymentValidation phase.";
    }
    @Override
    public final CreationException initABDnotInvoked(final Object bean) {
        final CreationException result = new CreationException(_formatMessage(initABDnotInvoked$str(), bean));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotObtainHandlerContextualReference$str() {
        return "WELD-001573: Cannot obtain contextual reference for {0} - producing WeldInstance does not exist anymore";
    }
    @Override
    public final IllegalStateException cannotObtainHandlerContextualReference(final Object handler) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(cannotObtainHandlerContextualReference$str(), handler));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void cannotDestroyHandlerContextualReference(final Object handler) {
        super.log.logv(FQCN, WARN, null, cannotDestroyHandlerContextualReference$str(), handler);
    }
    protected String cannotDestroyHandlerContextualReference$str() {
        return "WELD-001574: Cannot destroy contextual instance for {0} - producing WeldInstance does not exist anymore";
    }
    protected String selectByTypeOnlyWorksOnObject$str() {
        return "WELD-001575: WeldInstance.select(Type subtype, Annotation... qualifiers) can be invoked only on an instance of WeldInstance<Object>.";
    }
    @Override
    public final IllegalStateException selectByTypeOnlyWorksOnObject() {
        final IllegalStateException result = new IllegalStateException(selectByTypeOnlyWorksOnObject$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void creatingProxyInstanceUsingDifferentInstantiator(final Object proxyClass, final Object newInstantiator, final Object oldInstantiator) {
        super.log.logv(FQCN, DEBUG, null, creatingProxyInstanceUsingDifferentInstantiator$str(), proxyClass, newInstantiator, oldInstantiator);
    }
    protected String creatingProxyInstanceUsingDifferentInstantiator$str() {
        return "WELD-001576: Using {1} to instantiate a shared proxy class {0}; the deployment implementation [{2}] does not match the instantiator the proxy was created with";
    }
    @Override
    public final void privateFinalMethodOnInterceptedBean(final Object beanClass, final Object method) {
        super.log.logv(FQCN, INFO, null, privateFinalMethodOnInterceptedBean$str(), beanClass, method);
    }
    protected String privateFinalMethodOnInterceptedBean$str() {
        return "WELD-001577: Detected private final method: {1}\non an intercepted bean: {0}\nWeld will ignore this method during interception.";
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
