package org.jboss.weld.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.weld.contexts.NonexistentConversationException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.weld.contexts.BusyConversationException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-10-14T10:47:09+0200")
public class ConversationLogger_$logger extends DelegatingBasicLogger implements ConversationLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConversationLogger_$logger.class.getName();
    public ConversationLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cleaningUpConversation(final Object param1) {
        super.log.logv(FQCN, TRACE, null, cleaningUpConversation$str(), param1);
    }
    protected String cleaningUpConversation$str() {
        return "WELD-000304: Cleaning up conversation {0}";
    }
    @Override
    public final void conversationLocked(final Object param1) {
        super.log.logv(FQCN, TRACE, null, conversationLocked$str(), param1);
    }
    protected String conversationLocked$str() {
        return "WELD-000313: Lock acquired on conversation {0}";
    }
    @Override
    public final void conversationUnlocked(final Object param1) {
        super.log.logv(FQCN, TRACE, null, conversationUnlocked$str(), param1);
    }
    protected String conversationUnlocked$str() {
        return "WELD-000314: Lock released on conversation {0}";
    }
    @Override
    public final void conversationUnavailable(final Object param1, final Object param2) {
        super.log.logv(FQCN, WARN, null, conversationUnavailable$str(), param1, param2);
    }
    protected String conversationUnavailable$str() {
        return "WELD-000315: Failed to acquire conversation lock in {0} ms for {1}";
    }
    @Override
    public final void illegalConversationUnlockAttempt(final Object param1, final Object param2) {
        super.log.logv(FQCN, WARN, null, illegalConversationUnlockAttempt$str(), param1, param2);
    }
    protected String illegalConversationUnlockAttempt$str() {
        return "WELD-000316: Attempt to release lock on conversation {0} failed because {1}";
    }
    @Override
    public final void promotedTransientConversation(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, promotedTransientConversation$str(), param1);
    }
    protected String promotedTransientConversation$str() {
        return "WELD-000317: Promoted conversation {0} to long-running";
    }
    @Override
    public final void demotedLongRunningConversation(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, demotedLongRunningConversation$str(), param1);
    }
    protected String demotedLongRunningConversation$str() {
        return "WELD-000318: Returned long-running conversation {0} to transient";
    }
    @Override
    public final void cleaningUpTransientConversation() {
        super.log.logf(FQCN, TRACE, null, cleaningUpTransientConversation$str());
    }
    protected String cleaningUpTransientConversation$str() {
        return "WELD-000320: Cleaning up transient conversation";
    }
    protected String noConversationFoundToRestore$str() {
        return "WELD-000321: No conversation found to restore for id {0}";
    }
    @Override
    public final NonexistentConversationException noConversationFoundToRestore(final Object param1) {
        final NonexistentConversationException result = new NonexistentConversationException(_formatMessage(noConversationFoundToRestore$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String conversationLockTimedout$str() {
        return "WELD-000322: Conversation lock timed out: {0}";
    }
    @Override
    public final BusyConversationException conversationLockTimedout(final Object param1) {
        final BusyConversationException result = new BusyConversationException(_formatMessage(conversationLockTimedout$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void foundConversationFromRequest(final Object param1) {
        super.log.logv(FQCN, TRACE, null, foundConversationFromRequest$str(), param1);
    }
    protected String foundConversationFromRequest$str() {
        return "WELD-000326: Found conversation id {0} in request parameter";
    }
    @Override
    public final void resumingConversation(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, resumingConversation$str(), param1);
    }
    protected String resumingConversation$str() {
        return "WELD-000327: Resuming conversation with id {0}";
    }
    protected String beginCalledOnLongRunningConversation$str() {
        return "WELD-000328: Attempt to call begin() on a long-running conversation";
    }
    @Override
    public final IllegalStateException beginCalledOnLongRunningConversation() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), beginCalledOnLongRunningConversation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String endCalledOnTransientConversation$str() {
        return "WELD-000329: Attempt to call end() on a transient conversation";
    }
    @Override
    public final IllegalStateException endCalledOnTransientConversation() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), endCalledOnTransientConversation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conversationIdAlreadyInUse$str() {
        return "WELD-000332: Conversation ID {0} is already in use";
    }
    @Override
    public final IllegalArgumentException conversationIdAlreadyInUse(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(conversationIdAlreadyInUse$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mustCallAssociateBeforeActivate$str() {
        return "WELD-000333: Must call associate() before calling activate()";
    }
    @Override
    public final IllegalStateException mustCallAssociateBeforeActivate() {
        final IllegalStateException result = new IllegalStateException(mustCallAssociateBeforeActivate$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mustCallAssociateBeforeDeactivate$str() {
        return "WELD-000334: Must call associate() before calling deactivate()";
    }
    @Override
    public final IllegalStateException mustCallAssociateBeforeDeactivate() {
        final IllegalStateException result = new IllegalStateException(mustCallAssociateBeforeDeactivate$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void contextAlreadyActive(final Object request) {
        super.log.logv(FQCN, WARN, null, contextAlreadyActive$str(), request);
    }
    protected String contextAlreadyActive$str() {
        return "WELD-000335: Conversation context is already active, most likely it was not cleaned up properly during previous request processing: {0}";
    }
    protected String contextNotActive$str() {
        return "WELD-000336: Conversation context is not active";
    }
    @Override
    public final IllegalStateException contextNotActive() {
        final IllegalStateException result = new IllegalStateException(contextNotActive$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conversationNamingSchemeNotFound$str() {
        return "WELD-000337: Unable to find ConversationNamingScheme in the request, this conversation wasn't transient at the start of the request";
    }
    @Override
    public final IllegalStateException conversationNamingSchemeNotFound() {
        final IllegalStateException result = new IllegalStateException(conversationNamingSchemeNotFound$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conversationIdGeneratorNotFound$str() {
        return "WELD-000338: Unable to locate ConversationIdGenerator";
    }
    @Override
    public final IllegalStateException conversationIdGeneratorNotFound() {
        final IllegalStateException result = new IllegalStateException(conversationIdGeneratorNotFound$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mustCallAssociateBeforeGeneratingId$str() {
        return "WELD-000339: A request must be associated with the context in order to generate a conversation id";
    }
    @Override
    public final IllegalStateException mustCallAssociateBeforeGeneratingId() {
        final IllegalStateException result = new IllegalStateException(mustCallAssociateBeforeGeneratingId$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mustCallAssociateBeforeLoadingKnownConversations$str() {
        return "WELD-000340: A request must be associated with the context in order to load the known conversations";
    }
    @Override
    public final IllegalStateException mustCallAssociateBeforeLoadingKnownConversations() {
        final IllegalStateException result = new IllegalStateException(mustCallAssociateBeforeLoadingKnownConversations$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToLoadConversations$str() {
        return "WELD-000341: Unable to load the conversations from the associated request - {0}: {1}, request: {2}";
    }
    @Override
    public final IllegalStateException unableToLoadConversations(final String attributeName, final Object attributeValue, final Object request) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToLoadConversations$str(), attributeName, attributeValue, request));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void endLockedConversation(final String cid) {
        super.log.logv(FQCN, WARN, null, endLockedConversation$str(), cid);
    }
    protected String endLockedConversation$str() {
        return "WELD-000342: Going to end a locked conversation with id {0}";
    }
    protected String unableToLoadCurrentConversation$str() {
        return "WELD-000343: Unable to load the current conversation from the associated request - {0}: {1}, request: {2}";
    }
    @Override
    public final IllegalStateException unableToLoadCurrentConversation(final String attributeName, final Object attributeValue, final Object request) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToLoadCurrentConversation$str(), attributeName, attributeValue, request));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
