package org.jboss.weld.probe;

import java.util.Locale;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-10-14T10:49:22+0200")
public class ProbeLogger_$logger extends DelegatingBasicLogger implements ProbeLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ProbeLogger_$logger.class.getName();
    public ProbeLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void catchingTrace(final Throwable throwable) {
        super.log.logf(FQCN, TRACE, throwable, catchingTrace$str());
    }
    protected String catchingTrace$str() {
        return "Catching";
    }
    @Override
    public final void resourceMatched(final Object resource, final String pathInfo) {
        super.log.logv(FQCN, DEBUG, null, resourceMatched$str(), resource, pathInfo);
    }
    protected String resourceMatched$str() {
        return "PROBE-000001: Resource {0} matched for {1}";
    }
    @Override
    public final void processingBeanDeploymentArchive(final Object archive) {
        super.log.logv(FQCN, INFO, null, processingBeanDeploymentArchive$str(), archive);
    }
    protected String processingBeanDeploymentArchive$str() {
        return "PROBE-000002: Processing bean deployment archive: {0}";
    }
    @Override
    public final void introspectionProblem(final Object bean, final Throwable cause) {
        super.log.logv(FQCN, WARN, cause, introspectionProblem$str(), bean);
    }
    protected String introspectionProblem$str() {
        return "PROBE-000003: A problem occured during contextual instance introspection: {0}";
    }
    @Override
    public final void filtersApplied(final Object filters) {
        super.log.logv(FQCN, DEBUG, null, filtersApplied$str(), filters);
    }
    protected String filtersApplied$str() {
        return "PROBE-000004: Filters applied: {0}";
    }
    protected String probeNotInitialized$str() {
        return "PROBE-000005: Probe is not properly initialized";
    }
    @Override
    public final IllegalStateException probeNotInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), probeNotInitialized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void invocationMonitorNotAssociatedExcluded(final Object beanClass) {
        super.log.logv(FQCN, DEBUG, null, invocationMonitorNotAssociatedExcluded$str(), beanClass);
    }
    protected String invocationMonitorNotAssociatedExcluded$str() {
        return "PROBE-000006: {0} not monitored - excluded";
    }
    @Override
    public final void developmentModeEnabled() {
        super.log.logf(FQCN, WARN, null, developmentModeEnabled$str());
    }
    protected String developmentModeEnabled$str() {
        return "PROBE-000008: \n=====================================\n Weld Development Mode: ENABLED\n ------------------------------------\n Disable this mode in production - it may have negative impact on performance and/or represent a potential security risk\n=====================================";
    }
    @Override
    public final void monitoringStereotypeAdded(final Object bean) {
        super.log.logv(FQCN, DEBUG, null, monitoringStereotypeAdded$str(), bean);
    }
    protected String monitoringStereotypeAdded$str() {
        return "PROBE-000009: @MonitoredComponent stereotype added to {0}";
    }
    @Override
    public final void invocationMonitorNotAssociatedNonProxyableType(final Object type) {
        super.log.logv(FQCN, DEBUG, null, invocationMonitorNotAssociatedNonProxyableType$str(), type);
    }
    protected String invocationMonitorNotAssociatedNonProxyableType$str() {
        return "PROBE-000010: {0} not monitored - non-proxyable type";
    }
    @Override
    public final void eventExcluded(final Object type) {
        super.log.logv(FQCN, DEBUG, null, eventExcluded$str(), type);
    }
    protected String eventExcluded$str() {
        return "PROBE-000011: Event {0} not monitored - excluded";
    }
    @Override
    public final void monitoringLimitExceeded(final Object monitor, final Object limit) {
        super.log.logv(FQCN, DEBUG, null, monitoringLimitExceeded$str(), monitor, limit);
    }
    protected String monitoringLimitExceeded$str() {
        return "PROBE-000012: {0} monitoring limit {1} exceed - some old data were removed";
    }
    protected String probeFilterUnableToOperate$str() {
        return "PROBE-000013: Probe filter is not able to operate - missing {0}";
    }
    @Override
    public final IllegalStateException probeFilterUnableToOperate(final Class<?> component) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(probeFilterUnableToOperate$str(), component));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    protected String unableToRegisterMBean$str() {
        return "PROBE-000014: Cannot register a Probe MBean {0} for: {1}";
    }
    @Override
    public final IllegalStateException unableToRegisterMBean(final Object mbean, final Object context, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToRegisterMBean$str(), mbean, context), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToUnregisterMBean$str() {
        return "PROBE-000015: Cannot unregister a Probe MBean {0} for: {1}";
    }
    @Override
    public final IllegalStateException unableToUnregisterMBean(final Object mbean, final Object context, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToUnregisterMBean$str(), mbean, context), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToParseQueryFilter$str() {
        return "PROBE-000016: Unable to parse query filters: {0}";
    }
    @Override
    public final IllegalArgumentException unableToParseQueryFilter(final Object filters) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(unableToParseQueryFilter$str(), filters));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void requestDenied(final Object requestInfo, final Object remoteAddr) {
        super.log.logv(FQCN, WARN, null, requestDenied$str(), requestInfo, remoteAddr);
    }
    protected String requestDenied$str() {
        return "PROBE-000017: Access to {0} denied for {1}";
    }
    @Override
    public final void invalidExportPath(final Object path) {
        super.log.logv(FQCN, WARN, null, invalidExportPath$str(), path);
    }
    protected String invalidExportPath$str() {
        return "PROBE-000018: Export path does not exist or is not writable: {0}";
    }
    @Override
    public final void unableToExportData(final Object path, final Object cause) {
        super.log.logv(FQCN, WARN, null, unableToExportData$str(), path, cause);
    }
    protected String unableToExportData$str() {
        return "PROBE-000019: Unable to export data to {0}: {1}";
    }
    @Override
    public final void aroundConstructMonitoringProblem(final Object bean, final Throwable cause) {
        super.log.logv(FQCN, WARN, cause, aroundConstructMonitoringProblem$str(), bean);
    }
    protected String aroundConstructMonitoringProblem$str() {
        return "PROBE-000020: A problem occured during monitoring of bean instance construction: {0}";
    }
    @Override
    public final void validationReportExported(final Object path) {
        super.log.logv(FQCN, WARN, null, validationReportExported$str(), path);
    }
    protected String validationReportExported$str() {
        return "PROBE-000021: \n=====================================\n Weld - Deployment Validation: FAILED \n ------------------------------------\n HTML report generated to: \n\n {0} \n=====================================";
    }
    @Override
    public final void cannotUseUnifiedAnnotationToStringConversion(final Object path) {
        super.log.logv(FQCN, WARN, null, cannotUseUnifiedAnnotationToStringConversion$str(), path);
    }
    protected String cannotUseUnifiedAnnotationToStringConversion$str() {
        return "PROBE-000022: Probe was not allowed to use customized Annotation toString(), falling back to JDK's default Annotation.toString(). The exception was: {0}";
    }
}
