/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.InterceptionDecorationContext;
import org.jboss.weld.interceptor.WeldInvocationContext;
import org.jboss.weld.interceptor.proxy.InterceptorMethodInvocation;
import org.jboss.weld.interceptor.proxy.SimpleInvocationContext;
import org.jboss.weld.logging.InterceptorLogger;
import org.jboss.weld.util.ForwardingInvocationContext;
import org.jboss.weld.util.Preconditions;

public class WeldInvocationContextImpl
extends ForwardingInvocationContext
implements WeldInvocationContext {
    private int position;
    private final List<InterceptorMethodInvocation> chain;
    private final CombinedInterceptorAndDecoratorStackMethodHandler currentHandler;
    private final InvocationContext delegate;
    private final Set<Annotation> interceptorBindings;

    public WeldInvocationContextImpl(Constructor<?> constructor, Object[] parameters, Map<String, Object> contextData, List<InterceptorMethodInvocation> chain, Set<Annotation> interceptorBindings) {
        this(new SimpleInvocationContext(constructor, parameters, contextData, interceptorBindings), chain, interceptorBindings, null);
    }

    public WeldInvocationContextImpl(Object target, Method targetMethod, Method proceed, Object[] parameters, List<InterceptorMethodInvocation> chain, Set<Annotation> interceptorBindings, InterceptionDecorationContext.Stack stack) {
        this(new SimpleInvocationContext(target, targetMethod, proceed, parameters, interceptorBindings), chain, interceptorBindings, stack == null ? null : stack.peek());
    }

    public WeldInvocationContextImpl(InvocationContext delegate, List<InterceptorMethodInvocation> chain, Set<Annotation> interceptorBindings, CombinedInterceptorAndDecoratorStackMethodHandler currentHandler) {
        this.delegate = delegate;
        this.chain = chain;
        this.currentHandler = currentHandler;
        this.interceptorBindings = interceptorBindings == null ? Collections.emptySet() : interceptorBindings;
        this.getContextData().put("org.jboss.weld.interceptor.bindings", interceptorBindings);
    }

    @Override
    protected InvocationContext delegate() {
        return this.delegate;
    }

    public boolean hasNextInterceptor() {
        return this.position < this.chain.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeNext() throws Exception {
        int oldCurrentPosition = this.position;
        try {
            InterceptorMethodInvocation nextInterceptorMethodInvocation = this.chain.get(this.position++);
            InterceptorLogger.LOG.invokingNextInterceptorInChain(nextInterceptorMethodInvocation);
            if (nextInterceptorMethodInvocation.expectsInvocationContext()) {
                Object object = nextInterceptorMethodInvocation.invoke(this);
                return object;
            }
            nextInterceptorMethodInvocation.invoke(null);
            while (this.hasNextInterceptor()) {
                nextInterceptorMethodInvocation = this.chain.get(this.position++);
                nextInterceptorMethodInvocation.invoke(null);
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            this.position = oldCurrentPosition;
        }
    }

    protected Object interceptorChainCompleted() throws Exception {
        return this.delegate().proceed();
    }

    @Override
    public Object proceed() throws Exception {
        InterceptionDecorationContext.Stack stack = null;
        if (this.currentHandler != null && this.position != 0) {
            stack = InterceptionDecorationContext.startIfNotOnTop(this.currentHandler);
        }
        try {
            if (this.hasNextInterceptor()) {
                Object object = this.invokeNext();
                return object;
            }
            Object object = this.interceptorChainCompleted();
            return object;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
        finally {
            if (stack != null) {
                stack.end();
            }
        }
    }

    @Override
    public <T extends Annotation> Set<T> getInterceptorBindingsByType(Class<T> annotationType) {
        Preconditions.checkArgumentNotNull(annotationType, "annotationType");
        HashSet<Annotation> result = new HashSet<Annotation>();
        for (Annotation interceptorBinding : this.interceptorBindings) {
            if (!interceptorBinding.annotationType().equals(annotationType)) continue;
            result.add(interceptorBinding);
        }
        return result;
    }

    @Override
    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindings;
    }
}

