package org.jboss.weld.logging;

import java.util.Locale;
import jakarta.enterprise.context.spi.Context;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.DeploymentException;
import java.lang.Class;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-12-16T14:48:43+0100")
public class ContextLogger_$logger extends DelegatingBasicLogger implements ContextLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ContextLogger_$logger.class.getName();
    public ContextLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void contextualInstanceFound(final Object param1, final Object param2, final Object param3) {
        super.log.logv(FQCN, TRACE, null, contextualInstanceFound$str(), param1, param2, param3);
    }
    protected String contextualInstanceFound$str() {
        return "WELD-000200: Looked for {0} and got {1} in {2}";
    }
    @Override
    public final void contextCleared(final Object param1) {
        super.log.logv(FQCN, TRACE, null, contextCleared$str(), param1);
    }
    protected String contextCleared$str() {
        return "WELD-000201: Context {0} cleared";
    }
    @Override
    public final void contextualInstanceAdded(final Object param1, final Object param2, final Object param3) {
        super.log.logv(FQCN, TRACE, null, contextualInstanceAdded$str(), param1, param2, param3);
    }
    protected String contextualInstanceAdded$str() {
        return "WELD-000202: Added {0} with key {1} to {2}";
    }
    @Override
    public final void contextualInstanceRemoved(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, contextualInstanceRemoved$str(), param1, param2);
    }
    protected String contextualInstanceRemoved$str() {
        return "WELD-000203: Removed {0} from {1}";
    }
    protected String delimiterInPrefix$str() {
        return "WELD-000211: The delimiter \"{0}\" should not be in the prefix \"{1}\"";
    }
    @Override
    public final IllegalArgumentException delimiterInPrefix(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(delimiterInPrefix$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String contextualIsNull$str() {
        return "WELD-000212: No contextual specified to retrieve (null)";
    }
    @Override
    public final IllegalArgumentException contextualIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), contextualIsNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noBeanStoreAvailable$str() {
        return "WELD-000213: No bean store available for {0}";
    }
    @Override
    public final IllegalStateException noBeanStoreAvailable(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(noBeanStoreAvailable$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void beanStoreDetached(final Object param1) {
        super.log.logv(FQCN, TRACE, null, beanStoreDetached$str(), param1);
    }
    protected String beanStoreDetached$str() {
        return "WELD-000215: Bean store {0} is detached";
    }
    @Override
    public final void updatingStoreWithContextualUnderId(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, updatingStoreWithContextualUnderId$str(), param1, param2);
    }
    protected String updatingStoreWithContextualUnderId$str() {
        return "WELD-000216: Updating underlying store with contextual {0} under ID {1}";
    }
    @Override
    public final void addingDetachedContextualUnderId(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, addingDetachedContextualUnderId$str(), param1, param2);
    }
    protected String addingDetachedContextualUnderId$str() {
        return "WELD-000217: Adding detached contextual {0} under ID {1}";
    }
    @Override
    public final void removedKeyFromSession(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, removedKeyFromSession$str(), param1, param2);
    }
    protected String removedKeyFromSession$str() {
        return "WELD-000218: Removed {0} from session {1}";
    }
    @Override
    public final void unableToRemoveKeyFromSession(final Object param1) {
        super.log.logv(FQCN, TRACE, null, unableToRemoveKeyFromSession$str(), param1);
    }
    protected String unableToRemoveKeyFromSession$str() {
        return "WELD-000219: Unable to remove {0} from non-existent session";
    }
    @Override
    public final void addedKeyToSession(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, addedKeyToSession$str(), param1, param2);
    }
    protected String addedKeyToSession$str() {
        return "WELD-000220: Added {0} to session {1}";
    }
    @Override
    public final void unableToAddKeyToSession(final Object param1) {
        super.log.logv(FQCN, TRACE, null, unableToAddKeyToSession$str(), param1);
    }
    protected String unableToAddKeyToSession$str() {
        return "WELD-000221: Unable to add {0} to session as no session could be obtained";
    }
    @Override
    public final void loadingBeanStoreMapFromSession(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, loadingBeanStoreMapFromSession$str(), param1, param2);
    }
    protected String loadingBeanStoreMapFromSession$str() {
        return "WELD-000222: Loading bean store {0} map from session {1}";
    }
    protected String contextHasNullScope$str() {
        return "WELD-000223: Context.getScope() returned null for {0}";
    }
    @Override
    public final DefinitionException contextHasNullScope(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(contextHasNullScope$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unableToClearBeanStore(final Object beanStore) {
        super.log.logv(FQCN, WARN, null, unableToClearBeanStore$str(), beanStore);
    }
    protected String unableToClearBeanStore$str() {
        return "WELD-000224: Unable to clear the bean store {0}.";
    }
    @Override
    public final void beanStoreLeakDuringAssociation(final Object context, final Object info) {
        super.log.logv(FQCN, WARN, null, beanStoreLeakDuringAssociation$str(), context, info);
    }
    protected String beanStoreLeakDuringAssociation$str() {
        return "WELD-000225: Bean store leak detected during {0} association: {1}";
    }
    protected String cannotRegisterContext$str() {
        return "WELD-000226: Cannot register additional context for scope: {0}, {1}";
    }
    @Override
    public final DeploymentException cannotRegisterContext(final Class<? extends java.lang.annotation.Annotation> scope, final Context context) {
        final DeploymentException result = new DeploymentException(_formatMessage(cannotRegisterContext$str(), scope, context));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanIdentifierIndexInconsistencyDetected$str() {
        return "WELD-000227: Bean identifier index inconsistency detected - the distributed container probably does not work with identical applications\nExpected hash: {0}\nCurrent index: {1}";
    }
    @Override
    public final IllegalStateException beanIdentifierIndexInconsistencyDetected(final Object hash, final Object index) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(beanIdentifierIndexInconsistencyDetected$str(), hash, index));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void beanStoreLeakAffectedBeanIdentifiers(final Object context, final Object identifiers) {
        super.log.logv(FQCN, DEBUG, null, beanStoreLeakAffectedBeanIdentifiers$str(), context, identifiers);
    }
    protected String beanStoreLeakAffectedBeanIdentifiers$str() {
        return "WELD-000228: Bean store leak detected during {0} association - instances of beans with the following identifiers might not be destroyed correctly: {1}";
    }
    protected String contextualReferenceNotValidAfterShutdown$str() {
        return "WELD-000229: Contextual reference of {0} is not valid after container {1} shutdown";
    }
    @Override
    public final IllegalStateException contextualReferenceNotValidAfterShutdown(final Object bean, final Object contextId) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(contextualReferenceNotValidAfterShutdown$str(), bean, contextId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
