package org.jboss.weld.logging;

import java.util.Locale;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-12-16T14:48:43+0100")
public class XmlLogger_$logger extends DelegatingBasicLogger implements XmlLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = XmlLogger_$logger.class.getName();
    public XmlLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String configurationError$str() {
        return "WELD-001200: Error configuring XML parser";
    }
    @Override
    public final IllegalStateException configurationError(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configurationError$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String loadError$str() {
        return "WELD-001201: Error loading beans.xml {0}";
    }
    @Override
    public final IllegalStateException loadError(final Object param1, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(loadError$str(), param1), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    protected String parsingError$str() {
        return "WELD-001202: Error parsing {0}";
    }
    @Override
    public final IllegalStateException parsingError(final Object param1, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(parsingError$str(), param1), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleAlternatives$str() {
        return "WELD-001203: <alternatives> can only be specified once, but appears multiple times:  {0}";
    }
    @Override
    public final DefinitionException multipleAlternatives(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(multipleAlternatives$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleDecorators$str() {
        return "WELD-001204: <decorators> can only be specified once, but is specified multiple times:  {0}";
    }
    @Override
    public final DefinitionException multipleDecorators(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(multipleDecorators$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleInterceptors$str() {
        return "WELD-001205: <interceptors> can only be specified once, but it is specified multiple times:  {0}";
    }
    @Override
    public final DefinitionException multipleInterceptors(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(multipleInterceptors$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleScanning$str() {
        return "WELD-001207: <scan> can only be specified once, but it is specified multiple times:  {0}";
    }
    @Override
    public final DefinitionException multipleScanning(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(multipleScanning$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void xsdValidationError(final Object param1, final Object param2, final Object param3) {
        super.log.logv(FQCN, WARN, null, xsdValidationError$str(), param1, param2, param3);
    }
    protected String xsdValidationError$str() {
        return "WELD-001208: Error when validating {0}@{1} against xsd. {2}";
    }
    @Override
    public final void xsdValidationWarning(final Object param1, final Object param2, final Object param3) {
        super.log.logv(FQCN, WARN, null, xsdValidationWarning$str(), param1, param2, param3);
    }
    protected String xsdValidationWarning$str() {
        return "WELD-001210: Warning when validating {0}@{1} against xsd. {2}";
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
