/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.weld.bean;

import java.util.List;

import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Decorator;

/**
 * Marker interface for a {@link Bean} that can have decorators. This can be a {@link ManagedBean}, {@link SessionBean} or a
 * built-in {@link Bean}.
 *
 * @author Jozef Hartinger
 *
 */
public interface DecorableBean<T> extends Bean<T> {

    /**
     * Resolves decorators for this bean.
     */
    List<Decorator<?>> getDecorators();
}
