package org.jboss.weld.lite.extension.translator.logging;

import java.util.Locale;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Class;
import java.lang.Object;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class LiteExtensionTranslatorLogger_$logger extends DelegatingBasicLogger implements LiteExtensionTranslatorLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LiteExtensionTranslatorLogger_$logger.class.getName();
    public LiteExtensionTranslatorLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unableToInstantiateObject$str() {
        return "Unable to instantiate object from class {0} via no-args constructor. The exception was: {1}";
    }
    @Override
    public final IllegalStateException unableToInstantiateObject(final Class<?> classToInstantiate, final String exception) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToInstantiateObject$str(), classToInstantiate, exception));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unexpectedMethodArgument$str() {
        return "LITE-EXTENSION-TRANSLATOR-000001: Unexpected extension method argument: {0}";
    }
    @Override
    public final IllegalArgumentException unexpectedMethodArgument(final Object argument) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(unexpectedMethodArgument$str(), argument));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMethodParameter$str() {
        return "LITE-EXTENSION-TRANSLATOR-000002: {0} methods can't declare a parameter of type {1}, found at {2}. Method name - {3}";
    }
    @Override
    public final IllegalArgumentException invalidMethodParameter(final Object phaseString, final Object paramTypeString, final Object declaringClassName, final Object methodName) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidMethodParameter$str(), phaseString, paramTypeString, declaringClassName, methodName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownDeclaration$str() {
        return "LITE-EXTENSION-TRANSLATOR-000003: Unknown declaration {0}";
    }
    @Override
    public final IllegalArgumentException unknownDeclaration(final Object cdiDeclaration) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(unknownDeclaration$str(), cdiDeclaration));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingObservesAnnotation$str() {
        return "LITE-EXTENSION-TRANSLATOR-000004: Observer method without an @Observes parameter: {0}";
    }
    @Override
    public final IllegalStateException missingObservesAnnotation(final Object cdiDeclaration) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(missingObservesAnnotation$str(), cdiDeclaration));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownPrimitiveType$str() {
        return "LITE-EXTENSION-TRANSLATOR-000005: Unknown primitive type: {0}";
    }
    @Override
    public final IllegalArgumentException unknownPrimitiveType(final Object typeFound) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(unknownPrimitiveType$str(), typeFound));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incorrectParameterCount$str() {
        return "LITE-EXTENSION-TRANSLATOR-000006: Zero or more than one parameter of type {0} for method {1} with declaring class {2}";
    }
    @Override
    public final DefinitionException incorrectParameterCount(final String validParameterTypes, final Object method, final Object declaringClass) {
        final DefinitionException result = new DefinitionException(_formatMessage(incorrectParameterCount$str(), validParameterTypes, method, declaringClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownQueryParameter$str() {
        return "LITE-EXTENSION-TRANSLATOR-000007: Unknown query parameter: {0}";
    }
    @Override
    public final IllegalStateException unknownQueryParameter(final Object query) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unknownQueryParameter$str(), query));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInvokeExtensionMethod$str() {
        return "LITE-EXTENSION-TRANSLATOR-000008: Unable to invoke extension method {0} with arguments {1}. The exception was: {2}";
    }
    @Override
    public final IllegalStateException unableToInvokeExtensionMethod(final Object method, final Object arguments, final String exception) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToInvokeExtensionMethod$str(), method, arguments, exception));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotLoadClassByName$str() {
        return "LITE-EXTENSION-TRANSLATOR-000009: Unable to load class with name {0}. The exception was: {1}";
    }
    @Override
    public final IllegalStateException cannotLoadClassByName(final Object className, final String exception) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(cannotLoadClassByName$str(), className, exception));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidExtensionMethodParameterType$str() {
        return "LITE-EXTENSION-TRANSLATOR-000010: Unrecognized parameter of type {0} declared in class {1}#{2}";
    }
    @Override
    public final IllegalArgumentException invalidExtensionMethodParameterType(final Object type, final Object declaringClass, final Object methodName) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidExtensionMethodParameterType$str(), type, declaringClass, methodName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownReflectionType$str() {
        return "LITE-EXTENSION-TRANSLATOR-000011: Unknown reflection type {0}";
    }
    @Override
    public final IllegalArgumentException unknownReflectionType(final Object reflectionType) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(unknownReflectionType$str(), reflectionType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownAnnotationMember$str() {
        return "LITE-EXTENSION-TRANSLATOR-000012: Unknown annotation member {0}";
    }
    @Override
    public final IllegalArgumentException unknownAnnotationMember(final Object annotationMember) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(unknownAnnotationMember$str(), annotationMember));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String kindNotEqual$str() {
        return "LITE-EXTENSION-TRANSLATOR-000013: Not {0}:{1}";
    }
    @Override
    public final IllegalArgumentException kindNotEqual(final Object kind, final Object value) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(kindNotEqual$str(), kind, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToAccessAnnotationMembers$str() {
        return "LITE-EXTENSION-TRANSLATOR-000014: Unable to access annotation member(s) for annotation {0}. The exception was: {1}";
    }
    @Override
    public final DefinitionException unableToAccessAnnotationMembers(final Object annotation, final String exception) {
        final DefinitionException result = new DefinitionException(_formatMessage(unableToAccessAnnotationMembers$str(), annotation, exception));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalAnnotationMemberType$str() {
        return "LITE-EXTENSION-TRANSLATOR-000015: Provided type {0} is illegal because it doesn't match an of known annotation member types.";
    }
    @Override
    public final IllegalArgumentException illegalAnnotationMemberType(final Object type) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(illegalAnnotationMemberType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void annotationFactoryInstanceNotInitialized() {
        super.log.logv(FQCN, WARN, null, annotationFactoryInstanceNotInitialized$str());
    }
    protected String annotationFactoryInstanceNotInitialized$str() {
        return "LITE-EXTENSION-TRANSLATOR-000016: AnnotationBuilderFactoryImpl wasn't initialized properly before using it. This can be caused by attempted usage outside of build compatible extension cycle. The init process will use a fallback method.";
    }
    protected String problemExecutingExtensionMethod$str() {
        return "LITE-EXTENSION-TRANSLATOR-000017: There was a problem executing Build Compatible Extension method {0} during phase {1}. The exception was: {2}";
    }
    @Override
    public final DeploymentException problemExecutingExtensionMethod(final Object method, final Object phase, final String exception) {
        final DeploymentException result = new DeploymentException(_formatMessage(problemExecutingExtensionMethod$str(), method, phase, exception));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
