package org.jboss.weld.logging;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class ElLogger_$logger extends DelegatingBasicLogger implements ElLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElLogger_$logger.class.getName();
    public ElLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String nullExpressionFactory$str() {
        return "WELD-001001: Cannot pass null expressionFactory";
    }
    @Override
    public final IllegalArgumentException nullExpressionFactory() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullExpressionFactory$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void propertyLookup(final Object param1) {
        super.log.logv(FQCN, TRACE, null, propertyLookup$str(), param1);
    }
    protected String propertyLookup$str() {
        return "WELD-001002: Looking for EL property {0}";
    }
    @Override
    public final void propertyResolved(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, propertyResolved$str(), param1, param2);
    }
    protected String propertyResolved$str() {
        return "WELD-001003: EL property {0} resolved to {1}";
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
