package org.jboss.weld.logging;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.logging.Logger;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class InvokerLogger_$logger extends DelegatingBasicLogger implements InvokerLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = InvokerLogger_$logger.class.getName();
    public InvokerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String tbd$str() {
        return "WELD-002000: TBD {0}";
    }
    @Override
    public final IllegalArgumentException tbd(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(tbd$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
