/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import org.jboss.weld.probe.Components;
import org.jboss.weld.probe.Json;
import org.jboss.weld.probe.JsonDataProvider;
import org.jboss.weld.probe.Queries;

class ExportFileJsonDataProvider
implements JsonDataProvider {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final Logger LOGGER = Logger.getLogger(ExportFileJsonDataProvider.class.getName());
    private final String deploymentJson;
    private final JsonArray contexts;
    private final Map<String, JsonElement> contextsMap = new HashMap<String, JsonElement>();
    private final Map<String, String> bdasMap = new HashMap<String, String>();
    private final JsonArray beans;
    private final JsonArray observers;
    private final JsonArray events;
    private final JsonArray invocations;

    ExportFileJsonDataProvider(File exportFile) {
        try (ZipFile zip = new ZipFile(exportFile);){
            JsonElement contextsElement;
            this.deploymentJson = this.readToString(zip, "deployment.json");
            JsonElement deploymentElement = this.readToJson(zip, "deployment.json");
            if (deploymentElement != null) {
                deploymentElement.getAsJsonObject().get("bdas").getAsJsonArray().forEach(bda -> this.bdasMap.put(bda.getAsJsonObject().get("id").getAsString(), bda.getAsJsonObject().get("bdaId").getAsString()));
            }
            this.contexts = (contextsElement = this.readToJson(zip, "contexts.json")) != null ? contextsElement.getAsJsonArray() : new JsonArray();
            for (JsonElement ctx : this.contexts) {
                JsonElement ctxDataElement = this.readToJson(zip, "context-" + ctx.getAsJsonObject().get("id").getAsString() + ".json");
                if (ctxDataElement == null) continue;
                this.contextsMap.put(ctx.getAsJsonObject().get("id").getAsString(), ctxDataElement);
            }
            this.beans = this.readDataToJson(zip, "beans.json");
            this.observers = this.readDataToJson(zip, "observers.json");
            this.events = this.readDataToJson(zip, "fired-events.json");
            this.invocations = this.readDataToJson(zip, "invocation-trees.json");
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load export file: " + exportFile, e);
        }
    }

    public String receiveDeployment() {
        return this.deploymentJson;
    }

    public String receiveBeans(int pageIndex, int pageSize, String filters, String representation) {
        Queries.Page page = Queries.find(StreamSupport.stream(this.beans.spliterator(), false).map(element -> element.getAsJsonObject()).collect(Collectors.toList()), (int)pageIndex, (int)pageSize, (Queries.Filters)Queries.initFilters((String)filters, (Queries.Filters)new ExportBeanFilters(this.bdasMap)));
        JsonArray data = new JsonArray();
        page.getData().forEach(bean -> data.add((JsonElement)bean));
        return this.encodePage((Queries.Page<JsonObject>)page, data);
    }

    public String receiveBean(String id, boolean transientDependencies, boolean transientDependents) {
        for (JsonElement bean : this.beans) {
            JsonElement dependencies;
            JsonElement dependents;
            JsonElement idElement = bean.getAsJsonObject().get("id");
            if (idElement == null || !idElement.getAsString().equals(id)) continue;
            if (!transientDependents && (dependents = bean.getAsJsonObject().get("dependents")) != null) {
                dependents.getAsJsonArray().forEach(dependent -> dependent.getAsJsonObject().remove("dependents"));
            }
            if (!transientDependencies && (dependencies = bean.getAsJsonObject().get("dependencies")) != null) {
                dependencies.getAsJsonArray().forEach(dependency -> dependency.getAsJsonObject().remove("dependencies"));
            }
            return bean.toString();
        }
        throw new IllegalStateException("No bean found for: " + id);
    }

    public String receiveBeanInstance(String id) {
        throw new UnsupportedOperationException();
    }

    public String receiveObservers(int pageIndex, int pageSize, String filters, String representation) {
        Queries.Page page = Queries.find(StreamSupport.stream(this.observers.spliterator(), false).map(element -> element.getAsJsonObject()).collect(Collectors.toList()), (int)pageIndex, (int)pageSize, (Queries.Filters)Queries.initFilters((String)filters, (Queries.Filters)new ExportObserversFilters(this.bdasMap)));
        JsonArray data = new JsonArray();
        page.getData().forEach(bean -> data.add((JsonElement)bean));
        return this.encodePage((Queries.Page<JsonObject>)page, data);
    }

    public String receiveObserver(String id) {
        for (JsonElement observer : this.observers) {
            JsonElement idElement = observer.getAsJsonObject().get("id");
            if (idElement == null || !idElement.getAsString().equals(id)) continue;
            return observer.toString();
        }
        throw new IllegalStateException("No observer found for: " + id);
    }

    public String receiveContexts() {
        return this.contexts.toString();
    }

    public String receiveContext(String id) {
        return this.contextsMap.containsKey(id) ? this.contextsMap.get(id).toString() : new JsonObject().toString();
    }

    public String receiveInvocations(int pageIndex, int pageSize, String filters, String representation) {
        Queries.Page page = Queries.find(StreamSupport.stream(this.invocations.spliterator(), false).map(element -> element.getAsJsonObject()).collect(Collectors.toList()), (int)pageIndex, (int)pageSize, (Queries.Filters)Queries.initFilters((String)filters, (Queries.Filters)new ExportInvocationsFilters()));
        JsonArray data = new JsonArray();
        page.getData().forEach(bean -> data.add((JsonElement)bean));
        return this.encodePage((Queries.Page<JsonObject>)page, data);
    }

    public String clearInvocations() {
        throw new UnsupportedOperationException();
    }

    public String receiveInvocation(String id) {
        for (JsonElement invocation : this.invocations) {
            JsonElement idElement = invocation.getAsJsonObject().get("id");
            if (idElement == null || !idElement.getAsString().equals(id)) continue;
            return invocation.toString();
        }
        throw new IllegalStateException("No invocation found for: " + id);
    }

    public String receiveEvents(int pageIndex, int pageSize, String filters) {
        Queries.Page page = Queries.find(StreamSupport.stream(this.events.spliterator(), false).map(element -> element.getAsJsonObject()).collect(Collectors.toList()), (int)pageIndex, (int)pageSize, (Queries.Filters)Queries.initFilters((String)filters, (Queries.Filters)new ExportEventsFilters()));
        JsonArray data = new JsonArray();
        page.getData().forEach(bean -> data.add((JsonElement)bean));
        return this.encodePage((Queries.Page<JsonObject>)page, data);
    }

    public String clearEvents() {
        throw new UnsupportedOperationException();
    }

    public String receiveMonitoringStats() {
        return Json.objectBuilder().add("fired", Integer.valueOf(this.events.size())).add("invocations", Integer.valueOf(this.invocations.size())).build();
    }

    public String receiveAvailableBeans(int pageIndex, int pageSize, String filters, String representation) {
        throw new UnsupportedOperationException();
    }

    private String encodePage(Queries.Page<JsonObject> page, JsonArray data) {
        JsonObject pageData = new JsonObject();
        pageData.addProperty("page", (Number)page.getIdx());
        pageData.addProperty("lastPage", (Number)page.getLastIdx());
        pageData.addProperty("total", (Number)page.getTotal());
        pageData.add("data", (JsonElement)data);
        return pageData.toString();
    }

    private String readToString(ZipFile zip, String zipEntryName) throws IOException {
        ZipEntry entry = zip.getEntry(zipEntryName);
        if (entry != null) {
            return ExportFileJsonDataProvider.readToString(new InputStreamReader(zip.getInputStream(entry), StandardCharsets.UTF_8), 2048);
        }
        this.jsonDataNotAvailable(zipEntryName);
        return null;
    }

    private JsonElement readToJson(ZipFile zip, String zipEntryName) throws IOException {
        ZipEntry entry = zip.getEntry(zipEntryName);
        if (entry != null) {
            return new JsonParser().parse((Reader)new InputStreamReader(zip.getInputStream(entry), StandardCharsets.UTF_8));
        }
        this.jsonDataNotAvailable(zipEntryName);
        return null;
    }

    private JsonArray readDataToJson(ZipFile zip, String zipEntryName) throws IOException {
        JsonElement element = this.readToJson(zip, zipEntryName);
        return element != null ? element.getAsJsonObject().get("data").getAsJsonArray() : new JsonArray();
    }

    private void jsonDataNotAvailable(String zipEntryName) {
        LOGGER.warning(zipEntryName + " data not available");
    }

    private static String readToString(Reader input, int bufferSize) throws IOException {
        return ExportFileJsonDataProvider.readToString(input, bufferSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readToString(Reader input, int bufferSize, boolean close) throws IOException {
        StringBuilder builder = new StringBuilder();
        try {
            ExportFileJsonDataProvider.copy(input, builder, bufferSize);
        }
        finally {
            if (close) {
                input.close();
            }
        }
        return builder.toString();
    }

    private static void copy(Readable in, Appendable out, int bufferSize) throws IOException {
        CharBuffer buffer = CharBuffer.allocate(bufferSize);
        while (in.read(buffer) != -1) {
            buffer.flip();
            out.append(buffer);
            buffer.clear();
        }
    }

    static class ExportBeanFilters
    extends ExportFilters {
        private Components.BeanKind kind;
        private String beanClass;
        private String beanType;
        private String qualifier;
        private String scope;
        private String bda;
        private Boolean isAlternative;
        private String stereotypes;
        private Boolean unused;

        ExportBeanFilters(Map<String, String> bdasMap) {
            super(bdasMap);
        }

        boolean test(JsonObject bean) {
            return this.testEquals(this.kind, bean.has("kind") ? Components.BeanKind.from((String)bean.get("kind").getAsString()) : null) && this.testEquals(this.unused, bean.has("unused") ? Boolean.valueOf(bean.get("unused").getAsBoolean()) : null) && this.testEquals(this.isAlternative, bean.has("isAlternative") ? Boolean.valueOf(bean.get("isAlternative").getAsBoolean()) : null) && this.testBda(this.bda, bean) && this.testContainsIgnoreCase(this.beanClass, bean.has("beanClass") ? bean.get("beanClass").getAsString() : "") && this.testContainsIgnoreCase(this.scope, bean.has("scope") ? bean.get("scope").getAsString() : "") && this.testArrayContains(this.beanType, bean.has("types") ? bean.get("types").getAsJsonArray() : null) && this.testArrayContains(this.qualifier, bean.has("qualifiers") ? bean.get("qualifiers").getAsJsonArray() : null) && this.testArrayContains(this.stereotypes, bean.has("stereotypes") ? bean.get("stereotypes").getAsJsonArray() : null);
        }

        void processFilter(String name, String value) {
            if ("kind".equals(name)) {
                this.kind = Components.BeanKind.from((String)value);
            } else if ("beanClass".equals(name)) {
                this.beanClass = value;
            } else if ("beanType".equals(name)) {
                this.beanType = value;
            } else if ("qualifier".equals(name)) {
                this.qualifier = value;
            } else if ("scope".equals(name)) {
                this.scope = value;
            } else if ("bda".equals(name)) {
                this.bda = value;
            } else if ("isAlternative".equals(name)) {
                this.isAlternative = Boolean.valueOf(value);
            } else if ("stereotypes".equals(name)) {
                this.stereotypes = value;
            } else if ("unused".equals(name)) {
                this.unused = Boolean.valueOf(value);
            }
        }

        public String toString() {
            return String.format("ExportBeanFilters [kind=%s, beanClass=%s, beanType=%s, qualifier=%s, scope=%s, bda=%s, isAlternative=%s, stereotypes=%s, unused=%s]", this.kind, this.beanClass, this.beanType, this.qualifier, this.scope, this.bda, this.isAlternative, this.stereotypes, this.unused);
        }

        boolean isEmpty() {
            return this.kind == null && this.beanClass == null && this.beanType == null && this.qualifier == null && this.scope == null && this.bda == null && this.isAlternative == null && this.stereotypes == null && this.unused == false;
        }
    }

    static class ExportObserversFilters
    extends ExportFilters {
        private String beanClass;
        private String observedType;
        private String qualifier;
        private Reception reception;
        private TransactionPhase txPhase;
        private Components.BeanKind declaringBeanKind;
        private String bda;

        ExportObserversFilters(Map<String, String> bdasMap) {
            super(bdasMap);
        }

        boolean test(JsonObject observer) {
            return this.testBda(this.bda, observer.has("declaringBean") ? observer.get("declaringBean").getAsJsonObject() : null) && this.testContainsIgnoreCase(this.beanClass, observer.has("beanClass") ? observer.get("beanClass").getAsString() : "") && this.testArrayContains(this.qualifier, observer.has("qualifiers") ? observer.get("qualifiers").getAsJsonArray() : null) && this.testEquals(this.declaringBeanKind, observer.has("declaringBean") ? Components.BeanKind.from((String)observer.get("declaringBean").getAsJsonObject().get("kind").getAsString()) : null) && this.testEquals(this.reception, this.getReception(observer)) && this.testEquals(this.txPhase, this.getTransactionPhase(observer)) && this.testContainsIgnoreCase(this.observedType, observer.has("observedType") ? observer.get("observedType").getAsString() : "");
        }

        void processFilter(String name, String value) {
            if ("kind".equals(name)) {
                this.declaringBeanKind = Components.BeanKind.from((String)value);
            } else if ("beanClass".equals(name)) {
                this.beanClass = value;
            } else if ("observedType".equals(name)) {
                this.observedType = value;
            } else if ("qualifier".equals(name)) {
                this.qualifier = value;
            } else if ("reception".equals(name)) {
                for (Reception recept : Reception.values()) {
                    if (!recept.toString().equals(value)) continue;
                    this.reception = recept;
                }
            } else if ("txPhase".equals(name)) {
                for (TransactionPhase phase : TransactionPhase.values()) {
                    if (!phase.toString().equals(value)) continue;
                    this.txPhase = phase;
                }
            } else if ("bda".equals(name)) {
                this.bda = value;
            }
        }

        private Reception getReception(JsonObject observer) {
            if (observer.has("reception")) {
                for (Reception reception : Reception.values()) {
                    if (!reception.toString().equals(observer.get("reception").getAsString())) continue;
                    return reception;
                }
            }
            return null;
        }

        private TransactionPhase getTransactionPhase(JsonObject observer) {
            if (observer.has("txPhase")) {
                for (TransactionPhase phase : TransactionPhase.values()) {
                    if (!phase.toString().equals(observer.get("txPhase").getAsString())) continue;
                    return phase;
                }
            }
            return null;
        }

        public String toString() {
            return String.format("ExportObserversFilters [beanClass=%s, observedType=%s, qualifier=%s, reception=%s, txPhase=%s, declaringBeanKind=%s, bda=%s]", this.beanClass, this.observedType, this.qualifier, this.reception, this.txPhase, this.declaringBeanKind, this.bda);
        }

        boolean isEmpty() {
            return this.beanClass == null && this.observedType == null && this.qualifier == null && this.reception == null && this.bda == null && this.txPhase == null && this.declaringBeanKind == null;
        }
    }

    static class ExportInvocationsFilters
    extends ExportFilters {
        private String beanClass;
        private String methodName;
        private String search;
        private String description;

        ExportInvocationsFilters() {
            super(null);
        }

        boolean test(JsonObject invocation) {
            String beanClassValue = "";
            if (this.beanClass != null) {
                if (invocation.has("declaringClass")) {
                    beanClassValue = invocation.get("declaringClass").getAsString();
                } else if (invocation.has("interceptedBean")) {
                    beanClassValue = invocation.get("interceptedBean").getAsJsonObject().get("beanClass").getAsString();
                }
            }
            return this.testSearch(this.search, invocation) && this.testContainsIgnoreCase(this.beanClass, beanClassValue) && this.testContainsIgnoreCase(this.methodName, invocation.has("methodName") ? invocation.get("methodName").getAsString() : "") && this.testContainsIgnoreCase(this.description, invocation.has("description") ? invocation.get("description").getAsString() : "");
        }

        void processFilter(String name, String value) {
            if ("beanClass".equals(name)) {
                this.beanClass = value;
            } else if ("methodName".equals(name)) {
                this.methodName = value;
            } else if ("search".equals(name)) {
                this.search = value;
            } else if ("description".equals(name)) {
                this.description = value;
            }
        }

        boolean testSearch(String search, JsonObject invocation) {
            if (search == null) {
                return true;
            }
            if (this.containsIgnoreCase(search, invocation.has("beanClass") ? invocation.get("beanClass").getAsString() : null) || this.containsIgnoreCase(search, invocation.has("methodName") ? invocation.get("methodName").getAsString() : null)) {
                return true;
            }
            if (invocation.has("children")) {
                for (JsonElement child : invocation.get("children").getAsJsonArray()) {
                    if (!this.testSearch(search, child.getAsJsonObject())) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return String.format("ExportInvocationsFilters [beanClass=%s, methodName=%s, search=%s, description=%s]", this.beanClass, this.methodName, this.search, this.description);
        }

        boolean isEmpty() {
            return this.beanClass == null && this.methodName == null && this.search == null && this.description == null;
        }
    }

    static class ExportEventsFilters
    extends ExportFilters {
        private Boolean container;
        private String eventInfo;
        private String type;
        private String qualifiers;

        ExportEventsFilters() {
            super(null);
        }

        boolean test(JsonObject event) {
            return this.testContainsIgnoreCase(this.eventInfo, event.has("eventInfo") ? event.get("eventInfo").getAsString() : "") && this.testContainsIgnoreCase(this.type, event.has("type") ? event.get("type").getAsString() : "") && this.testArrayContains(this.qualifiers, event.has("qualifiers") ? event.get("qualifiers").getAsJsonArray() : null) && this.testEquals(this.container, event.has("kind") ? Boolean.valueOf(event.get("kind").getAsString().equalsIgnoreCase("container")) : null);
        }

        void processFilter(String name, String value) {
            if ("eventInfo".equals(name)) {
                this.eventInfo = value;
            } else if ("type".equals(name)) {
                this.type = value;
            } else if ("qualifiers".equals(name)) {
                this.qualifiers = value;
            } else if ("kind".equals(name)) {
                if ("container".equalsIgnoreCase(value)) {
                    this.container = true;
                } else if ("application".equalsIgnoreCase(value)) {
                    this.container = false;
                }
            }
        }

        public String toString() {
            return String.format("ExportEventsFilters [container=%s, eventInfo=%s, type=%s, qualifiers=%s]", this.container, this.eventInfo, this.type, this.qualifiers);
        }

        boolean isEmpty() {
            return this.container == null && this.eventInfo == null && this.type == null && this.qualifiers == null;
        }
    }

    static abstract class ExportFilters
    extends Queries.Filters<JsonObject> {
        private final Map<String, String> bdasMap;

        public ExportFilters(Map<String, String> bdasMap) {
            super(null);
            this.bdasMap = bdasMap;
        }

        protected boolean testArrayContains(String filter, JsonArray values) {
            if (filter == null) {
                return true;
            }
            if (values != null) {
                for (JsonElement value : values) {
                    if (!this.testContainsIgnoreCase(filter, value.getAsString())) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean testBda(String bda, JsonObject value) {
            if (bda == null) {
                return true;
            }
            if (value == null || !value.has("bdaId")) {
                return false;
            }
            if ("probe-filterAdditionalBdas".equals(bda)) {
                return !this.bdasMap.get(value.get("bdaId").getAsString()).endsWith(".additionalClasses");
            }
            return value.get("bdaId").getAsString().equals(bda);
        }
    }
}

