/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import org.jboss.weld.probe.ExportFileJsonDataProvider;
import org.jboss.weld.probe.JsonDataProvider;
import org.jboss.weld.probe.SimpleProbeFilter;

public class ProbeClientAdapter {
    static final String SYSTEM_PROPERTY_JMX_SERVICE_URL = "org.jboss.weld.probe.jmxServiceUrl";
    static final String SYSTEM_PROPERTY_UT_HOST = "org.jboss.weld.probe.undertowHost";
    static final String SYSTEM_PROPERTY_UT_PORT = "org.jboss.weld.probe.undertowPort";
    static final String PROBE_CLIENT_ADAPTER_APP = "probe-client-adapter";
    static final String PROBE_FILTER_NAME = "Weld Probe Filter";
    static final String DEFAULT_JMX_SERVICE_URL = "service:jmx:rmi:///jndi/rmi://127.0.0.1:9999/jmxrmi";
    private final File exportFile;
    private final String undertowHost;
    private final int undertowPort;
    private final Console console;
    private List<ObjectName> names;
    private Undertow undertow;
    private MBeanServerConnection connection;
    private Integer currentIndex;

    public static void main(String[] args) {
        File exportFile = null;
        if (args.length == 1 && !(exportFile = new File(args[0])).canRead()) {
            throw new IllegalStateException("Export file does not exist or is not readable");
        }
        new ProbeClientAdapter(exportFile, System.getProperty(SYSTEM_PROPERTY_UT_HOST, "127.0.0.1"), Integer.valueOf(System.getProperty(SYSTEM_PROPERTY_UT_PORT, "8181"))).start();
    }

    ProbeClientAdapter(File exportFile, String undertowHost, int undertowPort) {
        this.exportFile = exportFile;
        this.undertowHost = undertowHost;
        this.undertowPort = undertowPort;
        this.console = new Console();
    }

    void start() {
        if (this.exportFile != null) {
            System.out.println("Loading data from an export file: " + this.exportFile);
            this.startProcessing();
        } else {
            String jmxServiceUrl = System.getProperty(SYSTEM_PROPERTY_JMX_SERVICE_URL, DEFAULT_JMX_SERVICE_URL);
            System.out.println("Connecting to a remote JMX server: " + jmxServiceUrl);
            try (JMXConnector jmxc = JMXConnectorFactory.connect(new JMXServiceURL(jmxServiceUrl), null);){
                ObjectName queryName;
                this.connection = jmxc.getMBeanServerConnection();
                try {
                    queryName = new ObjectName(JsonDataProvider.class.getPackage().getName() + ":type=JsonData,context=*");
                }
                catch (MalformedObjectNameException e) {
                    throw new RuntimeException(e);
                }
                this.names = new ArrayList<ObjectName>(this.connection.queryNames(queryName, null));
                if (this.names.isEmpty()) {
                    System.err.println("No Weld containers with Probe JMX enabled");
                    System.exit(1);
                }
                this.startProcessing();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not connect to a remote JMX server", e);
            }
        }
    }

    private void startProcessing() {
        String command = "c";
        do {
            this.processCommand(command);
        } while (!this.isExit(command = this.commandPrompt()));
        this.stopUndertow();
    }

    private void processCommand(String command) {
        if ("c".equals(command) || "connect".equals(command)) {
            if (this.exportFile != null) {
                this.currentIndex = 0;
                this.restart(new ExportFileJsonDataProvider(this.exportFile));
            } else {
                Integer index;
                String indexStr = this.selectionPrompt();
                if (this.isExit(indexStr)) {
                    this.stopUndertow();
                    System.exit(0);
                }
                while ((index = this.parseIndexStr(indexStr)) == null || index > this.names.size() || index < 0) {
                    indexStr = this.selectionPrompt();
                }
                this.currentIndex = index;
                this.reconnect(index, this.names.get(index));
            }
        } else if ("h".equals(command) || "help".equals(command)) {
            System.out.println("Help - available commands: ");
            System.out.println("'e' or 'exit' to exit?");
            System.out.println("'c' or 'connect' to connect/reconnect to a Weld container");
            System.out.println("'h' or 'help' to show this help");
        } else {
            System.out.println("Connected to the Weld container [" + this.currentIndex + "]: " + (this.exportFile != null ? this.exportFile : (Serializable)this.names.get(this.currentIndex)));
        }
    }

    private boolean isExit(String command) {
        return "e".equals(command) || "exit".equals(command);
    }

    private String commandPrompt() {
        StringBuilder prompt = new StringBuilder();
        if (this.currentIndex == null) {
            prompt.append("[disconnected");
        } else {
            prompt.append("[connected #");
            prompt.append(this.currentIndex);
        }
        prompt.append("]$ ");
        return this.console.readLine(prompt.toString(), new Object[0]);
    }

    private String selectionPrompt() {
        StringBuilder select = new StringBuilder();
        select.append("Select a Weld container (JSON data provider):");
        select.append(System.lineSeparator());
        ListIterator<ObjectName> iterator = this.names.listIterator();
        while (iterator.hasNext()) {
            select.append("[");
            select.append(iterator.nextIndex());
            select.append("]");
            select.append(" ");
            select.append(iterator.next());
            select.append(System.lineSeparator());
        }
        System.out.println(select);
        return this.commandPrompt();
    }

    private Integer parseIndexStr(String indexStr) {
        try {
            return Integer.valueOf(indexStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void reconnect(Integer index, ObjectName mBeanName) {
        System.out.println("Connecting to the Weld container [" + index + "]: " + mBeanName);
        this.restart(JMX.newMXBeanProxy(this.connection, mBeanName, JsonDataProvider.class));
    }

    private void restart(final JsonDataProvider jsonDataProvider) {
        PathHandler path;
        this.stopUndertow();
        System.out.println("Starting Undertow...");
        DeploymentInfo servletBuilder = Servlets.deployment().setClassLoader(ProbeClientAdapter.class.getClassLoader()).setContextPath("/probe-client-adapter").setDeploymentName("probe-jmx.war").addFilter(Servlets.filter((String)PROBE_FILTER_NAME, SimpleProbeFilter.class, (InstanceFactory)new InstanceFactory<SimpleProbeFilter>(){

            public InstanceHandle<SimpleProbeFilter> createInstance() throws InstantiationException {
                return new ImmediateInstanceHandle((Object)new SimpleProbeFilter(jsonDataProvider));
            }
        })).addFilterUrlMapping(PROBE_FILTER_NAME, "/*", DispatcherType.REQUEST);
        DeploymentManager manager = Servlets.defaultContainer().addDeployment(servletBuilder);
        manager.deploy();
        try {
            path = Handlers.path((HttpHandler)Handlers.redirect((String)PROBE_CLIENT_ADAPTER_APP)).addPrefixPath(PROBE_CLIENT_ADAPTER_APP, manager.start());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.undertow = Undertow.builder().addHttpListener(this.undertowPort, this.undertowHost).setHandler((HttpHandler)path).build();
        this.undertow.start();
        StringBuilder info = new StringBuilder();
        info = new StringBuilder();
        info.append("Weld Probe HTML client available at: http://");
        info.append(this.undertowHost);
        info.append(":");
        info.append(this.undertowPort);
        info.append("/");
        info.append(PROBE_CLIENT_ADAPTER_APP);
        info.append("/weld-probe");
        info.append(System.lineSeparator());
        System.out.println(info);
    }

    private void stopUndertow() {
        if (this.undertow != null) {
            System.out.println("Stopping Undertow...");
            this.undertow.stop();
        }
    }

    private static class Console {
        private final BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        private final PrintStream print = System.out;

        Console() {
        }

        String readLine(String format, Object ... objects) {
            this.format(format, objects);
            try {
                return this.reader.readLine();
            }
            catch (IOException e) {
                return null;
            }
        }

        PrintStream format(String format, Object ... objects) {
            return this.print.format(format, objects);
        }
    }
}

