/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.weld.probe.JsonDataProvider;
import org.jboss.weld.probe.ProbeLogger;
import org.jboss.weld.probe.Resource;

public class SimpleProbeFilter
implements Filter {
    static final String REST_URL_PATTERN_BASE = "/weld-probe";
    static final Logger LOGGER = Logger.getLogger(SimpleProbeFilter.class.getName());
    private JsonDataProvider jsonDataProvider;

    SimpleProbeFilter(JsonDataProvider jsonDataProvider) {
        this.jsonDataProvider = jsonDataProvider;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String[] resourcePathParts = SimpleProbeFilter.getResourcePathParts(httpRequest.getRequestURI(), httpRequest.getServletContext().getContextPath());
        if (resourcePathParts != null) {
            Resource.HttpMethod method = Resource.HttpMethod.from((String)httpRequest.getMethod());
            if (method == null) {
                if (httpRequest.getProtocol().endsWith("1.1")) {
                    httpResponse.sendError(405);
                } else {
                    httpResponse.sendError(400);
                }
                return;
            }
            this.processResourceRequest(httpRequest, httpResponse, method, resourcePathParts);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private void processResourceRequest(HttpServletRequest req, HttpServletResponse resp, Resource.HttpMethod httpMethod, String[] resourcePathParts) throws IOException {
        Resource resource;
        if (resourcePathParts.length == 0) {
            resource = Resource.CLIENT_RESOURCE;
        } else {
            resource = this.matchResource(resourcePathParts);
            if (resource == null) {
                resp.sendError(404);
                return;
            }
        }
        ProbeLogger.LOG.resourceMatched((Object)resource, req.getRequestURI());
        try {
            resource.handle(httpMethod, this.jsonDataProvider, resourcePathParts, req, resp);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Cannot handle " + httpMethod + " for " + resource, e.getCause() != null ? e.getCause() : e);
        }
    }

    private Resource matchResource(String[] resourcePathParts) {
        for (Resource resource : Resource.values()) {
            if (!resource.matches(resourcePathParts)) continue;
            return resource;
        }
        return null;
    }

    static String[] getResourcePathParts(String requestUri, String contextPath) {
        String path = requestUri.substring(contextPath.length(), requestUri.length());
        if (path.startsWith(REST_URL_PATTERN_BASE)) {
            return Resource.splitPath((String)path.substring(REST_URL_PATTERN_BASE.length(), path.length()));
        }
        return null;
    }
}

