/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.util.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import org.jboss.windup.engine.util.xml.NamespaceEntry;

public class NamespaceMapContext
implements NamespaceContext {
    private final Map<String, String> context = new HashMap<String, String>();

    public NamespaceMapContext() {
    }

    public NamespaceMapContext(Map<String, String> in) {
        if (in != null && in.size() > 0) {
            this.context.putAll(in);
        }
    }

    public void addNamespaceEntry(NamespaceEntry entry) {
        this.context.put(entry.getPrefix(), entry.getNamespaceURI());
    }

    public void addPrefix(String prefix, String namespaceURI) {
        this.context.put(prefix, namespaceURI);
    }

    public Set<String> getNamespaceURIs() {
        return new HashSet<String>(this.context.values());
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.context.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        Iterator<String> prefixIterator = this.getPrefixes(namespaceURI);
        if (prefixIterator.hasNext()) {
            return this.getPrefixes(namespaceURI).next();
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        LinkedList<String> prefixes = new LinkedList<String>();
        for (String key : this.context.keySet()) {
            if (!namespaceURI.equals(this.context.get(key))) continue;
            prefixes.add(key);
        }
        return prefixes.iterator();
    }

    public String toString() {
        return "NamespaceMapContext [context=" + this.context + "]";
    }
}

