/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.util.exception.WindupMultiStringException;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class WindupRuleProviderSorter {
    private List<WindupRuleProvider> providers;
    private final IdentityHashMap<Class<? extends WindupRuleProvider>, WindupRuleProvider> classToProviderMap = new IdentityHashMap();
    private final Map<String, WindupRuleProvider> idToProviderMap = new HashMap<String, WindupRuleProvider>();

    private WindupRuleProviderSorter(List<WindupRuleProvider> providers) {
        this.providers = new ArrayList<WindupRuleProvider>(providers);
        this.initializeLookupCaches();
        this.sort();
    }

    public static List<WindupRuleProvider> sort(List<WindupRuleProvider> providers) {
        WindupRuleProviderSorter sorter = new WindupRuleProviderSorter(providers);
        return sorter.getProviders();
    }

    private List<WindupRuleProvider> getProviders() {
        return this.providers;
    }

    private void initializeLookupCaches() {
        for (WindupRuleProvider provider : this.providers) {
            Class<?> unproxiedClass = this.unwrapType(provider.getClass());
            this.classToProviderMap.put(unproxiedClass, provider);
            this.idToProviderMap.put(provider.getID(), provider);
        }
    }

    private void sort() {
        DefaultDirectedWeightedGraph g = new DefaultDirectedWeightedGraph(DefaultEdge.class);
        for (WindupRuleProvider provider : this.providers) {
            g.addVertex((Object)provider);
        }
        this.addProviderRelationships((DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge>)g);
        this.checkForCycles((DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge>)g);
        ArrayList<WindupRuleProvider> result = new ArrayList<WindupRuleProvider>(this.providers.size());
        TopologicalOrderIterator iterator = new TopologicalOrderIterator((DirectedGraph)g);
        while (iterator.hasNext()) {
            WindupRuleProvider provider = (WindupRuleProvider)iterator.next();
            result.add(provider);
        }
        this.providers = Collections.unmodifiableList(result);
        int index = 0;
        for (WindupRuleProvider provider : this.providers) {
            provider.setExecutionIndex(index++);
        }
    }

    private void addProviderRelationships(DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge> g) {
        this.linkRulePhases();
        for (WindupRuleProvider provider : this.providers) {
            WindupRuleProvider otherProvider;
            WindupRuleProvider phaseProvider = this.getByClass(provider.getPhase());
            LinkedList<String> errors = new LinkedList<String>();
            for (Class clz : provider.getExecuteAfter()) {
                this.addExecuteAfterRelationship(g, provider, errors, clz);
            }
            if (phaseProvider != null) {
                if (provider.getPhase() != Proxies.unwrap((Object)provider).getClass()) {
                    this.addExecuteAfterRelationship(g, provider, errors, provider.getPhase());
                }
                for (Class clz : phaseProvider.getExecuteAfter()) {
                    this.addExecuteAfterRelationship(g, provider, errors, clz);
                }
            }
            for (Class clz : provider.getExecuteBefore()) {
                this.addExecuteBeforeRelationship(g, provider, errors, clz);
            }
            if (phaseProvider != null) {
                for (Class clz : phaseProvider.getExecuteBefore()) {
                    this.addExecuteBeforeRelationship(g, provider, errors, clz);
                }
            }
            for (String depID : provider.getExecuteAfterIDs()) {
                otherProvider = this.getByID(depID);
                if (otherProvider == null) {
                    errors.add("RuleProvider " + provider.getID() + " is specified to execute after: " + depID + " but this provider could not be found.");
                    continue;
                }
                g.addEdge((Object)otherProvider, (Object)provider);
            }
            for (String depID : provider.getExecuteBeforeIDs()) {
                otherProvider = this.getByID(depID);
                if (otherProvider == null) {
                    errors.add("RuleProvider " + provider.getID() + " is specified to execute before: " + depID + " but this provider could not be found.");
                    continue;
                }
                g.addEdge((Object)provider, (Object)otherProvider);
            }
            if (errors.isEmpty()) continue;
            throw new WindupMultiStringException("Some rules to be executed before or after were not found:", errors);
        }
    }

    private void linkRulePhases() {
        for (WindupRuleProvider provider : this.providers) {
            if (!(provider instanceof RulePhase)) continue;
            if (provider.getExecuteBefore().isEmpty()) {
                for (WindupRuleProvider otherProvider : this.providers) {
                    if (!(otherProvider instanceof RulePhase) || !otherProvider.getExecuteAfter().contains(Proxies.unwrap((Object)provider).getClass())) continue;
                    ((RulePhase)provider).setExecuteBefore(Proxies.unwrap((Object)((RulePhase)otherProvider)).getClass());
                }
            }
            if (!provider.getExecuteAfter().isEmpty()) continue;
            for (WindupRuleProvider otherProvider : this.providers) {
                if (!(otherProvider instanceof RulePhase) || !otherProvider.getExecuteBefore().contains(Proxies.unwrap((Object)provider).getClass())) continue;
                ((RulePhase)provider).setExecuteAfter(Proxies.unwrap((Object)((RulePhase)otherProvider)).getClass());
            }
        }
    }

    private void addExecuteBeforeRelationship(DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge> g, WindupRuleProvider provider, List<String> errors, Class<? extends WindupRuleProvider> clz) {
        WindupRuleProvider otherProvider = this.getByClass(clz);
        if (otherProvider == null) {
            errors.add("RuleProvider " + provider.getID() + " is specified to execute before: " + clz.getName() + " but this class could not be found.");
        } else {
            g.addEdge((Object)provider, (Object)otherProvider);
        }
    }

    private void addExecuteAfterRelationship(DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge> g, WindupRuleProvider provider, List<String> errors, Class<? extends WindupRuleProvider> clz) {
        WindupRuleProvider otherProvider = this.getByClass(clz);
        if (otherProvider == null) {
            errors.add("RuleProvider " + provider.getID() + " is specified to execute after class: " + clz.getName() + " but this class could not be found.");
        } else {
            g.addEdge((Object)otherProvider, (Object)provider);
        }
    }

    private void checkForCycles(DefaultDirectedWeightedGraph<WindupRuleProvider, DefaultEdge> g) {
        CycleDetector cycleDetector = new CycleDetector(g);
        if (cycleDetector.detectCycles()) {
            Set cycles = cycleDetector.findCycles();
            StringBuilder errorSB = new StringBuilder();
            for (WindupRuleProvider cycle : cycles) {
                errorSB.append("Found dependency cycle involving: " + cycle.getID() + "\n");
                Set subCycleSet = cycleDetector.findCyclesContainingVertex((Object)cycle);
                for (WindupRuleProvider subCycle : subCycleSet) {
                    errorSB.append("\tSubcycle: " + subCycle.getID() + "\n");
                }
            }
            throw new RuntimeException("Dependency cycles detected: " + errorSB.toString());
        }
    }

    private WindupRuleProvider getByClass(Class<? extends WindupRuleProvider> c) {
        return this.classToProviderMap.get(c);
    }

    private WindupRuleProvider getByID(String id) {
        return this.idToProviderMap.get(id);
    }

    private <T> Class<T> unwrapType(Class<T> wrapped) {
        return Proxies.unwrapProxyTypes(wrapped, (ClassLoader[])new ClassLoader[0]);
    }
}

