/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.metadata;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.loader.RuleLoader;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.config.metadata.RuleProviderRegistryCache;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.config.metadata.TechnologyReferenceTransformer;
import org.jboss.windup.util.PathUtil;

@Singleton
public class RuleProviderRegistryCacheImpl
implements RuleProviderRegistryCache {
    private static final Logger LOG = Logger.getLogger(RuleProviderRegistryCache.class.getName());
    private static final long MAX_CACHE_AGE = 60000L;
    private static boolean loadErrorPrinted = false;
    @Inject
    private RuleLoader ruleLoader;
    private Set<Path> userRulesPaths = new LinkedHashSet<Path>();
    private List<TechnologyReferenceTransformer> cachedTransformers;
    private RuleProviderRegistry cachedRegistry;
    private long cacheRefreshTime;

    public void addUserRulesPath(Path path) {
        this.cachedRegistry = null;
        this.cachedTransformers = null;
        this.userRulesPaths.add(path);
    }

    public Set<String> getAvailableTags() {
        HashSet<String> tags = new HashSet<String>();
        RuleProviderRegistry registry = this.getRuleProviderRegistry();
        if (registry == null) {
            return Collections.emptySet();
        }
        for (RuleProvider provider : registry.getProviders()) {
            tags.addAll(provider.getMetadata().getTags());
        }
        return tags;
    }

    public Set<String> getAvailableSourceTechnologies() {
        HashSet<TechnologyReference> sourceOptions = new HashSet<TechnologyReference>();
        RuleProviderRegistry registry = this.getRuleProviderRegistry();
        if (registry == null) {
            return Collections.emptySet();
        }
        for (RuleProvider provider : registry.getProviders()) {
            for (TechnologyReference technologyReference : provider.getMetadata().getSourceTechnologies()) {
                sourceOptions.add(technologyReference);
            }
        }
        this.addTransformers(sourceOptions);
        return sourceOptions.stream().map(TechnologyReference::getId).collect(Collectors.toSet());
    }

    public Set<String> getAvailableTargetTechnologies() {
        HashSet<TechnologyReference> targetOptions = new HashSet<TechnologyReference>();
        RuleProviderRegistry registry = this.getRuleProviderRegistry();
        if (registry == null) {
            return Collections.emptySet();
        }
        for (RuleProvider provider : registry.getProviders()) {
            for (TechnologyReference technologyReference : provider.getMetadata().getTargetTechnologies()) {
                targetOptions.add(technologyReference);
            }
        }
        this.addTransformers(targetOptions);
        return targetOptions.stream().map(TechnologyReference::getId).collect(Collectors.toSet());
    }

    private void addTransformers(Set<TechnologyReference> techs) {
        techs.addAll(this.getTechnologyTransformers().stream().filter(transformer -> {
            for (TechnologyReference originalTech : techs) {
                if (!originalTech.matches(transformer.getTarget())) continue;
                return true;
            }
            return false;
        }).map(TechnologyReferenceTransformer::getOriginal).collect(Collectors.toList()));
    }

    public RuleProviderRegistry getRuleProviderRegistry() {
        if (this.cacheValid()) {
            return this.cachedRegistry;
        }
        this.cachedRegistry = null;
        try {
            HashSet<Path> defaultRulePaths = new HashSet<Path>();
            defaultRulePaths.add(PathUtil.getWindupRulesDir());
            defaultRulePaths.add(PathUtil.getUserRulesDir());
            defaultRulePaths.addAll(this.userRulesPaths);
            RuleLoaderContext ruleLoaderContext = new RuleLoaderContext(defaultRulePaths, null);
            this.getRuleProviderRegistry(ruleLoaderContext);
        }
        catch (Exception e) {
            if (!loadErrorPrinted) {
                System.err.println("Failed to load rule information due to: " + e.getMessage());
                loadErrorPrinted = true;
            }
            LOG.log(Level.WARNING, "Failed to load rule information due to: " + e.getMessage(), e);
        }
        return this.cachedRegistry;
    }

    public RuleProviderRegistry getRuleProviderRegistry(RuleLoaderContext ruleLoaderContext) {
        this.initCaches(ruleLoaderContext);
        return this.cachedRegistry;
    }

    private List<TechnologyReferenceTransformer> getTechnologyTransformers() {
        return this.cachedTransformers;
    }

    private void initCaches(RuleLoaderContext ruleLoaderContext) {
        this.cachedRegistry = this.ruleLoader.loadConfiguration(ruleLoaderContext);
        this.cachedTransformers = TechnologyReferenceTransformer.getTransformers((RuleLoaderContext)ruleLoaderContext);
        this.cacheRefreshTime = System.currentTimeMillis();
    }

    private boolean cacheValid() {
        if (this.cachedRegistry == null) {
            return false;
        }
        long cacheAge = System.currentTimeMillis() - this.cacheRefreshTime;
        return cacheAge < 60000L;
    }
}

