/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser.xml;

import java.util.stream.Collectors;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.config.phase.RulePhaseFinder;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="phase", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class PhaseHandler
implements ElementHandler<Void> {
    private RulePhaseFinder phaseFinder = new RulePhaseFinder();

    @Override
    public Void processElement(ParserContext context, Element element) throws ConfigurationException {
        String phaseStr = element.getTextContent().trim();
        Class phase = this.phaseFinder.findPhase(phaseStr);
        if (phase == null) {
            String phasesListing = this.phaseFinder.getAvailablePhases().stream().map(clazz -> clazz.getSimpleName()).collect(Collectors.joining("\n    "));
            throw new IllegalArgumentException("Unrecognized phase \"" + phaseStr + "\". Available phases: \n    " + phasesListing);
        }
        context.getBuilder().setPhase(phase);
        return null;
    }
}

