/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decompiler.fernflower;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.jar.Manifest;
import org.jboss.windup.decompiler.api.DecompilationListener;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

public class FernFlowerResultSaver
implements IResultSaver {
    private final List<String> sourceClassFiles;
    private final File outputDirectory;
    private final DecompilationListener listener;
    private boolean fileSaved = false;

    public FernFlowerResultSaver(List<String> sourceClassFiles, File outputDir, DecompilationListener listener) {
        this.sourceClassFiles = sourceClassFiles;
        this.outputDirectory = outputDir;
        this.listener = listener;
    }

    public boolean isFileSaved() {
        return this.fileSaved;
    }

    public void saveClassFile(String path, String qualifiedName, String entryName, String content, int[] mapping) {
        block17: {
            File outputFile = new File(this.outputDirectory, qualifiedName + ".java");
            try {
                if (!outputFile.getParentFile().isDirectory()) {
                    outputFile.getParentFile().mkdirs();
                }
                try (FileWriter fw = new FileWriter(outputFile);){
                    fw.write(content);
                }
                if (this.listener != null) {
                    this.listener.fileDecompiled(this.sourceClassFiles, outputFile.toString());
                }
                this.fileSaved = true;
            }
            catch (IOException t) {
                if (this.listener == null) break block17;
                this.listener.decompilationFailed(this.sourceClassFiles, t.getMessage());
            }
        }
    }

    public void saveFolder(String path) {
    }

    public void copyFile(String source, String path, String entryName) {
    }

    public void createArchive(String path, String archiveName, Manifest manifest) {
    }

    public void saveDirEntry(String path, String archiveName, String entryName) {
    }

    public void copyEntry(String source, String path, String archiveName, String entry) {
    }

    public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content) {
    }

    public void closeArchive(String path, String archiveName) {
    }
}

