/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.sforms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.util.FastSparseSetFactory;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.SFormsFastMapDirect;

public class SSAConstructorSparseEx {
    private final HashMap<String, SFormsFastMapDirect> inVarVersions = new HashMap();
    private final HashMap<String, SFormsFastMapDirect> outVarVersions = new HashMap();
    private final HashMap<String, SFormsFastMapDirect> outNegVarVersions = new HashMap();
    private final HashMap<String, SFormsFastMapDirect> extraVarVersions = new HashMap();
    private final HashMap<VarVersionPair, FastSparseSetFactory.FastSparseSet<Integer>> phi = new HashMap();
    private final HashMap<Integer, Integer> lastversion = new HashMap();
    private final List<VarVersionPair> startVars = new ArrayList<VarVersionPair>();
    private FastSparseSetFactory<Integer> factory;

    public void splitVariables(RootStatement root, StructMethod mt) {
        FlattenStatementsHelper flatthelper = new FlattenStatementsHelper();
        DirectGraph dgraph = flatthelper.buildDirectGraph(root);
        HashSet<Integer> setInit = new HashSet<Integer>();
        for (int i = 0; i < 64; ++i) {
            setInit.add(i);
        }
        this.factory = new FastSparseSetFactory(setInit);
        SFormsFastMapDirect firstmap = this.createFirstMap(mt);
        this.extraVarVersions.put(dgraph.first.id, firstmap);
        this.setCatchMaps(root, dgraph, flatthelper);
        HashSet<String> updated = new HashSet<String>();
        do {
            this.ssaStatements(dgraph, updated);
        } while (!updated.isEmpty());
    }

    private void ssaStatements(DirectGraph dgraph, HashSet<String> updated) {
        for (DirectNode node : dgraph.nodes) {
            boolean this_updated;
            updated.remove(node.id);
            this.mergeInVarMaps(node, dgraph);
            SFormsFastMapDirect varmap = this.inVarVersions.get(node.id);
            varmap = new SFormsFastMapDirect(varmap);
            SFormsFastMapDirect[] varmaparr = new SFormsFastMapDirect[]{varmap, null};
            if (node.exprents != null) {
                for (Exprent expr : node.exprents) {
                    this.processExprent(expr, varmaparr);
                }
            }
            if (varmaparr[1] == null) {
                varmaparr[1] = varmaparr[0];
            }
            if (!(this_updated = !SSAConstructorSparseEx.mapsEqual(varmaparr[0], this.outVarVersions.get(node.id)) || this.outNegVarVersions.containsKey(node.id) && !SSAConstructorSparseEx.mapsEqual(varmaparr[1], this.outNegVarVersions.get(node.id)))) continue;
            this.outVarVersions.put(node.id, varmaparr[0]);
            if (dgraph.mapNegIfBranch.containsKey(node.id)) {
                this.outNegVarVersions.put(node.id, varmaparr[1]);
            }
            for (DirectNode nd : node.succs) {
                updated.add(nd.id);
            }
        }
    }

    private void processExprent(Exprent expr, SFormsFastMapDirect[] varmaparr) {
        if (expr == null) {
            return;
        }
        VarExprent varassign = null;
        boolean finished = false;
        block0 : switch (expr.type) {
            case 2: {
                AssignmentExprent assexpr = (AssignmentExprent)expr;
                if (assexpr.getCondType() != -1) break;
                Exprent dest = assexpr.getLeft();
                if (dest.type != 12) break;
                varassign = (VarExprent)dest;
                break;
            }
            case 6: {
                FunctionExprent func = (FunctionExprent)expr;
                switch (func.getFuncType()) {
                    case 36: {
                        SFormsFastMapDirect varmapFalse;
                        this.processExprent(func.getLstOperands().get(0), varmaparr);
                        if (varmaparr[1] == null) {
                            varmapFalse = new SFormsFastMapDirect(varmaparr[0]);
                        } else {
                            varmapFalse = varmaparr[1];
                            varmaparr[1] = null;
                        }
                        this.processExprent(func.getLstOperands().get(1), varmaparr);
                        SFormsFastMapDirect[] varmaparrNeg = new SFormsFastMapDirect[]{varmapFalse, null};
                        this.processExprent(func.getLstOperands().get(2), varmaparrNeg);
                        SSAConstructorSparseEx.mergeMaps(varmaparr[0], varmaparrNeg[0]);
                        varmaparr[1] = null;
                        finished = true;
                        break block0;
                    }
                    case 48: {
                        this.processExprent(func.getLstOperands().get(0), varmaparr);
                        SFormsFastMapDirect[] varmaparrAnd = new SFormsFastMapDirect[]{new SFormsFastMapDirect(varmaparr[0]), null};
                        this.processExprent(func.getLstOperands().get(1), varmaparrAnd);
                        varmaparr[1] = SSAConstructorSparseEx.mergeMaps(varmaparr[varmaparr[1] == null ? 0 : 1], varmaparrAnd[varmaparrAnd[1] == null ? 0 : 1]);
                        varmaparr[0] = varmaparrAnd[0];
                        finished = true;
                        break block0;
                    }
                    case 49: {
                        this.processExprent(func.getLstOperands().get(0), varmaparr);
                        SFormsFastMapDirect[] varmaparrOr = new SFormsFastMapDirect[]{new SFormsFastMapDirect(varmaparr[varmaparr[1] == null ? 0 : 1]), null};
                        this.processExprent(func.getLstOperands().get(1), varmaparrOr);
                        varmaparr[1] = varmaparrOr[varmaparrOr[1] == null ? 0 : 1];
                        varmaparr[0] = SSAConstructorSparseEx.mergeMaps(varmaparr[0], varmaparrOr[0]);
                        finished = true;
                    }
                }
            }
        }
        if (finished) {
            return;
        }
        List<Exprent> lst = expr.getAllExprents();
        lst.remove(varassign);
        for (Exprent ex : lst) {
            this.processExprent(ex, varmaparr);
        }
        SFormsFastMapDirect varmap = varmaparr[0];
        if (varassign != null) {
            Integer varindex = varassign.getIndex();
            if (varassign.getVersion() == 0) {
                Integer nextver = this.getNextFreeVersion(varindex);
                varassign.setVersion(nextver);
                this.setCurrentVar(varmap, varindex, nextver);
            } else {
                this.setCurrentVar(varmap, varindex, varassign.getVersion());
            }
        } else if (expr.type == 12) {
            VarExprent vardest = (VarExprent)expr;
            Integer varindex = vardest.getIndex();
            FastSparseSetFactory.FastSparseSet<Integer> vers = varmap.get(varindex);
            int cardinality = vers.getCardinality();
            if (cardinality == 1) {
                Integer it = vers.iterator().next();
                vardest.setVersion(it);
            } else if (cardinality == 2) {
                Integer current_vers = vardest.getVersion();
                VarVersionPair currpaar = new VarVersionPair(varindex, current_vers);
                if (current_vers != 0 && this.phi.containsKey(currpaar)) {
                    this.setCurrentVar(varmap, varindex, current_vers);
                    this.phi.get(currpaar).union(vers);
                } else {
                    Integer nextver = this.getNextFreeVersion(varindex);
                    vardest.setVersion(nextver);
                    this.setCurrentVar(varmap, varindex, nextver);
                    this.phi.put(new VarVersionPair(varindex, nextver), vers);
                }
            }
        }
    }

    private Integer getNextFreeVersion(Integer var) {
        Integer nextver = this.lastversion.get(var);
        nextver = nextver == null ? new Integer(1) : new Integer(nextver + 1);
        this.lastversion.put(var, nextver);
        return nextver;
    }

    private void mergeInVarMaps(DirectNode node, DirectGraph dgraph) {
        SFormsFastMapDirect mapNew = new SFormsFastMapDirect();
        for (DirectNode pred : node.preds) {
            SFormsFastMapDirect mapOut = this.getFilteredOutMap(node.id, pred.id, dgraph, node.id);
            if (mapNew.isEmpty()) {
                mapNew = mapOut.getCopy();
                continue;
            }
            SSAConstructorSparseEx.mergeMaps(mapNew, mapOut);
        }
        if (this.extraVarVersions.containsKey(node.id)) {
            SFormsFastMapDirect mapExtra = this.extraVarVersions.get(node.id);
            if (mapNew.isEmpty()) {
                mapNew = mapExtra.getCopy();
            } else {
                SSAConstructorSparseEx.mergeMaps(mapNew, mapExtra);
            }
        }
        this.inVarVersions.put(node.id, mapNew);
    }

    private SFormsFastMapDirect getFilteredOutMap(String nodeid, String predid, DirectGraph dgraph, String destid) {
        boolean isFinallyExit;
        SFormsFastMapDirect mapNew = new SFormsFastMapDirect();
        if (nodeid.equals(dgraph.mapNegIfBranch.get(predid))) {
            if (this.outNegVarVersions.containsKey(predid)) {
                mapNew = this.outNegVarVersions.get(predid).getCopy();
            }
        } else if (this.outVarVersions.containsKey(predid)) {
            mapNew = this.outVarVersions.get(predid).getCopy();
        }
        if ((isFinallyExit = dgraph.mapShortRangeFinallyPaths.containsKey(predid)) && !mapNew.isEmpty()) {
            SFormsFastMapDirect mapNewTemp = mapNew.getCopy();
            SFormsFastMapDirect mapTrueSource = new SFormsFastMapDirect();
            String exceptionDest = dgraph.mapFinallyMonitorExceptionPathExits.get(predid);
            boolean isExceptionMonitorExit = exceptionDest != null && !nodeid.equals(exceptionDest);
            HashSet<String> setLongPathWrapper = new HashSet<String>();
            for (FlattenStatementsHelper.FinallyPathWrapper finwraplong : dgraph.mapLongRangeFinallyPaths.get(predid)) {
                setLongPathWrapper.add(finwraplong.destination + "##" + finwraplong.source);
            }
            for (FlattenStatementsHelper.FinallyPathWrapper finwrap : dgraph.mapShortRangeFinallyPaths.get(predid)) {
                boolean recFinally = dgraph.mapShortRangeFinallyPaths.containsKey(finwrap.source);
                SFormsFastMapDirect map = recFinally ? this.getFilteredOutMap(finwrap.entry, finwrap.source, dgraph, destid) : (finwrap.entry.equals(dgraph.mapNegIfBranch.get(finwrap.source)) ? this.outNegVarVersions.get(finwrap.source) : this.outVarVersions.get(finwrap.source));
                boolean isFalsePath = true;
                if (recFinally) {
                    isFalsePath = !finwrap.destination.equals(nodeid);
                } else {
                    boolean bl = isFalsePath = !setLongPathWrapper.contains(destid + "##" + finwrap.source);
                }
                if (isFalsePath) {
                    mapNewTemp.complement(map);
                    continue;
                }
                if (mapTrueSource.isEmpty()) {
                    if (map == null) continue;
                    mapTrueSource = map.getCopy();
                    continue;
                }
                SSAConstructorSparseEx.mergeMaps(mapTrueSource, map);
            }
            if (isExceptionMonitorExit) {
                mapNew = mapTrueSource;
            } else {
                mapNewTemp.union(mapTrueSource);
                SFormsFastMapDirect oldInMap = this.inVarVersions.get(nodeid);
                if (oldInMap != null) {
                    mapNewTemp.union(oldInMap);
                }
                mapNew.intersection(mapNewTemp);
            }
        }
        return mapNew;
    }

    private static SFormsFastMapDirect mergeMaps(SFormsFastMapDirect mapTo, SFormsFastMapDirect map2) {
        if (map2 != null && !map2.isEmpty()) {
            mapTo.union(map2);
        }
        return mapTo;
    }

    private static boolean mapsEqual(SFormsFastMapDirect map1, SFormsFastMapDirect map2) {
        if (map1 == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>> ent2 : map2.entryList()) {
            if (InterpreterUtil.equalObjects(map1.get(ent2.getKey()), ent2.getValue())) continue;
            return false;
        }
        return true;
    }

    private void setCurrentVar(SFormsFastMapDirect varmap, Integer var, Integer vers) {
        FastSparseSetFactory.FastSparseSet<Integer> set = this.factory.spawnEmptySet();
        set.add(vers);
        varmap.put(var, set);
    }

    private void setCatchMaps(Statement stat, DirectGraph dgraph, FlattenStatementsHelper flatthelper) {
        switch (stat.type) {
            case 7: 
            case 12: {
                List<VarExprent> lstVars = stat.type == 12 ? ((CatchAllStatement)stat).getVars() : ((CatchStatement)stat).getVars();
                for (int i = 1; i < stat.getStats().size(); ++i) {
                    int varindex = lstVars.get(i - 1).getIndex();
                    int version = this.getNextFreeVersion(varindex);
                    SFormsFastMapDirect map = new SFormsFastMapDirect();
                    this.setCurrentVar(map, varindex, version);
                    this.extraVarVersions.put(dgraph.nodes.getWithKey((String)flatthelper.getMapDestinationNodes().get((Object)((Statement)stat.getStats().get((int)i)).id)[0]).id, map);
                    this.startVars.add(new VarVersionPair(varindex, version));
                }
                break;
            }
        }
        for (Statement st : stat.getStats()) {
            this.setCatchMaps(st, dgraph, flatthelper);
        }
    }

    private SFormsFastMapDirect createFirstMap(StructMethod mt) {
        boolean thisvar = !mt.hasModifier(8);
        MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
        int paramcount = md.params.length + (thisvar ? 1 : 0);
        int varindex = 0;
        SFormsFastMapDirect map = new SFormsFastMapDirect();
        for (int i = 0; i < paramcount; ++i) {
            int version = this.getNextFreeVersion(varindex);
            FastSparseSetFactory.FastSparseSet<Integer> set = this.factory.spawnEmptySet();
            set.add(version);
            map.put(varindex, set);
            this.startVars.add(new VarVersionPair(varindex, version));
            if (thisvar) {
                if (i == 0) {
                    ++varindex;
                    continue;
                }
                varindex += md.params[i - 1].stackSize;
                continue;
            }
            varindex += md.params[i].stackSize;
        }
        return map;
    }

    public HashMap<VarVersionPair, FastSparseSetFactory.FastSparseSet<Integer>> getPhi() {
        return this.phi;
    }

    public List<VarVersionPair> getStartVars() {
        return this.startVars;
    }
}

