/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.MutableInteger;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.Error;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;

final class TypeParser {
    private static final Type<?>[] PRIMITIVE_TYPES = new Type[16];

    TypeParser() {
    }

    public static Type<?> parse(String value) {
        VerifyArgument.notNullOrWhitespace((String)value, (String)"value");
        switch (value.charAt(0)) {
            case 'L': 
            case 'T': {
                if (value.charAt(value.length() - 1) != ';') break;
                return TypeParser.parseSignature(value);
            }
            case '[': {
                return TypeParser.parseSignature(value);
            }
        }
        int primitiveHash = TypeParser.hashPrimitiveName(value);
        Type<?> primitiveType = PRIMITIVE_TYPES[primitiveHash];
        if (primitiveType != null && value.equals(primitiveType.getName())) {
            return primitiveType;
        }
        try {
            Class<?> c = Class.forName(value);
            if (c != null) {
                return Type.of(c);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return TypeParser.parseTopLevelSignature(value, new MutableInteger());
    }

    public static Type<?> parseSignature(String signature) {
        VerifyArgument.notNullOrWhitespace((String)signature, (String)"signature");
        return TypeParser.parseTopLevelSignature(signature, new MutableInteger());
    }

    private static Type<?> parseTopLevelSignature(String s, MutableInteger position) {
        int i = position.getValue();
        if (i >= s.length()) {
            throw Error.invalidSignatureTypeExpected(s, i);
        }
        switch (s.charAt(i)) {
            case '*': {
                return Type.makeWildcard();
            }
            case '+': {
                return Type.makeExtendsWildcard(TypeParser.parseTopLevelSignature(s, position.increment()));
            }
            case '-': {
                return Type.makeSuperWildcard(TypeParser.parseTopLevelSignature(s, position.increment()));
            }
            case '[': {
                return TypeParser.parseTopLevelSignature(s, position.increment()).makeArrayType();
            }
            case 'B': {
                return PrimitiveTypes.Byte;
            }
            case 'C': {
                return PrimitiveTypes.Character;
            }
            case 'D': {
                return PrimitiveTypes.Double;
            }
            case 'F': {
                return PrimitiveTypes.Float;
            }
            case 'I': {
                return PrimitiveTypes.Integer;
            }
            case 'J': {
                return PrimitiveTypes.Long;
            }
            case 'L': {
                return TypeParser.finishTopLevelType(s, position);
            }
            case 'S': {
                return PrimitiveTypes.Short;
            }
            case 'T': {
                throw Error.invalidSignatureTopLevelGenericParameterUnexpected(s, position.getValue());
            }
            case 'V': {
                return PrimitiveTypes.Void;
            }
            case 'Z': {
                return PrimitiveTypes.Boolean;
            }
        }
        throw Error.invalidSignatureUnexpectedToken(s, i);
    }

    private static Type<?> finishTopLevelType(String s, MutableInteger position) {
        int i = position.getValue();
        assert (s.charAt(i) == 'L');
        StringBuilder sb = new StringBuilder();
        block9: while (++i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '/': {
                    sb.append('.');
                    continue block9;
                }
                case ';': {
                    try {
                        position.setValue(i + 1);
                        Type<?> resolvedType = Type.of(Class.forName(sb.toString()));
                        if (resolvedType.isGenericTypeDefinition()) {
                            return resolvedType.getErasedType();
                        }
                        return resolvedType;
                    }
                    catch (ClassNotFoundException e) {
                        throw Error.couldNotResolveType(sb);
                    }
                }
                case '<': {
                    try {
                        Type<?> resolvedType = Type.of(Class.forName(sb.toString()));
                        if (!resolvedType.isGenericType()) {
                            throw Error.invalidSignatureNonGenericTypeTypeArguments(resolvedType);
                        }
                        Type[] typeArguments = new Type[resolvedType.getTypeArguments().size()];
                        position.setValue(i);
                        TypeParser.parseTypeParameters(s, position, resolvedType, typeArguments);
                        i = position.getValue();
                        if (s.charAt(i) != ';') {
                            throw Error.invalidSignatureUnexpectedToken(s, i);
                        }
                        position.increment();
                        TypeBindings typeBindings = TypeBindings.create(resolvedType.getGenericTypeParameters(), typeArguments);
                        if (typeBindings.hasBoundParameters()) {
                            return resolvedType.makeGenericType(typeArguments);
                        }
                        return resolvedType;
                    }
                    catch (ClassNotFoundException e) {
                        throw Error.couldNotResolveType(sb);
                    }
                }
            }
            sb.append(c);
        }
        throw Error.invalidSignatureUnexpectedEnd(s, i);
    }

    private static void parseTypeParameters(String s, MutableInteger position, Type<?> resolvedType, Type<?>[] typeArguments) {
        int i = position.getValue();
        assert (s.charAt(i) == '<');
        position.increment();
        for (int j = 0; j < typeArguments.length; ++j) {
            typeArguments[j] = TypeParser.parseTypeArgument(s, position, resolvedType, j);
        }
        i = position.getValue();
        if (s.charAt(i) != '>') {
            throw Error.invalidSignatureExpectedEndOfTypeArguments(s, i);
        }
        position.increment();
    }

    private static Type<?> parseTypeArgument(String s, MutableInteger position, Type<?> genericType, int typeArgumentIndex) {
        int i = position.getValue();
        if (i >= s.length()) {
            throw Error.invalidSignatureExpectedTypeArgument(s, i);
        }
        switch (s.charAt(i)) {
            case '*': {
                return Type.makeWildcard();
            }
            case '+': {
                return Type.makeExtendsWildcard(TypeParser.parseTypeArgument(s, position.increment(), genericType, typeArgumentIndex));
            }
            case '-': {
                return Type.makeSuperWildcard(TypeParser.parseTypeArgument(s, position.increment(), genericType, typeArgumentIndex));
            }
            case '[': {
                return TypeParser.parseTypeArgument(s, position.increment(), genericType, typeArgumentIndex).makeArrayType();
            }
            case 'L': {
                return TypeParser.finishTopLevelType(s, position);
            }
            case 'T': {
                while (++i < s.length()) {
                    if (s.charAt(i) != ';') continue;
                    position.setValue(i + 1);
                    return (Type)genericType.getGenericTypeParameters().get(typeArgumentIndex);
                }
                throw Error.invalidSignatureExpectedTypeArgument(s, position.getValue());
            }
        }
        throw Error.invalidSignatureUnexpectedToken(s, i);
    }

    private static int hashPrimitiveName(String name) {
        if (name.length() < 3) {
            return 0;
        }
        return (name.charAt(0) + name.charAt(2)) % 16;
    }

    static {
        for (Type<?> t : PrimitiveTypes.allPrimitives()) {
            TypeParser.PRIMITIVE_TYPES[TypeParser.hashPrimitiveName((String)t.getName())] = t;
        }
    }
}

