/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.Comparer;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.CapturedType;
import com.strobel.reflection.Error;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.TypeVisitor;
import com.strobel.reflection.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.TypeVariable;
import javax.lang.model.type.TypeKind;

class GenericParameter<T>
extends Type<T> {
    private final String _name;
    private final int _position;
    private Type _upperBound;
    private Type _lowerBound;
    private MethodInfo _declaringMethod;
    private Type _declaringType;
    private Class<T> _erasedClass;
    private TypeVariable<?> _typeVariable;

    GenericParameter(String name, TypeVariable<?> typeVariable, int position) {
        this._typeVariable = typeVariable;
        this._name = (String)VerifyArgument.notNull((Object)name, (String)"name");
        this._declaringType = null;
        this._upperBound = Types.Object;
        this._lowerBound = Bottom;
        this._position = position;
    }

    GenericParameter(String name, Type declaringType, Type upperBound, int position) {
        this._name = (String)VerifyArgument.notNull((Object)name, (String)"name");
        this._declaringType = (Type)VerifyArgument.notNull((Object)declaringType, (String)"declaringType");
        this._upperBound = upperBound != null ? upperBound : Types.Object;
        this._lowerBound = Bottom;
        this._position = position;
    }

    GenericParameter(String name, MethodInfo declaringMethod, Type upperBound, int position) {
        this._name = (String)VerifyArgument.notNull((Object)name, (String)"name");
        this._declaringType = null;
        this._declaringMethod = (MethodInfo)VerifyArgument.notNull((Object)declaringMethod, (String)"declaringMethod");
        this._upperBound = upperBound != null ? upperBound : Types.Object;
        this._lowerBound = Bottom;
        this._position = position;
    }

    protected GenericParameter(String name, Type declaringType, Type upperBound, Type lowerBound, int position) {
        this._name = (String)VerifyArgument.notNull((Object)name, (String)"name");
        this._declaringType = (Type)VerifyArgument.notNull((Object)declaringType, (String)"declaringType");
        this._upperBound = upperBound != null ? upperBound : Types.Object;
        this._lowerBound = lowerBound != null ? lowerBound : Type.Bottom;
        this._position = position;
    }

    protected GenericParameter(String name, MethodInfo declaringMethod, Type upperBound, Type lowerBound, int position) {
        this._name = (String)VerifyArgument.notNull((Object)name, (String)"name");
        this._declaringType = null;
        this._declaringMethod = (MethodInfo)VerifyArgument.notNull((Object)declaringMethod, (String)"declaringMethod");
        this._upperBound = upperBound != null ? upperBound : Types.Object;
        this._lowerBound = lowerBound != null ? lowerBound : Type.Bottom;
        this._position = position;
    }

    final void setUpperBound(Type upperBound) {
        this._upperBound = upperBound;
    }

    final void setLowerBound(Type lowerBound) {
        this._lowerBound = lowerBound;
    }

    @Override
    public TypeList getExplicitInterfaces() {
        return TypeList.empty();
    }

    private TypeVariable<?> resolveTypeVariable() {
        for (TypeVariable typeVariable : this._declaringType.getErasedClass().getTypeParameters()) {
            if (!this._name.equals(typeVariable.getName())) continue;
            return typeVariable;
        }
        throw Error.couldNotResolveType(this._name);
    }

    private Class<?> resolveErasedClass() {
        if (this._upperBound != Types.Object) {
            return this._upperBound.getErasedClass();
        }
        return Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeVariable<?> getRawTypeVariable() {
        if (this._typeVariable == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._typeVariable == null) {
                    this._typeVariable = this.resolveTypeVariable();
                }
            }
        }
        return this._typeVariable;
    }

    @Override
    public MemberType getMemberType() {
        return MemberType.TypeInfo;
    }

    @Override
    public String getFullName() {
        return this._name;
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        sb.append(this.getFullName());
        Type<?> upperBound = this.getExtendsBound();
        if (upperBound != null && upperBound != Types.Object) {
            sb.append(" extends ");
            if (upperBound.isGenericParameter() || upperBound == this.getDeclaringType()) {
                return sb.append(upperBound.getFullName());
            }
            return upperBound.appendErasedDescription(sb);
        }
        return sb;
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        sb.append(this.getFullName());
        Type<?> upperBound = this.getExtendsBound();
        if (upperBound != null && upperBound != Types.Object) {
            sb.append(" extends ");
            if (upperBound.isGenericParameter() || upperBound == this.getDeclaringType()) {
                return sb.append(upperBound.getName());
            }
            return upperBound.appendErasedDescription(sb);
        }
        return sb;
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        return this.getExtendsBound().appendErasedDescription(sb);
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        return this.getExtendsBound().appendErasedSignature(sb);
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        return this.appendBriefDescription(sb);
    }

    @Override
    protected final StringBuilder _appendClassName(StringBuilder sb, boolean fullName, boolean dottedName) {
        return sb.append(this._name);
    }

    @Override
    public Type getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public MethodInfo getDeclaringMethod() {
        return this._declaringMethod;
    }

    public void setDeclaringMethod(MethodInfo declaringMethod) {
        this._declaringMethod = declaringMethod;
    }

    public void setDeclaringType(Type declaringType) {
        this._declaringType = declaringType;
    }

    @Override
    public boolean isGenericParameter() {
        return true;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.TYPEVAR;
    }

    @Override
    public Type<?> getSuperBound() {
        return this._lowerBound;
    }

    @Override
    public Type<?> getExtendsBound() {
        return this._upperBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<T> getErasedClass() {
        if (this._erasedClass == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._erasedClass == null) {
                    this._erasedClass = this.resolveErasedClass();
                }
            }
        }
        return this._erasedClass;
    }

    @Override
    public int getGenericParameterPosition() {
        return this._position;
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return null;
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return new Annotation[0];
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return new Annotation[0];
    }

    @Override
    public String toString() {
        return this.getFullName();
    }

    @Override
    public <P, R> R accept(TypeVisitor<P, R> visitor, P parameter) {
        return visitor.visitTypeParameter(this, parameter);
    }

    @Override
    public int hashCode() {
        return this.getGenericParameterPosition();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof GenericParameter) {
            if (obj instanceof CapturedType) {
                return false;
            }
            GenericParameter other = (GenericParameter)obj;
            return other._position == this._position && Comparer.equals(other.getRawTypeVariable(), this._typeVariable);
        }
        return false;
    }
}

